/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing.fields;

import edu.mit.broad.genome.swing.fields.ChangeValidatedDocument;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class GIntegerField
extends JTextField
implements GFieldPlusChooser {
    private final Toolkit toolkit = Toolkit.getDefaultToolkit();
    private final NumberFormat integerFormatter;

    public GIntegerField(Number number, int n) {
        this(number.intValue(), n);
    }

    public GIntegerField(Number number) {
        this(number, 5);
    }

    public GIntegerField(int n, int n2) {
        this(n, n2, NumberFormat.getNumberInstance());
    }

    public GIntegerField(int n, int n2, NumberFormat numberFormat) {
        super(new ChangeValidatedDocument(numberFormat), null, n2);
        this.integerFormatter = numberFormat;
        numberFormat.setParseIntegerOnly(true);
        this.setInt(n);
    }

    public final void setInt(int n) {
        super.setText(this.integerFormatter.format(n));
    }

    @Override
    public final void setText(String string) {
        if (string != null && string.length() > 0) {
            int n = Integer.parseInt(string);
            super.setText(this.integerFormatter.format(n));
        } else {
            super.setText("0");
        }
    }

    @Override
    public final Object getValue() {
        try {
            if (this.getText() == null) {
                return null;
            }
            return new Integer(this.getText());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public final int getIntValue() {
        int n = Integer.MIN_VALUE;
        try {
            n = this.integerFormatter.parse(this.getText()).intValue();
        }
        catch (ParseException parseException) {
            this.toolkit.beep();
            throw new IllegalStateException("Somehow the value is not a number: '" + this.getText() + "'");
        }
        return n;
    }

    public final int getIntValue(int n) {
        String string = this.getText();
        if (string == null || string.length() == 0) {
            return n;
        }
        return Integer.parseInt(string);
    }

    @Override
    public final void setValue(Object object) {
        Integer n = object == null ? new Integer(Integer.MIN_VALUE) : (object instanceof Float ? (Integer)object : new Integer(object.toString()));
        this.setText(n.toString());
    }

    @Override
    public final JComponent getComponent() {
        return this;
    }
}

