/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing.fields;

import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.genome.swing.fields.GFieldUtils;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class GFileField
extends JTextField
implements GFieldPlusChooser {
    public GFileField() {
        super(50);
    }

    public GFileField(File file) {
        this.setText(file.getAbsolutePath());
    }

    public GFileField(String string) {
        this.setText(string);
    }

    @Override
    public final void setText(String string) {
        super.setText(string);
        this.setForeground(GFieldUtils._getColor(string));
    }

    @Override
    public final Object getValue() {
        if (this.getText() == null) {
            return null;
        }
        return new File(this.getText());
    }

    public final File getFile() {
        Object object = this.getValue();
        if (object == null) {
            return null;
        }
        return (File)object;
    }

    @Override
    public final void setValue(Object object) {
        String string = object == null ? "" : (object instanceof File ? ((File)object).getAbsolutePath() : object.toString());
        this.setText(string);
    }

    @Override
    public final JComponent getComponent() {
        return this;
    }

    @Override
    public final void processKeyEvent(KeyEvent keyEvent) {
        Document document = this.getDocument();
        try {
            String string = this.getDocument().getText(0, document.getLength());
            this.setForeground(GFieldUtils.getFileFieldColor(string));
            super.processKeyEvent(keyEvent);
        }
        catch (BadLocationException badLocationException) {
            super.processKeyEvent(keyEvent);
        }
    }
}

