/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing.fields;

import edu.mit.broad.genome.parsers.AuxUtils;
import java.awt.Color;
import java.io.File;
import java.util.StringTokenizer;

public class GFieldUtils {
    public static final Color GOOD_COLOR = Color.blue;
    public static final Color ERROR_COLOR = Color.red;

    public static final Color getFileFieldColor(File file) {
        if (file == null) {
            return ERROR_COLOR;
        }
        if (file.getName().startsWith("http") || file.getName().startsWith("ftp") || file.getName().startsWith("gseaftp")) {
            return GOOD_COLOR;
        }
        if (file.exists()) {
            return GOOD_COLOR;
        }
        return ERROR_COLOR;
    }

    public static final Color getFileFieldColor(String string) {
        if (string == null) {
            return ERROR_COLOR;
        }
        if (string.startsWith("http") || string.startsWith("ftp") || string.startsWith("gseaftp")) {
            return GOOD_COLOR;
        }
        if ((string = string.trim()).indexOf(44) == -1) {
            return GFieldUtils._getColor(string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        for (int i2 = 0; i2 < n; ++i2) {
            if (GFieldUtils.isGoodPath(stringTokenizer.nextToken())) continue;
            return ERROR_COLOR;
        }
        return GOOD_COLOR;
    }

    public static final Color _getColor(String string) {
        if (GFieldUtils.isGoodPath(string)) {
            return GOOD_COLOR;
        }
        return ERROR_COLOR;
    }

    public static final boolean isGoodPath(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string.toLowerCase().startsWith("http") || string.toLowerCase().startsWith("www") || string.toLowerCase().startsWith("ftp") || string.toLowerCase().startsWith("gseaftp")) {
            return true;
        }
        File file = AuxUtils.getBaseFileFromFullPath(string);
        return file.exists();
    }
}

