/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing.fields;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.swing.choosers.GFileFieldPlusChooser;
import edu.mit.broad.genome.swing.fields.GColorFieldPlusChooser;
import edu.mit.broad.genome.swing.fields.GComboBoxField;
import edu.mit.broad.genome.swing.fields.GDirFieldPlusChooser;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser$Field;
import edu.mit.broad.genome.swing.fields.GFloatField;
import edu.mit.broad.genome.swing.fields.GIntegerField;
import edu.mit.broad.genome.swing.fields.GPasswordField2;
import edu.mit.broad.genome.swing.fields.GStringField;
import edu.mit.broad.genome.utils.ColorUtils;
import edu.mit.broad.genome.utils.NamedInteger;
import edu.mit.broad.genome.utils.containers.Password;
import java.awt.Color;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public final class FieldFactory {
    private static final Logger klog = XLogger.getLogger(FieldFactory.class);

    private FieldFactory() {
    }

    public static final GComboBoxField createTabPlacementField(int n) {
        NamedInteger[] namedIntegerArray = new NamedInteger[]{new NamedInteger(1, "Top"), new NamedInteger(3, "Bottom"), new NamedInteger(2, "Left"), new NamedInteger(4, "Right")};
        JComboBox<NamedInteger> jComboBox = new JComboBox<NamedInteger>(new DefaultComboBoxModel<NamedInteger>(namedIntegerArray));
        for (int i2 = 0; i2 < namedIntegerArray.length; ++i2) {
            if (namedIntegerArray[i2].getValue() != n) continue;
            jComboBox.setSelectedIndex(i2);
            break;
        }
        return new GComboBoxField(jComboBox);
    }

    public static final GFieldPlusChooser createFieldChooser(Object object) {
        if (object instanceof File) {
            return new GFileFieldPlusChooser();
        }
        if (object instanceof Color) {
            return new GColorFieldPlusChooser((Color)object);
        }
        if (object instanceof Password) {
            return new GPasswordField2(((Password)object).getPassword());
        }
        if (object instanceof String) {
            return new GStringField((String)object);
        }
        if (object instanceof Integer) {
            return new GIntegerField((Integer)object);
        }
        if (object instanceof Float) {
            return new GFloatField((Float)object);
        }
        klog.warn("Unknown fields: " + object);
        return new GStringField("Unknown fields: " + object);
    }

    public static final GFieldPlusChooser createFieldChooser(GFieldPlusChooser$Field gFieldPlusChooser$Field, String string) {
        if (gFieldPlusChooser$Field.equals(GFieldPlusChooser.FILE_FIELD)) {
            return FieldFactory.createFieldChooser(new File(string));
        }
        if (gFieldPlusChooser$Field.equals(GFieldPlusChooser.DIR_FIELD)) {
            GDirFieldPlusChooser gDirFieldPlusChooser = new GDirFieldPlusChooser();
            gDirFieldPlusChooser.setRootPath(string);
            return gDirFieldPlusChooser;
        }
        if (gFieldPlusChooser$Field.equals(GFieldPlusChooser.COLOR_FIELD)) {
            Color color = ColorUtils.colorForName(string, false);
            if (color == null) {
                return new GColorFieldPlusChooser();
            }
            return FieldFactory.createFieldChooser(color);
        }
        if (gFieldPlusChooser$Field.equals(GFieldPlusChooser.STRING_FIELD)) {
            if (string == null) {
                return FieldFactory.createFieldChooser("");
            }
            return FieldFactory.createFieldChooser(string);
        }
        if (gFieldPlusChooser$Field.equals(GFieldPlusChooser.INTEGER_FIELD)) {
            try {
                Integer n = new Integer(string);
                return FieldFactory.createFieldChooser(n);
            }
            catch (NumberFormatException numberFormatException) {
                klog.warn("Not an integer in fields!", numberFormatException);
                return FieldFactory.createFieldChooser(new Integer(-999));
            }
        }
        if (gFieldPlusChooser$Field.equals(GFieldPlusChooser.FLOAT_FIELD)) {
            try {
                Float f2 = new Float(string);
                return FieldFactory.createFieldChooser(f2);
            }
            catch (NumberFormatException numberFormatException) {
                klog.warn("Not an integer in fields!", numberFormatException);
                return FieldFactory.createFieldChooser(new Float(-999.0f));
            }
        }
        klog.warn("Unknown fields: " + gFieldPlusChooser$Field + " and value: " + string);
        return FieldFactory.createFieldChooser("Error! -- Unknown");
    }
}

