/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing.dnd;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.List;

public class StringTransferable
implements Transferable,
ClipboardOwner {
    public static final DataFlavor plainTextFlavor = DataFlavor.plainTextFlavor;
    public static final DataFlavor localStringFlavor = DataFlavor.stringFlavor;
    public static final DataFlavor[] flavors = new DataFlavor[]{plainTextFlavor, localStringFlavor};
    private static final List flavorList = Arrays.asList(flavors);
    private final String string;

    public StringTransferable(String string) {
        this.string = string;
    }

    private void dumpFlavor(DataFlavor dataFlavor) {
        System.out.println("getMimeType " + dataFlavor.getMimeType());
        System.out.println("getHumanPresentableName " + dataFlavor.getHumanPresentableName());
        System.out.println("getRepresentationClass " + dataFlavor.getRepresentationClass().getName());
        System.out.println("isMimeTypeSerializedObject " + dataFlavor.isMimeTypeSerializedObject());
        System.out.println("isRepresentationClassInputStream " + dataFlavor.isRepresentationClassInputStream());
        System.out.println("isRepresentationClassSerializable " + dataFlavor.isRepresentationClassSerializable());
        System.out.println("isRepresentationClassRemote " + dataFlavor.isRepresentationClassRemote());
        System.out.println("isFlavorSerializedObjectType " + dataFlavor.isFlavorSerializedObjectType());
        System.out.println("isFlavorRemoteObjectType " + dataFlavor.isFlavorRemoteObjectType());
        System.out.println("isFlavorJavaFileListType " + dataFlavor.isFlavorJavaFileListType());
    }

    @Override
    public final synchronized DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public final boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return flavorList.contains(dataFlavor);
    }

    @Override
    public final synchronized Object getTransferData(DataFlavor dataFlavor) {
        System.err.println("getTransferData(): ");
        this.dumpFlavor(dataFlavor);
        if (dataFlavor.equals(plainTextFlavor)) {
            return new ByteArrayInputStream(this.string.getBytes("Unicode"));
        }
        if (localStringFlavor.equals(dataFlavor)) {
            return this.string;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public final String toString() {
        return "StringTransferable";
    }

    @Override
    public final void lostOwnership(Clipboard clipboard, Transferable transferable) {
        System.out.println("StringTransferable lost ownership of " + clipboard.getName());
        System.out.println("data: " + transferable);
    }
}

