/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;

public class VerticalFlowLayout
extends FlowLayout {
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    int hgap;
    int vgap;
    boolean hfill;
    boolean vfill;

    public VerticalFlowLayout() {
        this(0, 5, 5, true, false);
    }

    public VerticalFlowLayout(boolean bl, boolean bl2) {
        this(0, 5, 5, bl, bl2);
    }

    public VerticalFlowLayout(int n) {
        this(n, 5, 5, true, false);
    }

    public VerticalFlowLayout(int n, boolean bl, boolean bl2) {
        this(n, 5, 5, bl, bl2);
    }

    public VerticalFlowLayout(int n, int n2, int n3, boolean bl, boolean bl2) {
        this.setAlignment(n);
        this.hgap = n2;
        this.vgap = n3;
        this.hfill = bl;
        this.vfill = bl2;
    }

    @Override
    public final int getHgap() {
        return this.hgap;
    }

    @Override
    public final void setHgap(int n) {
        super.setHgap(n);
        this.hgap = n;
    }

    @Override
    public final int getVgap() {
        return this.vgap;
    }

    @Override
    public final void setVgap(int n) {
        super.setVgap(n);
        this.vgap = n;
    }

    @Override
    public final Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
            Component component = container.getComponent(i2);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.getPreferredSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            if (i2 > 0) {
                dimension.height += this.vgap;
            }
            dimension.height += dimension2.height;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right + this.hgap * 2;
        dimension.height += insets.top + insets.bottom + this.vgap * 2;
        return dimension;
    }

    @Override
    public final Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
            Component component = container.getComponent(i2);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.getMinimumSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            if (i2 > 0) {
                dimension.height += this.vgap;
            }
            dimension.height += dimension2.height;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right + this.hgap * 2;
        dimension.height += insets.top + insets.bottom + this.vgap * 2;
        return dimension;
    }

    public final void setVerticalFill(boolean bl) {
        this.vfill = bl;
    }

    public final boolean getVerticalFill() {
        return this.vfill;
    }

    public final void setHorizontalFill(boolean bl) {
        this.hfill = bl;
    }

    public final boolean getHorizontalFill() {
        return this.hfill;
    }

    private void placethem(Container container, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.getAlignment();
        Insets insets = container.getInsets();
        if (n7 == 1) {
            n2 += n4 / 2;
        }
        if (n7 == 2) {
            n2 += n4;
        }
        for (int i2 = n5; i2 < n6; ++i2) {
            Component component = container.getComponent(i2);
            Dimension dimension = component.getSize();
            if (!component.isVisible()) continue;
            int n8 = n + (n3 - dimension.width) / 2;
            component.setLocation(n8, n2);
            n2 += this.vgap + dimension.height;
        }
    }

    @Override
    public final void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getSize().height - (insets.top + insets.bottom + this.vgap * 2);
        int n2 = container.getSize().width - (insets.left + insets.right + this.hgap * 2);
        int n3 = container.getComponentCount();
        int n4 = insets.left + this.hgap;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            Component component = container.getComponent(i2);
            if (!component.isVisible()) continue;
            Dimension dimension = component.getPreferredSize();
            if (this.vfill && i2 == n3 - 1) {
                dimension.height = Math.max(n - n5, component.getPreferredSize().height);
            }
            if (this.hfill) {
                component.setSize(n2, dimension.height);
                dimension.width = n2;
            } else {
                component.setSize(dimension.width, dimension.height);
            }
            if (n5 + dimension.height > n) {
                this.placethem(container, n4, insets.top + this.vgap, n6, n - n5, n7, i2);
                n5 = dimension.height;
                n4 += this.hgap + n6;
                n6 = dimension.width;
                n7 = i2;
                continue;
            }
            if (n5 > 0) {
                n5 += this.vgap;
            }
            n5 += dimension.height;
            n6 = Math.max(n6, dimension.width);
        }
        this.placethem(container, n4, insets.top + this.vgap, n6, n - n5, n7, n3);
    }
}

