/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JProgressBar;

public class ProgressMonitorInputStream2
extends FilterInputStream {
    private int nread = 0;
    private int size = 0;
    private JProgressBar fBar;

    public ProgressMonitorInputStream2(File file) {
        this(new FileInputStream(file));
    }

    public ProgressMonitorInputStream2(File file, JProgressBar jProgressBar) {
        this(new FileInputStream(file), jProgressBar);
    }

    public ProgressMonitorInputStream2(InputStream inputStream) {
        super(inputStream);
        try {
            this.size = inputStream.available();
        }
        catch (IOException iOException) {
            this.size = 0;
        }
        try {
            this.size = inputStream.available();
        }
        catch (IOException iOException) {
            this.size = 0;
        }
        this.fBar = new JProgressBar(0, this.size);
    }

    public ProgressMonitorInputStream2(InputStream inputStream, JProgressBar jProgressBar) {
        super(inputStream);
        try {
            this.size = inputStream.available();
        }
        catch (IOException iOException) {
            this.size = 0;
        }
        try {
            this.size = inputStream.available();
        }
        catch (IOException iOException) {
            this.size = 0;
        }
        this.fBar = jProgressBar;
        this.fBar.setMinimum(0);
        this.fBar.setMaximum(this.size);
        this.fBar.setValue(0);
    }

    public final JProgressBar getProgressBar() {
        return this.fBar;
    }

    @Override
    public final int read() {
        int n = this.in.read();
        if (n >= 0) {
            this.fBar.setValue(++this.nread);
        }
        return n;
    }

    @Override
    public final int read(byte[] byArray) {
        int n = this.in.read(byArray);
        if (n > 0) {
            this.fBar.setValue(this.nread += n);
        }
        return n;
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 > 0) {
            this.fBar.setValue(this.nread += n3);
        }
        return n3;
    }

    @Override
    public final long skip(long l2) {
        long l3 = this.in.skip(l2);
        if (l3 > 0L) {
            this.nread = (int)((long)this.nread + l3);
            this.fBar.setValue(this.nread);
        }
        return l3;
    }

    @Override
    public final void close() {
        this.in.close();
        this.fBar.setValue(this.fBar.getMaximum());
    }

    @Override
    public final synchronized void reset() {
        this.in.reset();
        this.nread = this.size - this.in.available();
        this.fBar.setValue(this.nread);
    }
}

