/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing;

import edu.mit.broad.genome.swing.MemoryMonitor;
import edu.mit.broad.genome.swing.MemoryMonitor$Surface$1;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Date;
import javax.swing.JPanel;

public class MemoryMonitor$Surface
extends JPanel
implements Runnable {
    public Thread thread;
    public long sleepAmount = 1000L;
    private int w;
    private int h;
    private BufferedImage bimg;
    private Graphics2D big;
    private final Font font = new Font("sansserif", 0, 11);
    private final Runtime r = Runtime.getRuntime();
    private int columnInc;
    private int[] pts;
    private int ptNum;
    private int ascent;
    private int descent;
    private float freeMemory;
    private float totalMemory;
    private final Rectangle graphOutlineRect = new Rectangle();
    private final Rectangle2D mfRect = new Rectangle2D.Float();
    private final Rectangle2D muRect = new Rectangle2D.Float();
    private final Line2D graphLine = new Line2D.Float();
    private final Color graphColor = new Color(46, 139, 87);
    private final Color mfColor = new Color(0, 100, 0);
    private String usedStr;
    final /* synthetic */ MemoryMonitor this$0;

    public MemoryMonitor$Surface(MemoryMonitor memoryMonitor) {
        this.this$0 = memoryMonitor;
        this.setBackground(Color.black);
        this.addMouseListener(new MemoryMonitor$Surface$1(this, memoryMonitor));
    }

    @Override
    public final Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public final Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public final Dimension getPreferredSize() {
        return new Dimension(135, 80);
    }

    @Override
    public final void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        if (this.big == null) {
            return;
        }
        this.big.setBackground(this.getBackground());
        this.big.clearRect(0, 0, this.w, this.h);
        float f2 = this.r.freeMemory();
        float f3 = this.r.totalMemory();
        this.big.setColor(Color.green);
        this.big.drawString(String.valueOf((int)f3 / 1024) + "K allocated", 4.0f, (float)this.ascent + 0.5f);
        this.usedStr = String.valueOf((int)(f3 - f2) / 1024) + "K used";
        this.big.drawString(this.usedStr, 4, this.h - this.descent);
        float f4 = this.ascent + this.descent;
        float f5 = (float)this.h - f4 * 2.0f - 0.5f;
        float f6 = f5 / 10.0f;
        float f7 = 20.0f;
        float f8 = (float)this.w - f7 - 10.0f;
        this.big.setColor(this.mfColor);
        int n4 = (int)(f2 / f3 * 10.0f);
        for (n3 = 0; n3 < n4; ++n3) {
            this.mfRect.setRect(5.0, f4 + (float)n3 * f6, f7, f6 - 1.0f);
            this.big.fill(this.mfRect);
        }
        this.big.setColor(Color.green);
        while (n3 < 10) {
            this.muRect.setRect(5.0, f4 + (float)n3 * f6, f7, f6 - 1.0f);
            this.big.fill(this.muRect);
            ++n3;
        }
        this.big.setColor(this.graphColor);
        int n5 = 30;
        int n6 = (int)f4;
        int n7 = this.w - n5 - 5;
        int n8 = (int)f5;
        this.graphOutlineRect.setRect(n5, n6, n7, n8);
        this.big.draw(this.graphOutlineRect);
        int n9 = n8 / 10;
        for (n2 = n6; n2 <= n8 + n6; n2 += n9) {
            this.graphLine.setLine(n5, n2, n5 + n7, n2);
            this.big.draw(this.graphLine);
        }
        n2 = n7 / 15;
        if (this.columnInc == 0) {
            this.columnInc = n2;
        }
        for (n = n5 + this.columnInc; n < n7 + n5; n += n2) {
            this.graphLine.setLine(n, n6, n, n6 + n8);
            this.big.draw(this.graphLine);
        }
        --this.columnInc;
        if (this.pts == null) {
            this.pts = new int[n7];
            this.ptNum = 0;
        } else if (this.pts.length != n7) {
            int[] nArray = null;
            if (this.ptNum < n7) {
                nArray = new int[this.ptNum];
                System.arraycopy(this.pts, 0, nArray, 0, nArray.length);
            } else {
                nArray = new int[n7];
                System.arraycopy(this.pts, this.pts.length - nArray.length, nArray, 0, nArray.length);
                this.ptNum = nArray.length - 2;
            }
            this.pts = new int[n7];
            System.arraycopy(nArray, 0, this.pts, 0, nArray.length);
        } else {
            this.big.setColor(Color.yellow);
            this.pts[this.ptNum] = (int)((float)n6 + (float)n8 * (f2 / f3));
            n = n5 + n7 - this.ptNum;
            int n10 = 0;
            while (n10 < this.ptNum) {
                if (n10 != 0) {
                    if (this.pts[n10] != this.pts[n10 - 1]) {
                        this.big.drawLine(n - 1, this.pts[n10 - 1], n, this.pts[n10]);
                    } else {
                        this.big.fillRect(n, this.pts[n10], 1, 1);
                    }
                }
                ++n10;
                ++n;
            }
            if (this.ptNum + 2 == this.pts.length) {
                for (n = 1; n < this.ptNum; ++n) {
                    this.pts[n - 1] = this.pts[n];
                }
                --this.ptNum;
            } else {
                ++this.ptNum;
            }
        }
        graphics.drawImage(this.bimg, 0, 0, this);
    }

    public final void start() {
        this.thread = new Thread(this);
        this.thread.setPriority(1);
        this.thread.setName("MemoryMonitor");
        this.thread.start();
    }

    public final synchronized void stop() {
        this.thread = null;
        this.notify();
    }

    @Override
    public final void run() {
        Thread thread = Thread.currentThread();
        while (this.thread == thread && !this.isShowing() || this.getSize().width == 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        while (this.thread == thread && this.isShowing()) {
            Dimension dimension = this.getSize();
            if (dimension.width != this.w || dimension.height != this.h) {
                this.w = dimension.width;
                this.h = dimension.height;
                this.bimg = (BufferedImage)this.createImage(this.w, this.h);
                this.big = this.bimg.createGraphics();
                this.big.setFont(this.font);
                FontMetrics fontMetrics = this.big.getFontMetrics(this.font);
                this.ascent = fontMetrics.getAscent();
                this.descent = fontMetrics.getDescent();
            }
            this.repaint();
            try {
                Thread.sleep(this.sleepAmount);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            if (!MemoryMonitor.dateStampCB.isSelected()) continue;
            System.out.println(new Date().toString() + " " + this.usedStr);
        }
        this.thread = null;
    }
}

