/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing;

import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class GThreadPriorityBox
extends JComboBox {
    private static final String LOW_HTML = "<html><body>Low <font color=\"#C0C0C0\">(cpu usage)</font></body></html>";
    private static final String NORMAL_HTML = "<html><body>Normal <font color=\"#C0C0C0\">(cpu usage)</font></body></html>";
    private static final String HIGH_HTML = "<html><body>High <font color=\"#C0C0C0\">(cpu usage)</font></body></html>";
    private static final String LOW = "Low";
    private static final String NORMAL = "Normal";
    private static final String HIGH = "High";
    private boolean fShowGrayHelpText;

    public GThreadPriorityBox(String[] stringArray, boolean bl, boolean bl2, boolean bl3) {
        this.fShowGrayHelpText = bl3;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this._low());
        arrayList.add(this._normal());
        if (bl) {
            arrayList.add(this._high());
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(stringArray[i2]);
        }
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(arrayList.toArray(new String[arrayList.size()]));
        this.setModel(defaultComboBoxModel);
        if (bl2) {
            this.setSelectedItem(this._normal());
        } else {
            this.setSelectedItem(this._low());
        }
        this.setToolTipText("Set the priority of this Task - low to high cpu usage");
    }

    public GThreadPriorityBox(boolean bl, boolean bl2, boolean bl3) {
        this(new String[0], bl, bl2, bl3);
    }

    public final void setSelectedPriority(int n) {
        this.setSelectedItem(this.getPriorityStringValue(n));
    }

    public final String getPriorityStringValue(int n) {
        if (n == 1) {
            return this._low();
        }
        if (n == 5) {
            return this._normal();
        }
        if (n == 10) {
            return this._high();
        }
        throw new IllegalArgumentException("Unknown Thread priority code: " + n);
    }

    public final int getPriority() {
        String string = this.getSelectedItem().toString();
        if (string.equals(this._low())) {
            return 1;
        }
        if (string.equals(this._high())) {
            return 10;
        }
        if (string.equals(this._normal())) {
            return 5;
        }
        return -1;
    }

    private String _low() {
        if (this.fShowGrayHelpText) {
            return LOW_HTML;
        }
        return LOW;
    }

    private String _normal() {
        if (this.fShowGrayHelpText) {
            return NORMAL_HTML;
        }
        return NORMAL;
    }

    private String _high() {
        if (this.fShowGrayHelpText) {
            return HIGH_HTML;
        }
        return HIGH;
    }
}

