/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.reports.pages;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.objects.strucs.Hyperlink;
import edu.mit.broad.genome.objects.strucs.Linked;
import edu.mit.broad.genome.reports.pages.HtmlFormat;
import edu.mit.broad.genome.reports.pages.HtmlFormat$THs;
import edu.mit.broad.genome.reports.pages.Page;
import java.io.File;
import org.apache.ecs.Element;
import org.apache.ecs.html.A;
import org.apache.ecs.html.BR;
import org.apache.ecs.html.Div;
import org.apache.ecs.html.Font;
import org.apache.ecs.html.TD;
import org.apache.ecs.html.TH;
import org.apache.ecs.html.TR;
import org.apache.ecs.html.Table;

public class KeyValTable {
    private Table fTable = new Table(0);
    private int fFloatFormatPrecision;

    public KeyValTable() {
        this("", "");
    }

    public KeyValTable(int n) {
        this("", "", n);
    }

    public KeyValTable(String string, String string2) {
        this(string, string2, -1);
    }

    public KeyValTable(String string, String string2, int n) {
        this.fTable.setCols(2);
        this.fTable.addElement(HtmlFormat$THs.keyValTable(string));
        this.fTable.addElement(HtmlFormat$THs.keyValTable(string2));
        this.fFloatFormatPrecision = n;
    }

    public KeyValTable(Element element, Element element2) {
        this.fTable.setCols(2);
        this.fTable.addElement(new TH(element));
        this.fTable.addElement(new TH(element2));
        this.fFloatFormatPrecision = -1;
    }

    public final Table getTable() {
        return this.fTable;
    }

    public final void addRow(String string, Element element) {
        this._addRow(string, element);
    }

    public final void addRow(String string, String string2) {
        this._addRow(string, string2);
    }

    public final void addRow(String string) {
        this._addRow(string, null);
    }

    public final void addRow(String string, Linked linked) {
        this._addRow(string, linked);
    }

    public final void addRow(String string, Linked[] linkedArray) {
        if (linkedArray == null || linkedArray.length == 0) {
            this._addRow(string, "");
            return;
        }
        TR tR = new TR();
        tR.addElement(HtmlFormat._td(string));
        TD tD = new TD();
        for (int i2 = 0; i2 < linkedArray.length; ++i2) {
            A a2 = new A(linkedArray[i2].createDefaultLink().getURL(), linkedArray[i2].getText());
            tD.addElement(a2);
            if (i2 != linkedArray.length - 1) {
                tD.addElement("&nbsp&nbsp");
            }
            if (i2 == 0 || !(i2 % 3 == 0 & i2 != linkedArray.length - 1)) continue;
            tD.addElement("<BR>");
        }
        tR.addElement(tD);
        this.fTable.addElement(tR);
    }

    public final void addRow(String string, Hyperlink hyperlink) {
        this._addRow(string, hyperlink);
    }

    public final void addRow(String string, int n) {
        this._addRow(string, new Integer(n));
    }

    public final void addRow(String string, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this._addRow(string, "");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuffer.append(stringArray[i2]);
            if (i2 == stringArray.length - 1) continue;
            stringBuffer.append('\u001c');
        }
        this._addRow(string, stringBuffer.toString());
    }

    public final void addRow(String string, float f2) {
        Object object = this.fFloatFormatPrecision != -1 ? Printf.format(f2, this.fFloatFormatPrecision) : new Float(f2);
        this._addRow(string, object);
    }

    public final void addRow(String string, double d2) {
        this.addRow(string, (float)d2);
    }

    public final void addRowLink(Page page) {
        if (page == null) {
            this._addRow("na", null);
        } else {
            String string = NamingConventions.createSafeFileName(page.getName());
            this.addRow("", new A(string + "." + page.getExt(), page.getDesc()));
        }
    }

    public final void addRowLinkHtmlExcel(String string, Page page, File file) {
        String string2 = NamingConventions.createSafeFileName(page.getName());
        A a2 = new A(string2 + "." + page.getExt(), "HTML");
        A a3 = new A(file.getName(), "TEXT");
        Div div = new Div();
        div.addElement(a2);
        div.addElement(new BR());
        div.addElement(a3);
        this.addRow(string, div);
    }

    public final void _addRow(String string, Object object) {
        TR tR = new TR();
        tR.addElement(HtmlFormat._td(string));
        tR.addElement(HtmlFormat._td(object));
        this.fTable.addElement(tR);
    }

    public final void _addRow_tmp(String string, Object object) {
        TR tR = new TR();
        TD tD = new TD();
        tD.setNoWrap(true);
        Font font = new Font(1, "arial");
        font.addElement(string);
        tD.addElement(font);
        tR.addElement(tD);
        tD = new TD();
        tD.setNoWrap(true);
        font = new Font(1, "arial");
        if (object != null) {
            font.addElement(object.toString());
        }
        tD.addElement(font);
        tR.addElement(tD);
        this.fTable.addElement(tR);
    }
}

