/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.reports.pages;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.TraceUtils;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.charts.XChart;
import edu.mit.broad.genome.charts.XComboChart;
import edu.mit.broad.genome.objects.IDataframe;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.reports.RichDataframe;
import edu.mit.broad.genome.reports.RichDataframe$MetaData;
import edu.mit.broad.genome.reports.api.PicFile;
import edu.mit.broad.genome.reports.pages.HtmlFormat;
import edu.mit.broad.genome.reports.pages.HtmlFormat$Divs;
import edu.mit.broad.genome.reports.pages.HtmlFormat$TDs;
import edu.mit.broad.genome.reports.pages.HtmlFormat$THs;
import edu.mit.broad.genome.reports.pages.HtmlFormat$Titles;
import edu.mit.broad.genome.reports.pages.KeyValTable;
import edu.mit.broad.genome.reports.pages.Page;
import edu.mit.broad.genome.utils.ImageUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.ecs.Document;
import org.apache.ecs.MultiPartElement;
import org.apache.ecs.html.A;
import org.apache.ecs.html.BR;
import org.apache.ecs.html.Div;
import org.apache.ecs.html.H4;
import org.apache.ecs.html.HR;
import org.apache.ecs.html.TD;
import org.apache.ecs.html.TR;
import org.apache.ecs.html.Table;
import org.apache.log4j.Logger;

public class HtmlPage
implements Page {
    private String fName;
    private String fTitle;
    private Document fDoc;
    private Logger log = XLogger.getLogger(HtmlPage.class);
    private static final Logger klog = XLogger.getLogger(HtmlPage.class);
    private int fPicCnt = 1;
    private List fPicFiles;
    boolean sectionStarted = false;

    public HtmlPage(String string, String string2) {
        this.fTitle = string2;
        this.fName = string;
        this.fPicFiles = new ArrayList();
        this.fDoc = new Document();
        HtmlFormat.setCommonDocThings(this.fTitle, this.fDoc);
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getDesc() {
        return this.fTitle;
    }

    @Override
    public String getExt() {
        return "html";
    }

    public final Document getDoc() {
        return this.fDoc;
    }

    public final void startSection(String string) {
        if (this.sectionStarted) {
            this.log.warn("Starting a new section without ending the previous one!");
        }
        Div div = new Div();
        H4 h4 = new H4(string);
        div.addElement(h4);
        this.addBlock(div);
        this.sectionStarted = true;
    }

    public final void endSection() {
        if (!this.sectionStarted) {
            this.log.warn("Ending a section without starting one!");
        }
        Div div = new Div();
        div.addElement(new HR());
        this.addBlock(div);
        this.sectionStarted = false;
    }

    public final void addError(String string, Throwable throwable) {
        this.log.error(string, throwable);
        Div div = HtmlFormat$Divs.error();
        div.addElement(string);
        div.addElement(new BR());
        div.addElement(TraceUtils.getAsString(throwable));
        this.addBlock(div);
    }

    public void addError(String string) {
        Div div = HtmlFormat$Divs.error();
        div.addElement(string);
        this.addBlock(div);
    }

    public final void addBreak() {
        this.fDoc.appendBody(new BR());
    }

    public final void addHR() {
        this.fDoc.appendBody(new HR());
    }

    public final void addChart(XChart xChart, int n, int n2) {
        try {
            PicFile picFile = new PicFile(xChart, n, n2, this.fPicCnt++);
            this.fPicFiles.add(picFile);
            this.addBlock(picFile.createIMG());
        }
        catch (Throwable throwable) {
            this.addError("Trouble saving image", throwable);
        }
    }

    public final void addChart(XComboChart xComboChart, int n, int n2) {
        this.addChart(xComboChart.getCombinedChart(), n, n2);
    }

    public final void addImage(String string, String string2, String string3, Image image, int n, int n2, ImageObserver imageObserver) {
        BufferedImage bufferedImage = ImageUtils.toBufferedImage(image, imageObserver);
        this.addImage(string, string2, string3, bufferedImage, n, n2);
    }

    public final void addImage(String string, String string2, String string3, Image image, ImageObserver imageObserver) {
        this.addImage(string, string2, string3, image, image.getWidth(imageObserver), image.getHeight(imageObserver), imageObserver);
    }

    public final void addImage(String string, String string2, String string3, BufferedImage bufferedImage) {
        this.addImage(string, string2, string3, bufferedImage, 500, 500);
    }

    public final void addImage(String string, String string2, Image image, int n, int n2, ImageObserver imageObserver) {
        throw new NotImplementedException();
    }

    public final void addImage(String string, String string2, Image image, ImageObserver imageObserver) {
        this.addImage(NamingConventions.createSafeFileName(string), string, string2, image, image.getWidth(imageObserver), image.getHeight(imageObserver), imageObserver);
    }

    public final void addImage(String string, String string2, BufferedImage bufferedImage) {
        this.addImage(NamingConventions.createSafeFileName(string), string, string2, bufferedImage);
    }

    public final void addImage(String string, String string2, String string3, BufferedImage bufferedImage, int n, int n2) {
        try {
            PicFile picFile = new PicFile(string, string2, string3, bufferedImage, n, n2, this.fPicCnt++);
            this.fPicFiles.add(picFile);
            this.addBlock(picFile.createIMG());
        }
        catch (Throwable throwable) {
            this.addError("Trouble saving image", throwable);
        }
    }

    public final void addBlock(Div div) {
        this.addBlock(div, true);
    }

    public final void addBlock(Div div, boolean bl) {
        this.fDoc.appendBody(div);
        if (bl) {
            this.fDoc.appendBody(new BR());
        }
    }

    public final void addTable(String string, KeyValTable keyValTable) {
        Table table = keyValTable.getTable();
        String string2 = this._noNull(string);
        table.addElement(HtmlFormat$Titles.table(string2));
        Div div = HtmlFormat$Divs.keyValTable();
        div.addElement(table);
        this.addBlock(div);
    }

    public final void addTable(String string, StringDataframe stringDataframe, boolean bl, boolean bl2) {
        this.addTable(string, new RichDataframe(stringDataframe, null), bl, bl2);
    }

    public final void addTable(String string, IDataframe iDataframe, boolean bl, boolean bl2) {
        int n;
        Table table = new Table();
        int n2 = iDataframe.getNumCol();
        if (bl2) {
            ++n2;
        }
        if (bl) {
            ++n2;
        }
        table.setCols(n2);
        if (bl2) {
            table.addElement(HtmlFormat$THs.dataTable());
        }
        if (bl) {
            table.addElement(HtmlFormat$THs.dataTable("NAME"));
        }
        for (n = 0; n < iDataframe.getNumCol(); ++n) {
            table.addElement(HtmlFormat$THs.dataTable(iDataframe.getColumnName(n)));
        }
        for (n = 0; n < iDataframe.getNumRow(); ++n) {
            TR tR = new TR();
            if (bl2) {
                tR.addElement(HtmlFormat._td(n + 1));
            }
            if (bl) {
                tR.addElement(HtmlFormat._td(iDataframe.getRowName(n)));
            }
            for (int i2 = 0; i2 < iDataframe.getNumCol(); ++i2) {
                tR.addElement(HtmlFormat._td(iDataframe.getElementObj(n, i2)));
            }
            table.addElement(tR);
        }
        Div div = HtmlFormat$Divs.dataTable();
        table.addElement(HtmlFormat$Titles.table(string));
        div.addElement(table);
        this.addBlock(div);
    }

    public final void addTable(String string, Table table) {
        Div div = HtmlFormat$Divs.dataTable();
        table.addElement(HtmlFormat$Titles.table(string));
        div.addElement(table);
        this.addBlock(div);
    }

    public final void addTable(RichDataframe richDataframe, String string, boolean bl, boolean bl2) {
        MultiPartElement multiPartElement;
        int n;
        Table table = new Table();
        table.setBorder(1);
        int n2 = richDataframe.getNumCol();
        RichDataframe$MetaData richDataframe$MetaData = richDataframe.getMetaData();
        if (bl2) {
            ++n2;
        }
        if (bl) {
            ++n2;
        }
        table.setCols(n2);
        if (bl2) {
            table.addElement(HtmlFormat$THs.richTable(""));
        }
        if (bl) {
            table.addElement(HtmlFormat$THs.richTable("NAME"));
        }
        for (n = 0; n < richDataframe.getNumCol(); ++n) {
            table.addElement(HtmlFormat$THs.richTable(richDataframe.getColumnName(n)));
        }
        for (n = 0; n < richDataframe.getNumRow(); ++n) {
            multiPartElement = new TR();
            if (bl2) {
                ((TR)multiPartElement).addElement(HtmlFormat$TDs.lessen(n + 1 + ""));
            }
            if (bl) {
                ((TR)multiPartElement).addElement(HtmlFormat._td(richDataframe.getRowName(n)));
            }
            for (int i2 = 0; i2 < richDataframe.getNumCol(); ++i2) {
                TD tD;
                Object object = richDataframe.getElementObj(n, i2);
                if (object != null) {
                    String string2;
                    String string3 = richDataframe$MetaData != null ? richDataframe$MetaData.adjustPrecision(object, i2).toString() : object.toString();
                    tD = HtmlFormat._td(string3, richDataframe.getElementColor(n, i2), richDataframe.getElementLink(n, i2));
                    if (richDataframe$MetaData != null && (string2 = richDataframe$MetaData.getColumnAlignment(i2)) != null) {
                        tD.setAlign(string2);
                    }
                } else {
                    tD = new TD();
                }
                ((TR)multiPartElement).addElement(tD);
            }
            table.addElement(multiPartElement);
        }
        String string4 = "na";
        if (richDataframe.getMetaData() != null) {
            string4 = this._noNull(richDataframe.getMetaData().getTitle());
        }
        if (string != null) {
            multiPartElement = new A(string, "[plain text format]");
            string4 = string4 + "&nbsp" + multiPartElement.toString();
            table.addElement(HtmlFormat$Titles.table(string4));
        }
        multiPartElement = HtmlFormat$Divs.richTable();
        ((Div)multiPartElement).addElement(table);
        this.addBlock((Div)multiPartElement);
    }

    private String _noNull(String string) {
        if (string == null) {
            return "na";
        }
        return string;
    }

    public final void addHtml(String string) {
        this.fDoc.getHtml().addElement(string);
    }

    @Override
    public PicFile[] write(OutputStream outputStream, File file) {
        for (int i2 = 0; i2 < this.fPicFiles.size(); ++i2) {
            PicFile picFile = (PicFile)this.fPicFiles.get(i2);
            picFile.save(file);
        }
        this.fDoc.output(outputStream);
        outputStream.close();
        return this.fPicFiles.toArray(new PicFile[this.fPicFiles.size()]);
    }
}

