/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.reports;

import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.alg.distrib.RangeFactory;
import edu.mit.broad.genome.charts.XChart;
import edu.mit.broad.genome.charts.XChartImpl;
import edu.mit.broad.genome.math.ColorScheme;
import edu.mit.broad.genome.math.Range;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.models.XYDatasetProxy2;
import edu.mit.broad.genome.models.XYDatasetVERT;
import edu.mit.broad.genome.objects.ColorDataset;
import edu.mit.broad.genome.objects.MetricWeightStruc;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.reports.DatasetCharts;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;

public class RankedListCharts {
    public static final XChart createRankedListChart(RankedList rankedList, String string, String string2, boolean bl) {
        String string3 = "Ranked Gene List Correlation Profile";
        XYPlot xYPlot = RankedListCharts._createRankedListChart(rankedList, string, string2, bl);
        MetricWeightStruc metricWeightStruc = rankedList.getMetricWeightStruc();
        if (metricWeightStruc != null) {
            ValueMarker valueMarker = new ValueMarker(metricWeightStruc.getTotalPosLength());
            valueMarker.setPaint(Color.BLACK);
            valueMarker.setStroke(new BasicStroke(1.0f, 0, 0, 5.0f, new float[]{10.0f, 5.0f, 5.0f, 5.0f}, 0.0f));
            float f2 = metricWeightStruc.getTotalPosWeight_frac() * 100.0f;
            String string4 = Printf.format(f2, 1);
            String string5 = Printf.format(metricWeightStruc.getTotalPosLength_frac() * 100.0f, 1);
            String string6 = "Corr. area bias to " + string + " = " + string4 + "% & Zero crossing at rank " + metricWeightStruc.getTotalPosLength() + " (" + string5 + "%)";
            valueMarker.setLabel(string6);
            valueMarker.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
            xYPlot.addDomainMarker(valueMarker);
        }
        return new XChartImpl("ranked_list_corr", string3, "Ranked list correlations for " + rankedList.getName(), xYPlot, false);
    }

    public static final XChart createRankedListChart(RankedList rankedList, String string, String string2, int n, boolean bl) {
        String string3 = "Ranked Gene List Correlation Profile";
        XYPlot xYPlot = RankedListCharts._createRankedListChart(rankedList, string, string2, bl);
        MetricWeightStruc metricWeightStruc = rankedList.getMetricWeightStruc();
        if (metricWeightStruc != null) {
            ValueMarker valueMarker = new ValueMarker(metricWeightStruc.getTotalPosLength());
            valueMarker.setPaint(Color.BLACK);
            valueMarker.setStroke(new BasicStroke(0.25f, 0, 0, 3.0f, new float[]{5.0f, 3.0f, 3.0f, 3.0f}, 0.0f));
            String string4 = "Zero cross at " + metricWeightStruc.getTotalPosLength();
            valueMarker.setLabel(string4);
            valueMarker.setLabelAnchor(RectangleAnchor.CENTER);
            xYPlot.addDomainMarker(valueMarker);
        }
        return new XChartImpl("ranked_list_corr", string3, "Ranked list correlations for " + rankedList.getName(), xYPlot, false);
    }

    private static XYPlot _createRankedListChart(RankedList rankedList, String string, String string2, boolean bl) {
        XYPlot xYPlot;
        String string3 = "Ranked list metric";
        MetricWeightStruc metricWeightStruc = rankedList.getMetricWeightStruc();
        if (metricWeightStruc != null && metricWeightStruc.getMetricName() != null) {
            string3 = string3 + " (" + metricWeightStruc.getMetricName() + ")";
        }
        NumberAxis numberAxis = new NumberAxis("Gene list location");
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis(string3);
        numberAxis2.setTickMarksVisible(false);
        numberAxis2.setTickLabelsVisible(true);
        if (bl) {
            XYDatasetProxy2 xYDatasetProxy2 = new XYDatasetProxy2(rankedList.getScoresV(false), "Ranking metric scores");
            StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer(10);
            xYPlot = new XYPlot(xYDatasetProxy2, numberAxis, numberAxis2, standardXYItemRenderer);
        } else {
            XYDatasetVERT xYDatasetVERT = new XYDatasetVERT(rankedList.getScoresV(false), "Ranking metric scores");
            StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer(2);
            xYPlot = new XYPlot(xYDatasetVERT, numberAxis2, numberAxis, standardXYItemRenderer);
        }
        xYPlot.getRenderer().setSeriesPaint(0, Color.LIGHT_GRAY);
        if (string != null || string2 != null) {
            IntervalMarker intervalMarker;
            Vector vector = rankedList.getScoresV(false);
            float f2 = vector.min();
            float f3 = vector.max();
            if (string != null && string.length() > 0) {
                intervalMarker = new IntervalMarker(f3, f3);
                intervalMarker.setLabel("'" + string + "' (positively correlated)");
                intervalMarker.setLabelFont(new Font("SansSerif", 0, 10));
                intervalMarker.setLabelAnchor(RectangleAnchor.LEFT);
                intervalMarker.setLabelTextAnchor(TextAnchor.CENTER_LEFT);
                intervalMarker.setLabelPaint(Color.RED);
                if (bl) {
                    xYPlot.addRangeMarker(intervalMarker);
                } else {
                    xYPlot.addDomainMarker(intervalMarker);
                }
            }
            if (string2 != null && string2.length() > 0) {
                intervalMarker = new IntervalMarker(f2, f2);
                intervalMarker.setLabel("'" + string2 + "' (negatively correlated)");
                intervalMarker.setLabelFont(new Font("SansSerif", 0, 10));
                intervalMarker.setLabelAnchor(RectangleAnchor.BOTTOM);
                intervalMarker.setLabelTextAnchor(TextAnchor.CENTER_LEFT);
                intervalMarker.setLabelPaint(Color.BLUE);
                if (bl) {
                    xYPlot.addRangeMarker(intervalMarker);
                } else {
                    xYPlot.addDomainMarker(intervalMarker);
                }
            }
        }
        return xYPlot;
    }

    public static final IntervalMarker[] createIntervalMarkers(int n, RankedList rankedList) {
        ArrayList<IntervalMarker> arrayList = new ArrayList<IntervalMarker>();
        RankedList rankedList2 = rankedList.extractRanked(ScoreMode.POS_ONLY);
        Range[] rangeArray = RangeFactory.createRanges(n, 0.0, (double)rankedList2.getSize());
        IntervalMarker[] intervalMarkerArray = RankedListCharts._createIntervalMarkers(n, rankedList2, rangeArray, 0, DatasetCharts.RED);
        arrayList.addAll(Arrays.asList(intervalMarkerArray));
        RankedList rankedList3 = rankedList.extractRanked(ScoreMode.NEG_ONLY);
        rangeArray = RangeFactory.createRanges(n, (double)rankedList2.getSize(), (double)rankedList.getSize());
        intervalMarkerArray = RankedListCharts._createIntervalMarkers(n, rankedList3, rangeArray, rankedList2.getSize() + 1, DatasetCharts.BLUE);
        arrayList.addAll(Arrays.asList(intervalMarkerArray));
        return arrayList.toArray(new IntervalMarker[arrayList.size()]);
    }

    private static IntervalMarker[] _createIntervalMarkers(int n, RankedList rankedList, Range[] rangeArray, int n2, ColorScheme colorScheme) {
        ColorDataset colorDataset = new DatasetGenerators().createColorDataset(n, rankedList, colorScheme);
        IntervalMarker[] intervalMarkerArray = new IntervalMarker[n];
        double d2 = n2;
        for (int i2 = 0; i2 < rangeArray.length; ++i2) {
            intervalMarkerArray[i2] = new IntervalMarker(d2, rangeArray[i2].getMax());
            d2 = rangeArray[i2].getMin();
            intervalMarkerArray[i2].setPaint(colorDataset.getColor(0, i2));
        }
        return intervalMarkerArray;
    }
}

