/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.reports;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.alg.ComparatorFactory$EnrichmentResultByNESComparator;
import edu.mit.broad.genome.alg.gsea.Norms;
import edu.mit.broad.genome.alg.gsea.PValueCalculatorImpls$GseaImpl;
import edu.mit.broad.genome.charts.XChart;
import edu.mit.broad.genome.charts.XChartImpl;
import edu.mit.broad.genome.charts.XChartUtils;
import edu.mit.broad.genome.charts.XComboChart;
import edu.mit.broad.genome.charts.XComboDomainChart;
import edu.mit.broad.genome.charts.XComboRangeChart;
import edu.mit.broad.genome.math.BooleanVector;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.StringMatrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.models.XYDatasetMultiTmp;
import edu.mit.broad.genome.models.XYDatasetVERT;
import edu.mit.broad.genome.objects.Dataframe;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSetSignal;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.MetricWeightStruc;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.objects.SignalMatrix;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDbImplWithPermTest;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentReport;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentReportDbImpl;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentReportImpl;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentScore;
import edu.mit.broad.genome.objects.strucs.CollapsedDetails;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.genome.reports.ChartHelper;
import edu.mit.broad.genome.reports.EnrichmentCharts;
import edu.mit.broad.genome.reports.EnrichmentReports$BasicReportStruc;
import edu.mit.broad.genome.reports.EnrichmentReports$ColNames;
import edu.mit.broad.genome.reports.EnrichmentReports$EsProfileDataset;
import edu.mit.broad.genome.reports.EnrichmentReports$EsProfileDataset2;
import edu.mit.broad.genome.reports.EnrichmentReports$MyEnrichmentReportImpl;
import edu.mit.broad.genome.reports.EnrichmentReports$Ret;
import edu.mit.broad.genome.reports.EnrichmentReports$Struc;
import edu.mit.broad.genome.reports.MiscReports;
import edu.mit.broad.genome.reports.PermutationReports;
import edu.mit.broad.genome.reports.RankedListCharts;
import edu.mit.broad.genome.reports.RichDataframe;
import edu.mit.broad.genome.reports.RichDataframe$MetaData;
import edu.mit.broad.genome.reports.api.PicFile;
import edu.mit.broad.genome.reports.api.ToolReport;
import edu.mit.broad.genome.reports.pages.ExcelTxtPage;
import edu.mit.broad.genome.reports.pages.HtmlFormat$Links;
import edu.mit.broad.genome.reports.pages.HtmlPage;
import edu.mit.broad.genome.reports.pages.HtmlReportIndexPage;
import edu.mit.broad.genome.reports.pages.KeyValTable;
import edu.mit.broad.genome.reports.pages.Page;
import edu.mit.broad.genome.reports.web.LinkedFactory;
import edu.mit.broad.genome.reports.web.LinkedFactory$SimpleLinkedPage;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.utils.FileUtils;
import edu.mit.broad.vdb.VdbRuntimeResources;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.meg.Gene;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.ecs.Element;
import org.apache.ecs.StringElement;
import org.apache.ecs.html.A;
import org.apache.ecs.html.Div;
import org.apache.ecs.html.H4;
import org.apache.ecs.html.IMG;
import org.apache.ecs.html.LI;
import org.apache.ecs.html.TD;
import org.apache.ecs.html.TR;
import org.apache.ecs.html.Table;
import org.apache.ecs.html.UL;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.BorderArrangement;
import org.jfree.chart.block.EmptyBlock;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.CompositeTitle;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import xapps.api.vtools.viewers.VizFactory;

public class EnrichmentReports
extends ChartHelper {
    protected static final String[] BASIC_COL_NAMES = new String[]{"GS<br> follow link to MSigDB", "GS DETAILS", "SIZE", "ES", "NES", "NOM p-val", "FDR q-val", "FWER p-val", "RANK AT MAX", "LEADING EDGE"};
    private static final int COL_ES = 3;
    private static final int COL_NES = 4;
    private static final int COL_NP = 5;
    private static final int COL_FDR = 6;
    private static final int COL_FWER = 7;
    public static final String ENPLOT_ = "enplot_";

    public static final EnrichmentReports$Ret createGseaLikeReport(EnrichmentDb enrichmentDb, FeatureAnnot featureAnnot, boolean bl, ToolReport toolReport, String string, String string2, String string3) {
        return EnrichmentReports.createGseaLikeReport(enrichmentDb, System.out, EnrichmentReports._cd(enrichmentDb.getDataset()), toolReport.getIndexPage(), EnrichmentReports._createSubDir(enrichmentDb, toolReport, bl), toolReport, 20, 15, 500, true, false, null, "Signal2Noise perhaps", Norms.MEANDIV_POS_NEG_SEPERATE, featureAnnot, string, string2, string3);
    }

    public static final EnrichmentReports$Ret createGseaLikeReport(EnrichmentDb enrichmentDb, FeatureAnnot featureAnnot, File file, ToolReport toolReport, String string, String string2, String string3) {
        return EnrichmentReports.createGseaLikeReport(enrichmentDb, System.out, EnrichmentReports._cd(enrichmentDb.getDataset()), toolReport.getIndexPage(), file, toolReport, 20, 15, 500, true, false, null, "Signal2Noise perhaps", Norms.MEANDIV_POS_NEG_SEPERATE, featureAnnot, string, string2, string3);
    }

    public static final EnrichmentReports$Ret createGseaLikeReport(EnrichmentDb enrichmentDb, boolean bl, ToolReport toolReport, String string, String string2, String string3) {
        FeatureAnnot featureAnnot = null;
        if (enrichmentDb.getDataset() != null && enrichmentDb.getDataset().getAnnot() != null) {
            featureAnnot = enrichmentDb.getDataset().getAnnot().getFeatureAnnot();
        }
        return EnrichmentReports.createGseaLikeReport(enrichmentDb, featureAnnot, bl, toolReport, string, string2, string3);
    }

    public static final EnrichmentReports$Ret createGseaLikeReport(EnrichmentDb enrichmentDb, File file, ToolReport toolReport, FeatureAnnot featureAnnot, String string, String string2, String string3) {
        return EnrichmentReports.createGseaLikeReport(enrichmentDb, featureAnnot, file, toolReport, string, string2, string3);
    }

    private static CollapsedDetails _cd(Dataset dataset) {
        CollapsedDetails collapsedDetails = new CollapsedDetails();
        collapsedDetails.orig = dataset;
        collapsedDetails.wasCollapsed = false;
        return collapsedDetails;
    }

    private static IntervalMarker[] _markers(RankedList rankedList) {
        int n = rankedList.getSize() < 100 ? rankedList.getSize() : 100;
        return RankedListCharts.createIntervalMarkers(n, rankedList);
    }

    public static final StringDataframe createGseaLikeReport_sdf(EnrichmentDb enrichmentDb, String string) {
        return EnrichmentReports.createGseaLikeReport_struc((EnrichmentDb)enrichmentDb, (String)string).sdf;
    }

    public static final EnrichmentReports$Struc createGseaLikeReport_struc(EnrichmentDb enrichmentDb, String string) {
        if (string == null) {
            throw new IllegalArgumentException("Param normModeName cannot be null");
        }
        if (enrichmentDb == null) {
            throw new IllegalArgumentException("Param foo cannot be null");
        }
        PValueCalculatorImpls$GseaImpl pValueCalculatorImpls$GseaImpl = new PValueCalculatorImpls$GseaImpl(string);
        EnrichmentResult[] enrichmentResultArray = pValueCalculatorImpls$GseaImpl.calcNPValuesAndFDR(enrichmentDb.getResults());
        EnrichmentDb enrichmentDb2 = enrichmentDb.cloneDeep(enrichmentResultArray);
        String[] stringArray = new String[enrichmentDb2.getNumResults()];
        EnrichmentResult[] enrichmentResultArray2 = enrichmentDb2.getResults(new ComparatorFactory$EnrichmentResultByNESComparator(Order.DESCENDING));
        StringMatrix stringMatrix = new StringMatrix(enrichmentResultArray2.length, EnrichmentReports$ColNames.SDF_COL_NAMES.length);
        for (int i2 = 0; i2 < enrichmentResultArray2.length; ++i2) {
            int n = 0;
            GeneSet geneSet = enrichmentResultArray2[i2].getGeneSet();
            EnrichmentScore enrichmentScore = enrichmentResultArray2[i2].getScore();
            stringArray[i2] = geneSet.getName(true);
            stringMatrix.setElement(i2, n++, geneSet.getNumMembers());
            stringMatrix.setElement(i2, n++, enrichmentScore.getES());
            stringMatrix.setElement(i2, n++, enrichmentScore.getNES());
            stringMatrix.setElement(i2, n++, enrichmentScore.getNP());
            stringMatrix.setElement(i2, n++, enrichmentScore.getFDR());
            stringMatrix.setElement(i2, n++, enrichmentScore.getFWER());
            stringMatrix.setElement(i2, n++, enrichmentResultArray2[i2].getSignal().getRankAtMax());
            stringMatrix.setElement(i2, n, EnrichmentReports.getLeadingEdge(enrichmentResultArray2[i2]));
        }
        EnrichmentReports$Struc enrichmentReports$Struc = new EnrichmentReports$Struc();
        enrichmentReports$Struc.sdf = new StringDataframe(enrichmentDb.getName(), stringMatrix, stringArray, EnrichmentReports$ColNames.SDF_COL_NAMES, true);
        enrichmentReports$Struc.edb_with_results = enrichmentDb.cloneDeep(enrichmentResultArray);
        return enrichmentReports$Struc;
    }

    private static File _createSubDir(EnrichmentDb enrichmentDb, ToolReport toolReport, boolean bl) {
        File file;
        if (bl) {
            String string;
            String string2;
            Template template = enrichmentDb.getTemplate();
            if (template != null) {
                if (template.isContinuous()) {
                    String string3 = AuxUtils.getAuxNameOnlyNoHash(template);
                    if (template.isContinuous()) {
                        string2 = string3;
                        string = string3;
                    } else {
                        string2 = string3 + "_pos";
                        string = string3 + "_neg";
                    }
                } else {
                    string2 = template.getClassName(0);
                    string = template.getClassName(1);
                }
            } else {
                string2 = "classA";
                string = "classB";
            }
            file = toolReport.createSubDir(string2 + "_vs_" + string);
        } else {
            file = toolReport.getReportDir();
        }
        return file;
    }

    public static final EnrichmentReports$Ret createGseaLikeReport(EnrichmentDb enrichmentDb, PrintStream printStream, CollapsedDetails collapsedDetails, HtmlPage htmlPage, boolean bl, ToolReport toolReport, int n, int n2, int n3, boolean bl2, boolean bl3, GeneSet[] geneSetArray, String string, String string2) {
        FeatureAnnot featureAnnot = null;
        if (enrichmentDb.getDataset() != null && enrichmentDb.getDataset().getAnnot() != null) {
            featureAnnot = enrichmentDb.getDataset().getAnnot().getFeatureAnnot();
        }
        return EnrichmentReports.createGseaLikeReport(enrichmentDb, printStream, collapsedDetails, htmlPage, EnrichmentReports._createSubDir(enrichmentDb, toolReport, bl), toolReport, n, n2, n3, bl2, bl3, geneSetArray, string, string2, featureAnnot, null, null, null);
    }

    public static final EnrichmentReports$Ret createGseaLikeReport(EnrichmentDb enrichmentDb, PrintStream printStream, CollapsedDetails collapsedDetails, HtmlPage htmlPage, boolean bl, ToolReport toolReport, int n, int n2, int n3, boolean bl2, boolean bl3, GeneSet[] geneSetArray, String string, String string2, FeatureAnnot featureAnnot) {
        return EnrichmentReports.createGseaLikeReport(enrichmentDb, printStream, collapsedDetails, htmlPage, EnrichmentReports._createSubDir(enrichmentDb, toolReport, bl), toolReport, n, n2, n3, bl2, bl3, geneSetArray, string, string2, featureAnnot, null, null, null);
    }

    private static String _createPhenotypeName(EnrichmentDb enrichmentDb) {
        Template template = enrichmentDb.getTemplate();
        String string = template != null ? template.getName() : "NoPhenotypeAvailable";
        return string;
    }

    private static String[] _createClassNames(Template template) {
        String string;
        String string2;
        if (template != null) {
            if (template.isContinuous()) {
                String string3 = AuxUtils.getAuxNameOnlyNoHash(template);
                string2 = string3 + "_pos";
                string = string3 + "_neg";
            } else {
                string2 = template.getClassName(0);
                string = template.getClassName(1);
            }
        } else {
            string2 = "na_pos";
            string = "na_neg";
        }
        return new String[]{string2, string};
    }

    public static final EnrichmentReports$Ret createGseaLikeReport(EnrichmentDb enrichmentDb, PrintStream printStream, CollapsedDetails collapsedDetails, HtmlPage htmlPage, File file, ToolReport toolReport, int n, int n2, int n3, boolean bl, boolean bl2, GeneSet[] geneSetArray, String string, String string2, FeatureAnnot featureAnnot, String string3, String string4, String object) {
        StringElement stringElement;
        Object object2;
        Serializable serializable;
        StringElement stringElement2;
        StringElement stringElement3;
        Serializable serializable2;
        StringElement stringElement4;
        EnrichmentResult[] enrichmentResultArray;
        Serializable serializable3;
        String string5;
        String string6;
        Object object3;
        if (string2 == null) {
            throw new IllegalArgumentException("Param normModeName cannot be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Param saveInThisDir cannot be null");
        }
        if (!file.exists()) {
            file.mkdir();
        }
        if (string3 == null) {
            string3 = EnrichmentReports._createPhenotypeName(enrichmentDb);
        }
        if (string4 == null || object == null) {
            object3 = EnrichmentReports._createClassNames(enrichmentDb.getTemplate());
            string4 = object3[0];
            object = object3[1];
        }
        object3 = new PValueCalculatorImpls$GseaImpl(string2);
        EnrichmentResult[] enrichmentResultArray2 = object3.calcNPValuesAndFDR(enrichmentDb.getResults());
        EnrichmentDb enrichmentDb2 = enrichmentDb.cloneDeep(enrichmentResultArray2);
        Dataset dataset = enrichmentDb2.getDataset();
        RankedList rankedList = enrichmentDb2.getRankedList();
        GeneSet[] geneSetArray2 = enrichmentDb2.getGeneSets();
        MetricWeightStruc metricWeightStruc = rankedList.getMetricWeightStruc();
        if (metricWeightStruc != null && string != null && metricWeightStruc.getMetricName() == null) {
            metricWeightStruc.setMetricName(string);
        }
        File file2 = null;
        Template template = enrichmentDb2.getTemplate();
        if (template != null) {
            if (template.isContinuous()) {
                string6 = "positive correlation with profile";
                string5 = "negative correlation with profile";
            } else {
                string6 = template.getClassName(0) + " (" + template.getClass(0).getSize() + " samples)";
                string5 = template.getClassName(1) + " (" + template.getClass(1).getSize() + " samples)";
            }
        } else {
            string5 = "na";
            string6 = "na";
        }
        String string7 = enrichmentDb2.getName();
        printStream.println("Creating marker selection reports ...");
        RichDataframe richDataframe = MiscReports.annotateProbesNames(string7, rankedList, featureAnnot);
        File file3 = toolReport.savePageXls(richDataframe.getDataframe(), "ranked_gene_list_" + string4 + "_versus_" + (String)object + "_" + toolReport.getTimestamp(), file);
        File file4 = null;
        if (dataset != null && template != null) {
            serializable3 = MiscReports.createDatasetHeatMapAndCorrelationPlots(dataset, template, rankedList, 50);
            file4 = toolReport.savePage((Page)serializable3, file);
        }
        serializable3 = null;
        if (enrichmentDb2 instanceof EnrichmentDbImplWithPermTest && ((EnrichmentDbImplWithPermTest)enrichmentDb2).getPermutationTest() != null) {
            try {
                enrichmentResultArray = PermutationReports.createButterflyChart(((EnrichmentDbImplWithPermTest)enrichmentDb2).getPermutationTest());
                serializable3 = new File(file, "butterfly_plot.png");
                enrichmentResultArray.saveAsPNG((File)serializable3, 500, 500);
            }
            catch (Throwable throwable) {
                toolReport.addError("Trouble making butterfly plot", throwable);
            }
        }
        printStream.println("Creating FDR reports ...");
        enrichmentResultArray = enrichmentDb2.getResults(new ComparatorFactory$EnrichmentResultByNESComparator(Order.DESCENDING), true);
        EnrichmentReports$BasicReportStruc enrichmentReports$BasicReportStruc = EnrichmentReports.createReport(enrichmentResultArray, string7, string3, string4, (String)object, rankedList, template, featureAnnot, "Gene sets enriched in phenotype <b>" + string6 + "<b>", n, bl, file);
        RichDataframe richDataframe2 = enrichmentReports$BasicReportStruc.rdf;
        printStream.println("Done FDR reports for positive phenotype");
        EnrichmentResult[] enrichmentResultArray3 = enrichmentDb2.getResults(new ComparatorFactory$EnrichmentResultByNESComparator(Order.ASCENDING), false);
        EnrichmentReports$BasicReportStruc enrichmentReports$BasicReportStruc2 = EnrichmentReports.createReport(enrichmentResultArray3, string7, string3, string4, (String)object, rankedList, template, featureAnnot, "Gene sets enriched in phenotype <b>" + string5 + "<b>", n, bl, file);
        RichDataframe richDataframe3 = enrichmentReports$BasicReportStruc2.rdf;
        printStream.println("Done FDR reports for negative phenotype");
        String string8 = "gsea_report_for_" + string4 + "_" + toolReport.getTimestamp();
        String string9 = "Report for " + string4 + " " + toolReport.getTimestamp() + " [GSEA]";
        String string10 = "gsea_report_for_" + (String)object + "_" + toolReport.getTimestamp();
        String string11 = "Report for " + (String)object + " " + toolReport.getTimestamp() + " [GSEA]";
        File file5 = toolReport.savePageXls(richDataframe2, string8, file);
        File file6 = toolReport.savePageXls(richDataframe3, string10, file);
        HtmlPage htmlPage2 = new HtmlPage(string8, string9);
        htmlPage2.addTable(richDataframe2, file5.getName(), false, true);
        File file7 = toolReport.savePage((Page)htmlPage2, file);
        File file8 = toolReport.savePage((Page)EnrichmentReports.createSnapshotPage(true, enrichmentReports$BasicReportStruc.reports), file);
        htmlPage2 = new HtmlPage(string10, string11);
        htmlPage2.addTable(richDataframe3, file6.getName(), false, true);
        File file9 = toolReport.savePage((Page)htmlPage2, file);
        File file10 = toolReport.savePage((Page)EnrichmentReports.createSnapshotPage(false, enrichmentReports$BasicReportStruc2.reports), file);
        XChart xChart = EnrichmentReports.createNESvsSignificancePlot(enrichmentDb2);
        File file11 = toolReport.savePage(xChart, 500, 500, file);
        XChart xChart2 = EnrichmentReports.createGlobalESHistogram(AuxUtils.getAuxNameOnlyNoHash(string3), enrichmentDb2.getESS_lv());
        File file12 = toolReport.savePage(xChart2, 500, 500, file);
        Div div = new Div();
        H4 h4 = new H4("Enrichment in phenotype: <b>" + string6 + "</b>");
        div.addElement(h4);
        UL uL = new UL();
        StringElement stringElement5 = HtmlFormat$Links.hyper("Guide to", "http://www.broadinstitute.org/gsea/doc/GSEAUserGuideFrame.html?_Interpreting_GSEA_Results", "interpret results");
        if (enrichmentDb2.getNumScores(true) > 0) {
            stringElement4 = new StringElement(enrichmentDb2.getNumScores(true) + " / " + geneSetArray2.length + " gene sets are upregulated in phenotype <b>" + string4 + "</b>");
            serializable2 = new StringElement(enrichmentDb2.getNumNominallySig(0.01f, true) + " gene sets are significantly enriched at nominal pvalue < 1%");
            stringElement3 = new StringElement(enrichmentDb2.getNumNominallySig(0.05f, true) + " gene sets are significantly enriched at nominal pvalue < 5%");
            stringElement2 = new StringElement(enrichmentDb2.getNumFDRSig(0.25f, true) + " gene sets are significant at FDR < 25%");
            serializable = HtmlFormat$Links.hyper("Snapshot", file8, "of enrichment results", file);
            object2 = HtmlFormat$Links.hyper("Detailed", "enrichment results in html", file7, " format", file);
            stringElement = HtmlFormat$Links.hyper("Detailed", "enrichment results in excel", file5, " format (tab delimited text)", file);
            uL.addElement(new LI(stringElement4));
            uL.addElement(new LI(stringElement2));
            uL.addElement(new LI((Element)((Object)serializable2)));
            uL.addElement(new LI(stringElement3));
            uL.addElement(new LI((Element)((Object)serializable)));
            uL.addElement(new LI((Element)object2));
            uL.addElement(new LI(stringElement));
            uL.addElement(new LI(stringElement5));
        } else {
            stringElement4 = new StringElement("None of the gene sets are enriched in phenotype <b>" + string4 + "</b>");
            uL.addElement(new LI(stringElement4));
            uL.addElement(new LI(stringElement5));
        }
        div.addElement(uL);
        htmlPage.addBlock(div, false);
        div = new Div();
        h4 = new H4("Enrichment in phenotype: <b>" + string5 + "</b>");
        div.addElement(h4);
        uL = new UL();
        if (enrichmentDb2.getNumScores(false) > 0) {
            stringElement4 = new StringElement(enrichmentDb2.getNumScores(false) + " / " + geneSetArray2.length + " gene sets are upregulated in phenotype <b>" + (String)object + "</b>");
            serializable2 = new StringElement(enrichmentDb2.getNumNominallySig(0.01f, false) + " gene sets are significantly enriched at nominal pvalue < 1%");
            stringElement3 = new StringElement(enrichmentDb2.getNumNominallySig(0.05f, false) + " gene sets are significantly enriched at nominal pvalue < 5%");
            stringElement2 = new StringElement(enrichmentDb2.getNumFDRSig(0.25f, false) + " gene sets are significantly enriched at FDR < 25%");
            serializable = HtmlFormat$Links.hyper("Snapshot", file10, "of enrichment results", file);
            object2 = HtmlFormat$Links.hyper("Detailed", "enrichment results in html", file9, " format", file);
            stringElement = HtmlFormat$Links.hyper("Detailed", "enrichment results in excel", file6, " format (tab delimited text)", file);
            uL.addElement(new LI(stringElement4));
            uL.addElement(new LI(stringElement2));
            uL.addElement(new LI((Element)((Object)serializable2)));
            uL.addElement(new LI(stringElement3));
            uL.addElement(new LI((Element)((Object)serializable)));
            uL.addElement(new LI((Element)object2));
            uL.addElement(new LI(stringElement));
            uL.addElement(new LI(stringElement5));
        } else {
            stringElement4 = new StringElement("None of the gene sets are enriched in phenotype <b>" + (String)object + "</b>");
            uL.addElement(new LI(stringElement4));
            uL.addElement(new LI(stringElement5));
        }
        div.addElement(uL);
        htmlPage.addBlock(div, false);
        div = new Div();
        uL = new UL();
        h4 = new H4("Dataset details");
        div.addElement(h4);
        if (collapsedDetails.wasCollapsed) {
            stringElement4 = new StringElement("The dataset has " + collapsedDetails.getNumRow_orig() + " native features");
            serializable2 = new StringElement("After collapsing features into gene symbols, there are: " + rankedList.getSize() + " genes");
            uL.addElement(new LI(stringElement4));
            uL.addElement(new LI((Element)((Object)serializable2)));
        } else {
            stringElement4 = new StringElement("The dataset has " + rankedList.getSize() + " features (genes)");
            uL.addElement(new LI(stringElement4));
            uL.addElement(new LI("No probe set => gene symbol collapsing was requested, so all " + rankedList.getSize() + " features were used"));
        }
        div.addElement(uL);
        htmlPage.addBlock(div, false);
        if (geneSetArray != null) {
            div = new Div();
            uL = new UL();
            h4 = new H4("Gene set details");
            div.addElement(h4);
            int n4 = geneSetArray.length - geneSetArray2.length;
            serializable2 = new StringBuffer("Gene set size filters (min=").append(n2).append(", max=").append(n3).append(")");
            ((StringBuffer)serializable2).append(" resulted in filtering out ").append(n4).append(" / ").append(geneSetArray.length).append(" gene sets");
            uL.addElement(new LI(((StringBuffer)serializable2).toString()));
            file2 = EnrichmentReports._getGeneSetSizesFile(geneSetArray2, geneSetArray, file2, toolReport);
            uL.addElement(new LI("The remaining " + geneSetArray2.length + " gene sets were used in the analysis"));
            uL.addElement(new LI(HtmlFormat$Links.hyper("List of", "gene sets used and their sizes", file2, "(restricted to features in the specified dataset)", file)));
            div.addElement(uL);
            htmlPage.addBlock(div, false);
        }
        div = new Div();
        h4 = template != null && template.isContinuous() ? new H4("Gene markers for the neighbors of " + string4) : new H4("Gene markers for the <b>" + string4 + "</b><i> versus </i><b>" + (String)object + "</b> comparison");
        div.addElement(h4);
        StringElement stringElement6 = new StringElement("The dataset has " + rankedList.getSize() + " features (genes)");
        serializable2 = new StringElement("# of markers for phenotype <b>" + string4 + "</b>: " + metricWeightStruc.getTotalPosLength() + " (" + Printf.format(metricWeightStruc.getTotalPosLength_frac() * 100.0f, 1) + "% )" + " with correlation area " + Printf.format(metricWeightStruc.getTotalPosWeight_frac() * 100.0f, 1) + "%");
        stringElement3 = new StringElement("# of markers for phenotype <b>" + (String)object + "</b>: " + metricWeightStruc.getTotalNegLength() + " (" + Printf.format(metricWeightStruc.getTotalNegLength_frac() * 100.0f, 1) + "% )" + " with correlation area " + Printf.format(metricWeightStruc.getTotalNegWeight_frac() * 100.0f, 1) + "%");
        stringElement2 = HtmlFormat$Links.hyper("Detailed", "rank ordered gene list", file3, " for all features in the dataset", file);
        uL = new UL();
        uL.addElement(new LI(stringElement6));
        if (template != null && !template.isContinuous()) {
            uL.addElement(new LI((Element)((Object)serializable2)));
            uL.addElement(new LI(stringElement3));
        }
        uL.addElement(new LI(stringElement2));
        if (file4 != null) {
            serializable = HtmlFormat$Links.hyper("Heat map and gene list correlation ", file4, " profile for all features in the dataset", file);
            uL.addElement(new LI((Element)((Object)serializable)));
        }
        if (serializable3 != null && ((File)serializable3).exists()) {
            serializable = HtmlFormat$Links.hyper("Buttefly plot", (File)serializable3, "of significant genes", file);
            uL.addElement(new LI((Element)((Object)serializable)));
        }
        div.addElement(uL);
        htmlPage.addBlock(div, false);
        printStream.println("Creating global reports ...");
        div = new Div();
        uL = new UL();
        div.addElement(new H4("Global statistics and plots"));
        uL.addElement(new LI(HtmlFormat$Links.hyper("Plot of ", "p-values <i>vs.</i> NES", file11, "", file)));
        uL.addElement(new LI(HtmlFormat$Links.hyper("Global ES", file12, "histogram", file)));
        div.addElement(uL);
        htmlPage.addBlock(div, false);
        div = new Div();
        uL = new UL();
        div.addElement(new H4("Other"));
        uL.addElement(new LI(HtmlFormat$Links.hyper("Parameters", toolReport.getParamsFile(), "used for this analysis", file)));
        if (bl2) {
            serializable = toolReport.getZipReportFile();
            uL.addElement(new LI(HtmlFormat$Links.hyper("Zipped", (File)serializable, "file with all results", file)));
        }
        div.addElement(uL);
        htmlPage.addBlock(div, false);
        if (htmlPage instanceof HtmlReportIndexPage) {
            ((HtmlReportIndexPage)htmlPage).setAddBrowseFooter(false);
        }
        printStream.println("Done all reports!!");
        serializable = new ArrayList<EnrichmentReport>(Arrays.asList(enrichmentReports$BasicReportStruc.reports));
        serializable.addAll(Arrays.asList(enrichmentReports$BasicReportStruc2.reports));
        object2 = new EnrichmentReports$Ret();
        ((EnrichmentReports$Ret)object2).rdb = new EnrichmentReportDbImpl(serializable.toArray(new EnrichmentReport[serializable.size()]));
        ((EnrichmentReports$Ret)object2).savedInDir = file;
        ((EnrichmentReports$Ret)object2).edb = enrichmentDb2;
        return object2;
    }

    public static final EnrichmentReports$BasicReportStruc createReport(EnrichmentResult[] enrichmentResultArray, String string, String string2, String string3, String string4, RankedList rankedList, Template template, FeatureAnnot featureAnnot, String string5, int n, boolean bl, File file) {
        Object object;
        Object object2;
        String[] stringArray = new String[enrichmentResultArray.length];
        TIntObjectHashMap tIntObjectHashMap = new TIntObjectHashMap();
        StringMatrix stringMatrix = new StringMatrix(stringArray.length, BASIC_COL_NAMES.length);
        IntervalMarker[] intervalMarkerArray = EnrichmentReports._markers(rankedList);
        ArrayList<EnrichmentReportImpl> arrayList = new ArrayList<EnrichmentReportImpl>();
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            int n2 = 0;
            object2 = enrichmentResultArray[i2];
            stringArray[i2] = object2.getGeneSet().getName(true);
            object = null;
            stringMatrix.setElement(i2, n2++, stringArray[i2]);
            if (bl && i2 < n) {
                EnrichmentResult enrichmentResult = enrichmentResultArray[i2];
                object = new HtmlPage(stringArray[i2], "Details for gene set " + stringArray[i2] + "[GSEA]");
                EnrichmentReports$MyEnrichmentReportImpl enrichmentReports$MyEnrichmentReportImpl = EnrichmentReports.createReport(string, string2, string3, string4, rankedList, template, enrichmentResult.getGeneSet(), enrichmentResult.getScore().getHitIndices(), enrichmentResult.getScore().getESProfile(), enrichmentResult.getScore().getESProfile_point_by_point_opt(), object2.getScore().getES(), object2.getScore().getNES(), object2.getScore().getNP(), object2.getScore().getFDR(), object2.getScore().getFWER(), enrichmentResult.getRndESS(), (HtmlPage)object, featureAnnot, true, intervalMarkerArray, true);
                try {
                    File file2 = new File(file, EnrichmentReports$MyEnrichmentReportImpl.access$000(enrichmentReports$MyEnrichmentReportImpl).getName() + ".html");
                    PicFile[] picFileArray = ((HtmlPage)object).write(new FileOutputStream(file2), file);
                    File file3 = picFileArray[0].getFile();
                    EnrichmentReports$MyEnrichmentReportImpl.access$100(enrichmentReports$MyEnrichmentReportImpl).write(new FileOutputStream(new File(file, EnrichmentReports$MyEnrichmentReportImpl.access$100(enrichmentReports$MyEnrichmentReportImpl).getName() + ".xls")), file);
                    arrayList.add(new EnrichmentReportImpl(file2, file3));
                }
                catch (Throwable throwable) {
                    klog.error("Error making details: " + stringArray[i2], throwable);
                }
                stringMatrix.setElement(i2, n2++, "Details ...");
            } else {
                stringMatrix.setElement(i2, n2++, "");
            }
            stringMatrix.setElement(i2, n2++, object2.getScore().getNumHits());
            stringMatrix.setElement(i2, n2++, object2.getScore().getES());
            stringMatrix.setElement(i2, n2++, object2.getScore().getNES());
            stringMatrix.setElement(i2, n2++, object2.getScore().getNP());
            stringMatrix.setElement(i2, n2++, object2.getScore().getFDR());
            stringMatrix.setElement(i2, n2++, object2.getScore().getFWER());
            stringMatrix.setElement(i2, n2++, object2.getSignal().getRankAtMax());
            stringMatrix.setElement(i2, n2, EnrichmentReports.getLeadingEdge((EnrichmentResult)object2));
            if (object == null) continue;
            tIntObjectHashMap.put(stringMatrix.getElementPos(i2, 0), LinkedFactory.createLinkedGeneSet(object2.getGeneSet()));
            tIntObjectHashMap.put(stringMatrix.getElementPos(i2, 1), new LinkedFactory$SimpleLinkedPage("Details", (Page)object));
        }
        StringDataframe stringDataframe = new StringDataframe(string + "_basic", stringMatrix, stringArray, BASIC_COL_NAMES, true);
        TIntIntHashMap tIntIntHashMap = new TIntIntHashMap();
        tIntIntHashMap.put(3, 2);
        tIntIntHashMap.put(4, 2);
        tIntIntHashMap.put(5, 3);
        tIntIntHashMap.put(6, 3);
        tIntIntHashMap.put(7, 3);
        object2 = new EnrichmentReports$BasicReportStruc();
        object = new RichDataframe$MetaData(string5, null, null, null, tIntIntHashMap);
        ((EnrichmentReports$BasicReportStruc)object2).rdf = new RichDataframe(stringDataframe, (RichDataframe$MetaData)object, null, tIntObjectHashMap);
        ((EnrichmentReports$BasicReportStruc)object2).reports = arrayList.toArray(new EnrichmentReport[arrayList.size()]);
        return object2;
    }

    public static final HtmlPage createSnapshotPage(boolean bl, EnrichmentReport[] enrichmentReportArray) {
        Serializable serializable;
        Table table = new Table();
        int n = 0;
        for (int i2 = 0; i2 < enrichmentReportArray.length; ++i2) {
            serializable = new TR();
            for (int i3 = 0; i3 < 3; ++i3) {
                A a2 = new A();
                a2.setName("");
                a2.setHref(enrichmentReportArray[n].getHtmlFile().getName());
                IMG iMG = new IMG();
                iMG.setSrc(enrichmentReportArray[n].getESPlotFile().getName());
                iMG.setWidth(200);
                iMG.setHeight(200);
                a2.addElement(iMG);
                TD tD = new TD(a2);
                ((TR)serializable).addElement(tD);
                if (++n >= enrichmentReportArray.length) break;
            }
            table.addElement((Element)((Object)serializable));
            if (n >= enrichmentReportArray.length) break;
        }
        String string = bl ? "pos_snapshot" : "neg_snapshot";
        serializable = new HtmlPage(string, "Snapshot of " + enrichmentReportArray.length + " enrichment plots");
        ((HtmlPage)serializable).addTable("Snapshot of enrichment results", table);
        return serializable;
    }

    public static final String getLeadingEdge(EnrichmentResult enrichmentResult) {
        GeneSetSignal geneSetSignal = enrichmentResult.getSignal();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("tags=").append(Printf.format(geneSetSignal.getTagFraction() * 100.0f, 0)).append("%, ");
        stringBuffer.append("list=").append(Printf.format(geneSetSignal.getListFraction() * 100.0f, 0)).append("%, ");
        stringBuffer.append("signal=").append(Printf.format(geneSetSignal.getSignalStrength() * 100.0f, 0)).append("%");
        return stringBuffer.toString();
    }

    public static final Dataframe createSignalReport(GeneSetMatrix geneSetMatrix, SignalMatrix signalMatrix) {
        Matrix matrix = new Matrix(signalMatrix.getNumSignals(), 3);
        for (int i2 = 0; i2 < matrix.getNumRow(); ++i2) {
            int n = 0;
            String string = signalMatrix.getSignal(i2).getName();
            float f2 = signalMatrix.getSignal(i2).getSize();
            float f3 = geneSetMatrix.getGeneSet(string).getNumMembers();
            matrix.setElement(i2, n++, f2);
            matrix.setElement(i2, n++, f3);
            matrix.setElement(i2, n, 100.0f * f2 / f3);
        }
        return new Dataframe("signal_report", matrix, signalMatrix.getGeneSetNames(true), new String[]{"signal_size", "geneset_size", "fraction"}, true);
    }

    public static final EnrichmentReport createReport(String string, String string2, String string3, String string4, EnrichmentResult enrichmentResult, FeatureAnnot featureAnnot, boolean bl, boolean bl2) {
        return EnrichmentReports._createReport(string, string2, string3, string4, enrichmentResult.getRankedList(), enrichmentResult.getTemplate(), enrichmentResult.getGeneSet(), enrichmentResult.getScore().getHitIndices(), enrichmentResult.getScore().getESProfile(), enrichmentResult.getScore().getESProfile_point_by_point_opt(), enrichmentResult.getScore().getES(), enrichmentResult.getScore().getNES(), enrichmentResult.getScore().getNP(), enrichmentResult.getScore().getFDR(), enrichmentResult.getScore().getFWER(), featureAnnot, bl, EnrichmentReports._markers(enrichmentResult.getRankedList()), bl2);
    }

    public static final EnrichmentReport createReport(String string, String string2, String string3, String string4, RankedList rankedList, Template template, GeneSet geneSet, EnrichmentScore enrichmentScore, FeatureAnnot featureAnnot, boolean bl, boolean bl2) {
        return EnrichmentReports._createReport(string, string2, string3, string4, rankedList, template, geneSet, enrichmentScore.getHitIndices(), enrichmentScore.getESProfile(), enrichmentScore.getESProfile_point_by_point_opt(), enrichmentScore.getES(), enrichmentScore.getNES(), enrichmentScore.getNP(), enrichmentScore.getFDR(), enrichmentScore.getFWER(), featureAnnot, bl, EnrichmentReports._markers(rankedList), bl2);
    }

    private static EnrichmentReport _createReport(String string, String string2, String string3, String string4, RankedList rankedList, Template template, GeneSet geneSet, int[] nArray, Vector vector, Vector vector2, float f2, float f3, float f4, float f5, float f6, FeatureAnnot featureAnnot, boolean bl, IntervalMarker[] intervalMarkerArray, boolean bl2) {
        HtmlPage htmlPage = new HtmlPage(string, "GSEA Results for: " + geneSet.getName());
        return EnrichmentReports.createReport(string, string2, string3, string4, rankedList, template, geneSet, nArray, vector, vector2, f2, f3, f4, f5, f6, null, htmlPage, featureAnnot, bl, intervalMarkerArray, bl2);
    }

    public static final EnrichmentReports$MyEnrichmentReportImpl createReport(String string, String string2, String string3, String string4, RankedList rankedList, Template template, GeneSet geneSet, int[] nArray, Vector vector, Vector vector2, float f2, float f3, float f4, float f5, float f6, Vector vector3, HtmlPage htmlPage, FeatureAnnot featureAnnot, boolean bl, IntervalMarker[] intervalMarkerArray, boolean bl2) {
        Object object;
        ExcelTxtPage excelTxtPage = null;
        EnrichmentCharts enrichmentCharts = null;
        try {
            object = geneSet.getName(true);
            if (nArray.length != geneSet.getNumMembers(rankedList)) {
                throw new IllegalStateException("Mismatched gset: " + geneSet.getNumMembers(rankedList) + " and hitIndices: " + nArray.length);
            }
            if ((int)vector.maxDevFrom0() != (int)f2) {
                klog.warn("Possibly mismatched scores: " + vector.maxDevFrom0() + " " + f2);
            }
            if (vector.getSize() != nArray.length) {
                throw new IllegalStateException("Mismatched esProfile: " + vector.getSize() + " and hitIndices: " + nArray.length);
            }
            RichDataframe richDataframe = EnrichmentReports.createDetailTable(string, nArray, vector, rankedList, geneSet, featureAnnot);
            excelTxtPage = new ExcelTxtPage(htmlPage.getName(), richDataframe);
            String string5 = XMath.isPositive(f2) ? string3 : string4;
            KeyValTable keyValTable = EnrichmentReports.createSummaryTable(string, string2, string5, geneSet.getName(), f2, f3, f4, f5, f6);
            htmlPage.addTable("GSEA Results Summary", keyValTable);
            enrichmentCharts = EnrichmentReports._createComboChart((String)object, vector, vector2, EnrichmentReports._hitIndices2Vector(rankedList.getSize(), nArray), rankedList, string3, string4, intervalMarkerArray, bl2);
            htmlPage.addChart(enrichmentCharts.comboChart, 500, 500);
            htmlPage.addTable(richDataframe, excelTxtPage.getName() + "." + excelTxtPage.getExt(), false, true);
            if (rankedList instanceof ScoredDataset && bl) {
                htmlPage.addImage((String)object, "Blue-Pink O' Gram in the Space of the Analyzed GeneSet", VizFactory.createGramImager().createBpogImage((ScoredDataset)rankedList, template, geneSet));
            }
            if (vector3 != null && vector3.getSize() != 0) {
                XChart xChart = EnrichmentReports.createESNullDistribHistogram((String)object, string3, string4, f2, vector3);
                htmlPage.addChart(xChart, 500, 500);
            }
        }
        catch (Throwable throwable) {
            htmlPage.addError("Trouble making HtmlPage", throwable);
        }
        object = new EnrichmentReports$MyEnrichmentReportImpl();
        EnrichmentReports$MyEnrichmentReportImpl.access$002((EnrichmentReports$MyEnrichmentReportImpl)object, htmlPage);
        EnrichmentReports$MyEnrichmentReportImpl.access$202((EnrichmentReports$MyEnrichmentReportImpl)object, enrichmentCharts);
        EnrichmentReports$MyEnrichmentReportImpl.access$102((EnrichmentReports$MyEnrichmentReportImpl)object, excelTxtPage);
        return object;
    }

    public static final RichDataframe createDetailTable(String string, int[] nArray, Vector vector, RankedList rankedList, GeneSet geneSet, FeatureAnnot featureAnnot) {
        int n;
        String[] stringArray;
        if (rankedList == null) {
            throw new IllegalArgumentException("Param rl cannot be null");
        }
        Chip chip = VdbRuntimeResources.getChip_Gene_Symbol();
        int n2 = nArray[vector.maxDevFrom0Index()];
        float f2 = vector.maxDevFrom0();
        boolean bl = XMath.isPositive(f2);
        TIntIntHashMap tIntIntHashMap = new TIntIntHashMap();
        if (featureAnnot != null && featureAnnot.hasNativeDescriptions()) {
            stringArray = new String[]{"PROBE", "DESCRIPTION<br>(from dataset)", "GENE SYMBOL", "GENE_TITLE", "RANK IN GENE LIST", "RANK METRIC SCORE", "RUNNING ES", "CORE ENRICHMENT"};
            tIntIntHashMap.put(5, 3);
            tIntIntHashMap.put(6, 4);
            n = 2;
        } else {
            stringArray = new String[]{"PROBE", "GENE SYMBOL", "GENE_TITLE", "RANK IN GENE LIST", "RANK METRIC SCORE", "RUNNING ES", "CORE ENRICHMENT"};
            n = 1;
            tIntIntHashMap.put(4, 3);
            tIntIntHashMap.put(5, 4);
        }
        int n3 = stringArray.length - 1;
        TIntObjectHashMap tIntObjectHashMap = new TIntObjectHashMap();
        TIntObjectHashMap tIntObjectHashMap2 = new TIntObjectHashMap();
        boolean bl2 = false;
        if (chip != null) {
            try {
                bl2 = chip.isProbe(rankedList.getRankName(nArray[0]));
            }
            catch (Throwable throwable) {
                bl2 = false;
            }
        }
        StringMatrix stringMatrix = new StringMatrix(nArray.length, stringArray.length);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            String string2;
            String string3;
            String string4;
            float f3;
            double d2;
            String string5;
            int n4;
            int n5;
            block16: {
                n5 = 0;
                n4 = nArray[i2];
                string5 = rankedList.getRankName(n4);
                d2 = rankedList.getScore(n4);
                f3 = vector.getElement(i2);
                string4 = null;
                string3 = null;
                string2 = null;
                try {
                    Gene gene;
                    if (featureAnnot != null) {
                        string4 = featureAnnot.getNativeDesc(string5);
                        string2 = featureAnnot.getGeneTitle(string5);
                        string3 = featureAnnot.getGeneSymbol(string5);
                    } else if (chip != null && bl2 && (gene = chip.getHugo(string5)) != null) {
                        string3 = gene.getSymbol();
                        string2 = gene.getTitle_truncated();
                    }
                    if (string3 != null) {
                        tIntObjectHashMap.put(stringMatrix.getElementPos(i2, n), LinkedFactory.createLinkedGeneSymbol(string3));
                    }
                }
                catch (Throwable throwable) {
                    if (i2 != 0) break block16;
                    throwable.printStackTrace();
                }
            }
            tIntObjectHashMap.put(stringMatrix.getElementPos(i2, 0), LinkedFactory.createLinkedProbeSet(string5));
            stringMatrix.setElement(i2, n5++, string5);
            if (featureAnnot != null && featureAnnot.hasNativeDescriptions()) {
                stringMatrix.setElement(i2, n5++, string4);
            }
            stringMatrix.setElement(i2, n5++, string3);
            stringMatrix.setElement(i2, n5++, string2);
            stringMatrix.setElement(i2, n5++, new Integer(n4));
            if (!geneSet.isMember(string5)) {
                klog.warn("The ranked list content doesnt match the gene set content. Missing mamber: " + string5);
            }
            stringMatrix.setElement(i2, n5++, new Double(d2));
            stringMatrix.setElement(i2, n5++, new Float(f3));
            if (bl && nArray[i2] <= n2 || !bl && nArray[i2] >= n2) {
                stringMatrix.setElement(i2, n5, "Yes");
                tIntObjectHashMap2.put(stringMatrix.getElementPos(i2, n3), "#CCFFCC");
                continue;
            }
            stringMatrix.setElement(i2, n5, "No");
        }
        StringDataframe stringDataframe = new StringDataframe(string, stringMatrix, stringArray, true);
        RichDataframe$MetaData richDataframe$MetaData = new RichDataframe$MetaData("GSEA details", "some caption", null, null, tIntIntHashMap);
        return new RichDataframe(stringDataframe, richDataframe$MetaData, tIntObjectHashMap2, tIntObjectHashMap);
    }

    public static final KeyValTable createSummaryTable(String string, String string2, String string3, String string4, float f2, float f3, float f4, float f5, float f6) {
        KeyValTable keyValTable = new KeyValTable();
        keyValTable.addRow("Dataset", NamingConventions.splitLongHashName(string, "<br>"));
        keyValTable.addRow("Phenotype", string2);
        keyValTable.addRow("Upregulated in class", string3);
        keyValTable.addRow("GeneSet", string4);
        keyValTable.addRow("Enrichment Score (ES)", f2);
        keyValTable.addRow("Normalized Enrichment Score (NES)", f3);
        keyValTable.addRow("Nominal p-value", f4);
        keyValTable.addRow("FDR q-value", f5);
        keyValTable.addRow("FWER p-Value", f6);
        return keyValTable;
    }

    public static final KeyValTable createSummaryTable(String string, String string2, GeneSet geneSet, EnrichmentScore enrichmentScore, EnrichmentScore enrichmentScore2) {
        KeyValTable keyValTable = new KeyValTable();
        keyValTable.addRow("Dataset", NamingConventions.splitLongHashName(string, "<br>"));
        keyValTable.addRow("Template", string2);
        keyValTable.addRow("GeneSet", geneSet.getName());
        keyValTable.addRow("", "");
        keyValTable.addRow("Class A Enrichment Score (ES)", enrichmentScore.getES());
        keyValTable.addRow("Class A Normalized Enrichment Score (NES)", enrichmentScore.getNES());
        keyValTable.addRow("Class A Nominal P-Value", enrichmentScore.getNP());
        keyValTable.addRow("Class A FDR q-value", enrichmentScore.getFDR());
        keyValTable.addRow("Class A FWER p-Value", enrichmentScore.getFWER());
        keyValTable.addRow("Class B Enrichment Score (ES)", enrichmentScore2.getES());
        keyValTable.addRow("Class B Normalized Enrichment Score (NES)", enrichmentScore2.getNES());
        keyValTable.addRow("Class B Nominal P-Value", enrichmentScore2.getNP());
        keyValTable.addRow("Class b FDR q-value", enrichmentScore2.getFDR());
        keyValTable.addRow("Class B FWER p-Value", enrichmentScore2.getFWER());
        return keyValTable;
    }

    public static final XChart createHitProfileChart(Vector vector, RankedList rankedList, boolean bl, boolean bl2, boolean bl3) {
        IntervalMarker[] intervalMarkerArray = null;
        if (bl2) {
            intervalMarkerArray = EnrichmentReports._markers(rankedList);
        }
        return EnrichmentReports._createHitProfileChart(vector, bl, intervalMarkerArray, bl3);
    }

    protected static final XChart _createHitProfileChart(Vector vector, boolean bl, IntervalMarker[] intervalMarkerArray, boolean bl2) {
        XYPlot xYPlot;
        String string = bl ? "Hits" : "";
        String string2 = "Position in ranked list";
        if (bl2) {
            xYPlot = XChartUtils.lineYHits("HIT_LOCATION", "Position in ranked list", string, vector);
            xYPlot.getDomainAxis().setLabel(string2);
        } else {
            XYDatasetVERT xYDatasetVERT = new XYDatasetVERT(vector, string);
            NumberAxis numberAxis = new NumberAxis("none");
            numberAxis.setAutoRangeIncludesZero(false);
            NumberAxis numberAxis2 = new NumberAxis("Position in ranked list");
            numberAxis2.setTickMarksVisible(false);
            numberAxis2.setTickLabelsVisible(true);
            StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer(2);
            xYPlot = new XYPlot(xYDatasetVERT, numberAxis, numberAxis2, standardXYItemRenderer);
            xYPlot.getRangeAxis().setLabel(string2);
        }
        xYPlot.getRangeAxis().setTickLabelsVisible(false);
        xYPlot.getRangeAxis().setTickMarksVisible(false);
        xYPlot.setRangeGridlinesVisible(false);
        xYPlot.getRangeAxis().setLabel("");
        xYPlot.getDomainAxis().setTickLabelsVisible(false);
        xYPlot.getDomainAxis().setTickMarksVisible(false);
        xYPlot.getDomainAxis().setVisible(false);
        xYPlot.setDomainGridlinesVisible(false);
        if (bl) {
            xYPlot.getRenderer().setStroke(new BasicStroke(1.0f));
        } else {
            xYPlot.getRenderer().setStroke(new BasicStroke(0.0f));
        }
        xYPlot.getRenderer().setPaint(Color.BLACK);
        if (intervalMarkerArray != null && intervalMarkerArray.length > 0) {
            for (int i2 = 0; i2 < intervalMarkerArray.length; ++i2) {
                if (bl2) {
                    xYPlot.addDomainMarker(0, intervalMarkerArray[i2], Layer.BACKGROUND);
                    continue;
                }
                xYPlot.addRangeMarker(0, intervalMarkerArray[i2], Layer.BACKGROUND);
            }
        }
        return new XChartImpl("hit_locations", "Lines are drawn to represent positions in the ordered Dataset that match a gene in the GeneSet", new JFreeChart(xYPlot));
    }

    public static final XChart createNESvsSignificancePlot(EnrichmentDb enrichmentDb) {
        StandardXYItemRenderer standardXYItemRenderer;
        Vector vector = enrichmentDb.getNESS();
        Vector vector2 = enrichmentDb.getFDRs();
        for (int i2 = 0; i2 < vector2.getSize(); ++i2) {
            vector2.setElement(i2, vector2.getElement(i2) * 100.0f);
        }
        Vector[] vectorArray = new Vector[]{vector2};
        JFreeChart jFreeChart = XChartUtils.scatterOneXManyY("NES vs. Significance", new String[]{"FDR q-value"}, "NES", "FDR q-value", vector, vectorArray);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        NumberAxis numberAxis = new NumberAxis("Nominal P-value");
        numberAxis.setAutoRangeIncludesZero(false);
        xYPlot.setRangeAxis(1, numberAxis);
        XYDatasetMultiTmp xYDatasetMultiTmp = new XYDatasetMultiTmp(new String[]{"nominal p-value"}, vector, new Vector[]{enrichmentDb.getNPs()});
        xYPlot.setDataset(1, xYDatasetMultiTmp);
        xYPlot.mapDatasetToRangeAxis(1, 1);
        xYPlot = (XYPlot)jFreeChart.getPlot();
        IntervalMarker intervalMarker = new IntervalMarker(0.0, 25.0);
        intervalMarker.setLabelAnchor(RectangleAnchor.LEFT);
        intervalMarker.setPaint(GuiHelper.COLOR_LIGHT_YELLOW);
        xYPlot.addRangeMarker(intervalMarker, Layer.BACKGROUND);
        XYItemRenderer xYItemRenderer = xYPlot.getRenderer();
        if (xYItemRenderer instanceof StandardXYItemRenderer) {
            standardXYItemRenderer = (StandardXYItemRenderer)xYItemRenderer;
            standardXYItemRenderer.setBaseShapesVisible(true);
            standardXYItemRenderer.setShapesFilled(true);
            standardXYItemRenderer.setSeriesPaint(0, Color.MAGENTA);
        }
        standardXYItemRenderer = new StandardXYItemRenderer();
        standardXYItemRenderer.setSeriesPaint(0, Color.BLACK);
        standardXYItemRenderer.setBaseShapesVisible(true);
        standardXYItemRenderer.setDrawSeriesLineAsPath(false);
        xYPlot.setRenderer(1, standardXYItemRenderer);
        LegendTitle legendTitle = new LegendTitle(xYItemRenderer);
        LegendTitle legendTitle2 = new LegendTitle(standardXYItemRenderer);
        BlockContainer blockContainer = new BlockContainer(new BorderArrangement());
        blockContainer.add(legendTitle, RectangleEdge.LEFT);
        blockContainer.add(legendTitle2, RectangleEdge.RIGHT);
        blockContainer.add(new EmptyBlock(2000.0, 0.0));
        CompositeTitle compositeTitle = new CompositeTitle(blockContainer);
        compositeTitle.setPosition(RectangleEdge.BOTTOM);
        jFreeChart.addSubtitle(compositeTitle);
        return new XChartImpl("pvalues_vs_nes_plot", "p-values vs. NES for " + enrichmentDb.getName(), jFreeChart);
    }

    public static final XChart createGlobalESHistogram(String string, LabelledVector labelledVector) {
        int n = 20;
        if (labelledVector.getSize() < 20) {
            n = labelledVector.getSize();
        }
        JFreeChart jFreeChart = XChartUtils.createHistogram(string, false, "Enrichment score (ES)", "# of gene sets", labelledVector.getScoresV(false), true, n, HistogramType.FREQUENCY);
        jFreeChart.getXYPlot().getRenderer().setStroke(new BasicStroke(2.0f));
        return new XChartImpl("global_es_histogram", "Global histogram of ES for <b>" + string + "</b>", jFreeChart);
    }

    public static final XChart createESNullDistribHistogram(EnrichmentResult enrichmentResult) {
        String string = null;
        String string2 = null;
        if (enrichmentResult.getTemplate().isCategorical()) {
            string = enrichmentResult.getTemplate().getClassName(0);
            string2 = enrichmentResult.getTemplate().getClassName(1);
        }
        return EnrichmentReports.createESNullDistribHistogram(enrichmentResult.getGeneSet().getName(true), string, string2, enrichmentResult.getScore().getES(), enrichmentResult.getRndESS());
    }

    public static final XChart createESNullDistribHistogram(String string, String string2, String string3, float f2, Vector vector) {
        IntervalMarker intervalMarker;
        float f3;
        int n = 20;
        if (vector.getSize() < 20) {
            n = vector.getSize();
        }
        JFreeChart jFreeChart = XChartUtils.createHistogram(string + ": Random ES distribution", false, "ES", "P(ES)", vector, true, n, HistogramType.FREQUENCY);
        jFreeChart.getXYPlot().getRenderer().setStroke(new BasicStroke(2.0f));
        jFreeChart.getXYPlot().getRenderer().setPaint(Color.MAGENTA);
        ValueMarker valueMarker = new ValueMarker(f2);
        valueMarker.setPaint(Color.BLACK);
        valueMarker.setStroke(new BasicStroke(2.0f, 0, 0, 3.0f, new float[]{5.0f, 3.0f, 3.0f, 3.0f}, 0.0f));
        String string4 = "Real ES " + Printf.format(f2, 1);
        valueMarker.setLabel(string4);
        if (XMath.isPositive(f2)) {
            valueMarker.setLabelAnchor(RectangleAnchor.BOTTOM_LEFT);
        } else {
            valueMarker.setLabelAnchor(RectangleAnchor.BOTTOM_RIGHT);
        }
        jFreeChart.getXYPlot().addDomainMarker(valueMarker);
        float f4 = 100.0f * ((float)vector.extract(ScoreMode.POS_ONLY).getSize() / (float)vector.getSize());
        XYTextAnnotation xYTextAnnotation = new XYTextAnnotation("Sets with pos scores: " + Printf.format(f4, 0) + "%", 0.0, 2.0);
        jFreeChart.getXYPlot().addAnnotation(xYTextAnnotation);
        if (string2 != null && string2.length() > 0) {
            f3 = vector.max() - 0.25f;
            intervalMarker = new IntervalMarker(f3, f3);
            intervalMarker.setLabel("'" + string2 + "' (Pos ES)");
            intervalMarker.setLabelFont(new Font("SansSerif", 0, 10));
            intervalMarker.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
            intervalMarker.setLabelTextAnchor(TextAnchor.TOP_RIGHT);
            intervalMarker.setLabelPaint(Color.RED);
            jFreeChart.getXYPlot().addDomainMarker(intervalMarker);
        }
        if (string3 != null && string3.length() > 0) {
            f3 = vector.min() + 0.25f;
            intervalMarker = new IntervalMarker(f3, f3);
            intervalMarker.setLabel("'" + string3 + "' (Neg ES)");
            intervalMarker.setLabelFont(new Font("SansSerif", 0, 10));
            intervalMarker.setLabelAnchor(RectangleAnchor.TOP_LEFT);
            intervalMarker.setLabelTextAnchor(TextAnchor.TOP_LEFT);
            intervalMarker.setLabelPaint(Color.BLUE);
            jFreeChart.getXYPlot().addDomainMarker(intervalMarker);
        }
        return new XChartImpl("gset_rnd_es_dist", "Gene set null distribution of ES for <b>" + string + "</b>", jFreeChart);
    }

    public static final EnrichmentCharts createComboChart(EnrichmentResult enrichmentResult, boolean bl) {
        String string = null;
        String string2 = null;
        if (enrichmentResult.getTemplate() != null && enrichmentResult.getTemplate().isCategorical()) {
            string = enrichmentResult.getTemplate().getClassName(0);
            string2 = enrichmentResult.getTemplate().getClassName(1);
        }
        return EnrichmentReports.createComboChart(enrichmentResult.getGeneSet().getName(true), enrichmentResult.getScore().getESProfile(), enrichmentResult.getScore().getESProfile_point_by_point_opt(), enrichmentResult.getScore().getHitIndices(), enrichmentResult.getRankedList(), string, string2, bl);
    }

    public static final EnrichmentCharts[] createComboCharts(EnrichmentResult[] enrichmentResultArray, boolean bl) {
        EnrichmentCharts[] enrichmentChartsArray = new EnrichmentCharts[enrichmentResultArray.length];
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            enrichmentChartsArray[i2] = EnrichmentReports.createComboChart(enrichmentResultArray[i2], bl);
        }
        return enrichmentChartsArray;
    }

    public static final EnrichmentCharts createComboChart(String string, Vector vector, Vector vector2, int[] nArray, RankedList rankedList, String string2, String string3, boolean bl) {
        return EnrichmentReports.createComboChart(string, vector, vector2, EnrichmentReports._hitIndices2Vector(rankedList.getSize(), nArray), rankedList, string2, string3, bl);
    }

    public static final EnrichmentCharts createComboChart(String string, Vector vector, Vector vector2, Vector vector3, RankedList rankedList, String string2, String string3, boolean bl) {
        int n = rankedList.getSize() < 100 ? rankedList.getSize() : 100;
        return EnrichmentReports._createComboChart(string, vector, vector2, vector3, rankedList, string2, string3, RankedListCharts.createIntervalMarkers(n, rankedList), bl);
    }

    public static final EnrichmentCharts _createComboChart(String string, Vector vector, Vector vector2, Vector vector3, RankedList rankedList, String string2, String string3, IntervalMarker[] intervalMarkerArray, boolean bl) {
        XComboChart xComboChart;
        if (vector == null) {
            throw new IllegalArgumentException("Param scoreProfile cannot be null");
        }
        if (vector3 == null) {
            throw new IllegalArgumentException("Param hitProfile cannot be null");
        }
        if (rankedList == null) {
            throw new IllegalArgumentException("Param rl cannot be null");
        }
        XChart xChart = EnrichmentReports.createESProfileChart(vector, vector2, vector3, bl);
        XChart xChart2 = EnrichmentReports.createHitProfileChart(vector3, rankedList, true, false, bl);
        XChart xChart3 = EnrichmentReports._createHitProfileChart(vector3, false, intervalMarkerArray, bl);
        XChart xChart4 = RankedListCharts.createRankedListChart(rankedList, string2, string3, vector.maxDevFrom0Index(), bl);
        if (bl) {
            XComboDomainChart xComboDomainChart = new XComboDomainChart(ENPLOT_ + string, "Enrichment plot: " + string, "Profile of the Running ES Score & Positions of GeneSet Members on the Rank Ordered List", "Rank in Ordered Dataset", new XChart[]{xChart, xChart2, xChart3, xChart4}, new int[]{12, 4, 1, 8});
            xComboDomainChart.getCombinedXYPlot().setGap(0.0);
            xComboDomainChart.getCombinedXYPlot().getDomainAxis().setTickLabelsVisible(true);
            xComboDomainChart.getCombinedXYPlot().getDomainAxis().setTickMarksVisible(true);
            xComboChart = xComboDomainChart;
        } else {
            XComboRangeChart xComboRangeChart = new XComboRangeChart(ENPLOT_ + string, "Enrichment plot: " + string, "Profile of the Running ES Score & Positions of GeneSet Members on the Rank Ordered List", "Rank in Ordered Dataset", new XChart[]{xChart, xChart2, xChart3, xChart4}, new int[]{12, 4, 1, 8});
            xComboRangeChart.getCombinedXYPlot().setGap(0.0);
            xComboRangeChart.getCombinedXYPlot().getRangeAxis().setTickLabelsVisible(true);
            xComboRangeChart.getCombinedXYPlot().getRangeAxis().setTickMarksVisible(true);
            xComboChart = xComboRangeChart;
        }
        return new EnrichmentCharts(xChart, xChart2, xChart3, xChart4, xComboChart);
    }

    public static final XChart createESProfileChart(Vector vector, Vector vector2, Vector vector3, boolean bl) {
        JFreeChart jFreeChart;
        Object object;
        if (vector2 == null) {
            object = new EnrichmentReports$EsProfileDataset("Enrichment profile", vector, vector3, bl);
            jFreeChart = ChartFactory.createXYLineChart("Enrichment profile", "Enrichment profile", "Running enrichment score (RES)", (XYDataset)object, PlotOrientation.VERTICAL, true, false, false);
        } else {
            object = new EnrichmentReports$EsProfileDataset2("Enrichment profile", vector2, bl);
            jFreeChart = ChartFactory.createXYLineChart("Enrichment profile", "Enrichment profile", "Running enrichment score (RES)", (XYDataset)object, PlotOrientation.VERTICAL, true, false, false);
        }
        jFreeChart.getXYPlot().getRangeAxis().setTickLabelsVisible(true);
        jFreeChart.getXYPlot().getRangeAxis().setTickMarksVisible(true);
        jFreeChart.getXYPlot().getDomainAxis().setTickLabelsVisible(true);
        jFreeChart.getXYPlot().getDomainAxis().setTickMarksVisible(true);
        if (bl) {
            jFreeChart.getXYPlot().getRangeAxis().setLabel("Enrichment score (ES)");
            jFreeChart.getXYPlot().getDomainAxis().setLabel("Position in ranked list");
            jFreeChart.getXYPlot().getDomainAxis().setVisible(true);
        } else {
            jFreeChart.getXYPlot().getDomainAxis().setLabel("Enrichment score (ES)");
            jFreeChart.getXYPlot().getRangeAxis().setLabel("Position in ranked list");
            jFreeChart.getXYPlot().getRangeAxis().setVisible(true);
        }
        jFreeChart.getXYPlot().getRenderer().setStroke(new BasicStroke(2.0f));
        jFreeChart.getXYPlot().getRenderer().setPaint(Color.GREEN);
        object = new ValueMarker(0.0);
        ((Marker)object).setPaint(Color.DARK_GRAY);
        if (bl) {
            jFreeChart.getXYPlot().addRangeMarker((Marker)object);
        } else {
            jFreeChart.getXYPlot().addDomainMarker((Marker)object);
        }
        return new XChartImpl("Enrichment profile", "Enrichment profile", jFreeChart);
    }

    public static final XChart createHitProfileChart(BooleanVector booleanVector, RankedList rankedList, boolean bl, boolean bl2, boolean bl3) {
        return EnrichmentReports.createHitProfileChart(booleanVector.toVector(), rankedList, bl, bl2, bl3);
    }

    protected static final Vector _hitIndices2Vector(int n, int[] nArray) {
        Vector vector = new Vector(n);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            vector.setElement(nArray[i2], 1.0f);
        }
        return vector;
    }

    private static File _getGeneSetSizesFile(GeneSet[] geneSetArray, GeneSet[] geneSetArray2, File file, ToolReport toolReport) {
        if (file == null) {
            try {
                String[] stringArray = new String[]{"ORIGINAL SIZE", "AFTER RESTRICTING TO DATASET", "STATUS"};
                String[] stringArray2 = new String[geneSetArray2.length];
                StringMatrix stringMatrix = new StringMatrix(geneSetArray2.length, stringArray.length);
                DefaultGeneSetMatrix defaultGeneSetMatrix = new DefaultGeneSetMatrix("after", geneSetArray);
                for (int i2 = 0; i2 < geneSetArray2.length; ++i2) {
                    String string;
                    stringArray2[i2] = string = AuxUtils.getAuxNameOnlyNoHash(geneSetArray2[i2].getName());
                    stringMatrix.setElement(i2, 0, geneSetArray2[i2].getNumMembers());
                    if (defaultGeneSetMatrix.containsSet(string)) {
                        stringMatrix.setElement(i2, 1, defaultGeneSetMatrix.getGeneSet(string).getNumMembers());
                        continue;
                    }
                    stringMatrix.setElement(i2, 2, "Rejected!");
                }
                file = toolReport.savePageXls(new StringDataframe("gene_set_sizes", stringMatrix, stringArray2, stringArray, true));
            }
            catch (Throwable throwable) {
                klog.error(throwable);
                file = toolReport.createFile("gene_set_sizes_errored_out.txt", "List of gene sets that errored out");
                FileUtils.writeSafely(throwable.getStackTrace().toString(), file);
            }
        }
        return file;
    }
}

