/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.math.StringMatrix;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class StringDataframeParser
extends AbstractParser {
    public StringDataframeParser() {
        super(StringDataframe.class);
    }

    @Override
    public final void export(PersistentObject persistentObject, File file) {
        PrintWriter printWriter = this.startExport(persistentObject, file);
        this._export(persistentObject, printWriter);
    }

    @Override
    public final void export(PersistentObject persistentObject, OutputStream outputStream) {
        PrintWriter printWriter = this.startExport(persistentObject, outputStream, null);
        this._export(persistentObject, printWriter);
    }

    private void _export(PersistentObject persistentObject, PrintWriter printWriter) {
        int n;
        StringDataframe stringDataframe = (StringDataframe)persistentObject;
        String string = stringDataframe.getRowLabelName();
        if (string == null) {
            string = "NAME";
        }
        printWriter.print(string + "\t");
        for (n = 0; n < stringDataframe.getNumCol(); ++n) {
            printWriter.print(stringDataframe.getColumnName(n));
            printWriter.print('\t');
        }
        printWriter.println();
        for (n = 0; n < stringDataframe.getNumRow(); ++n) {
            printWriter.print(stringDataframe.getRowName(n));
            printWriter.print('\t');
            String[] stringArray = stringDataframe.getRow(n);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                printWriter.print(stringArray[i2]);
                printWriter.print('\t');
            }
            printWriter.println();
        }
        printWriter.close();
        this.doneExport();
    }

    public final StringDataframe parse(String string, String string2) {
        this.startImport(string);
        StringReader stringReader = new StringReader(string2);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        return this.parseSdf(string, bufferedReader);
    }

    public final StringDataframe parse(String string) {
        String string2 = NamingConventions.generateName("dfr");
        return this.parse(string2, string);
    }

    @Override
    public final List parse(String string, InputStream inputStream) {
        this.startImport(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringDataframe stringDataframe = this.parseSdf(string, bufferedReader);
        return StringDataframeParser.unmodlist(new PersistentObject[]{stringDataframe});
    }

    protected final StringDataframe parseSdf(String string, BufferedReader bufferedReader) {
        return this.parseSdf(string, bufferedReader, this.nextNonEmptyLine(bufferedReader));
    }

    public final StringDataframe parseSdf(File file) {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        return this.parseSdf(file.getName(), bufferedReader, this.nextNonEmptyLine(bufferedReader));
    }

    protected final StringDataframe parseSdf(String string, BufferedReader bufferedReader, String string2) {
        String string3 = string2;
        List list = ParseUtils.string2stringsList(string3, "\t");
        list.remove(0);
        ArrayList<String> arrayList = new ArrayList<String>();
        string3 = this.nextLineTrimless(bufferedReader);
        while (string3 != null) {
            arrayList.add(string3);
            string3 = this.nextLineTrimless(bufferedReader);
        }
        StringDataframe stringDataframe = this._parse(string, arrayList, list);
        bufferedReader.close();
        this.doneImport();
        return stringDataframe;
    }

    public final StringDataframe parseSdf(String string, List list) {
        List list2 = ParseUtils.string2stringsList(list.get(0).toString(), "\t");
        list2.remove(0);
        list.remove(0);
        return this._parse(string, list, list2);
    }

    private StringDataframe _parse(String string, List list, List list2) {
        StringMatrix stringMatrix = new StringMatrix(list.size(), list2.size());
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string3 = (String)list.get(i2);
            List list3 = StringDataframeParser.string2stringsV2(string3, list2.size() + 1);
            if (list3.size() != list2.size() + 1) {
                throw new ParserException("Bad format - expect ncols: " + (list2.size() + 1) + " but found: " + list3.size() + " on line: " + string3);
            }
            String string4 = (String)list3.get(0);
            arrayList.add(string4);
            for (int i3 = 1; i3 < list3.size(); ++i3) {
                String string5 = list3.get(i3).toString();
                if (string5.equalsIgnoreCase("NULL")) {
                    stringMatrix.setElement(i2, i3 - 1, string2);
                    continue;
                }
                stringMatrix.setElement(i2, i3 - 1, string5);
            }
        }
        StringDataframe stringDataframe = new StringDataframe(string, stringMatrix, arrayList, list2, true);
        stringDataframe.addComment(this.fComment.toString());
        return stringDataframe;
    }
}

