/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import edu.mit.broad.genome.reports.api.Report;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import xtools.api.DefaultReport;

public class ReportParser
extends AbstractParser {
    public ReportParser() {
        super(Report.class);
    }

    @Override
    public final void export(PersistentObject persistentObject, File file) {
        File[] fileArray;
        PrintWriter printWriter = this.startExport(persistentObject, file);
        Report report = (Report)persistentObject;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("producer_class").append('\t').append(report.getProducer().getName()).append('\n');
        stringBuffer.append("producer_timestamp").append('\t').append(report.getTimestamp()).append('\n');
        Properties properties = report.getParametersUsed();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            fileArray = enumeration.nextElement().toString();
            String string = properties.getProperty((String)fileArray);
            stringBuffer.append("param").append('\t').append((String)fileArray).append('\t').append(string).append('\n');
        }
        stringBuffer.append('\n');
        fileArray = report.getFilesProduced();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            stringBuffer.append("file").append('\t').append(fileArray[i2].getPath()).append('\n');
        }
        printWriter.print(stringBuffer.toString());
        printWriter.close();
        this.doneExport();
    }

    @Override
    public final List parse(String string, InputStream inputStream) {
        Object[] objectArray;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = this.nextLine(bufferedReader);
        ArrayList<File> arrayList = new ArrayList<File>();
        Properties properties = new Properties();
        Class<?> clazz = null;
        long l2 = 0L;
        while (string2 != null) {
            objectArray = ParseUtils.string2strings(string2, "\t", false);
            if (objectArray.length != 2 && objectArray.length != 3) {
                throw new ParserException("Bad Report format -- expect 2 or 3, found: " + objectArray.length + " line: " + string2);
            }
            if (objectArray[0].equalsIgnoreCase("producer_class")) {
                if (objectArray.length != 2) {
                    throw new ParserException(">2 fields for producer_class line: " + string2);
                }
                clazz = Class.forName((String)objectArray[1]);
            }
            if (((String)objectArray[0]).equalsIgnoreCase("producer_timestamp")) {
                if (objectArray.length != 2) {
                    throw new ParserException(">2 fields for producer_timestamp line: " + string2);
                }
                l2 = Long.parseLong((String)objectArray[1]);
            }
            if (((String)objectArray[0]).equalsIgnoreCase("file")) {
                if (objectArray.length != 2) {
                    throw new ParserException(">2 fields for file line: " + string2);
                }
                arrayList.add(new File((String)objectArray[1]));
            } else if (((String)objectArray[0]).equalsIgnoreCase("param")) {
                if (objectArray.length != 3) {
                    throw new ParserException("Insufficient fields for param line: " + string2);
                }
                properties.put(objectArray[1], objectArray[2]);
            }
            string2 = this.nextLine(bufferedReader);
        }
        bufferedReader.close();
        objectArray = arrayList.toArray(new File[arrayList.size()]);
        DefaultReport defaultReport = new DefaultReport(string, l2, clazz, (File[])objectArray, properties, false);
        return ReportParser.unmodlist(defaultReport);
    }
}

