/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.alg.RankedListGenerators;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.objects.DefaultRankedList;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import gnu.trove.TFloatArrayList;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class RankedListParser
extends AbstractParser {
    public RankedListParser() {
        super(RankedList.class);
    }

    @Override
    public final void export(PersistentObject persistentObject, File file) {
        RankedList rankedList = (RankedList)persistentObject;
        PrintWriter printWriter = this.startExport(persistentObject, file);
        for (int i2 = 0; i2 < rankedList.getSize(); ++i2) {
            printWriter.println(rankedList.getRankName(i2) + "\t" + rankedList.getScore(i2));
        }
        printWriter.close();
        this.doneExport();
    }

    public final List parse(String string, String string2) {
        StringReader stringReader = new StringReader(string2);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        return this._parse(string, bufferedReader);
    }

    public final List parse(String string) {
        String string2 = NamingConventions.generateName("rnk");
        return this.parse(string2, string);
    }

    @Override
    public final List parse(String string, InputStream inputStream) {
        this.startImport(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return this._parse(string, bufferedReader);
    }

    public final List parse_fast_no_sort(String string, InputStream inputStream) {
        this.startImport(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return this._parse_fast_no_sort(string, bufferedReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List _parse(String string, BufferedReader bufferedReader) {
        Object object;
        String string2 = this.nextLine(bufferedReader);
        string = NamingConventions.removeExtension(new File(string).getName());
        ArrayList<String> arrayList = new ArrayList<String>();
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        int n = 0;
        while (string2 != null) {
            object = ParseUtils.string2strings(string2, "\t", false);
            if (((String[])object).length != 2) {
                throw new ParserException("Bad rnk file format exception - expected 2 fields but got: " + ((String[])object).length + " line>" + string2 + "<");
            }
            boolean bl = true;
            if (object[0].equalsIgnoreCase("Name") || object[1].equalsIgnoreCase("Rank")) {
                bl = false;
            }
            if (n == 0) {
                try {
                    Float.parseFloat(object[1]);
                }
                catch (Throwable throwable) {
                    bl = false;
                }
                finally {
                    ++n;
                }
            }
            if (bl) {
                arrayList.add(object[0]);
                tFloatArrayList.add(Float.parseFloat(object[1]));
            }
            string2 = this.nextLine(bufferedReader);
        }
        bufferedReader.close();
        this.doneImport();
        object = RankedListGenerators.createBySorting(string, arrayList.toArray(new String[arrayList.size()]), tFloatArrayList.toNativeArray(), SortMode.REAL, Order.DESCENDING);
        return RankedListParser.unmodlist((PersistentObject)object);
    }

    private List _parse_fast_no_sort(String string, BufferedReader bufferedReader) {
        String string2 = this.nextLine(bufferedReader);
        string = NamingConventions.removeExtension(new File(string).getName());
        ArrayList<String> arrayList = new ArrayList<String>();
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        while (string2 != null) {
            String[] stringArray = ParseUtils.string2strings(string2, "\t", false);
            if (stringArray.length != 2) {
                throw new ParserException("Bad rnk file format exception - expected 2 fields but got: " + stringArray.length + " line>" + string2 + "<");
            }
            arrayList.add(stringArray[0]);
            tFloatArrayList.add(Float.parseFloat(stringArray[1]));
            string2 = this.nextLine(bufferedReader);
        }
        bufferedReader.close();
        this.doneImport();
        return RankedListParser.unmodlist(new DefaultRankedList(string, arrayList.toArray(new String[arrayList.size()]), tFloatArrayList));
    }
}

