/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.AnnotImpl;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.FeatureAnnotImpl;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.SampleAnnotImpl;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import edu.mit.broad.genome.utils.FileUtils;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class PclParser
extends AbstractParser {
    protected PclParser() {
        super(Dataset.class);
    }

    @Override
    public final void export(PersistentObject persistentObject, File file) {
        int n;
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        Dataset dataset = (Dataset)persistentObject;
        FeatureAnnot featureAnnot = dataset.getAnnot().getFeatureAnnot();
        printWriter.print("UNIQUID\tNAME\tGWEIGHT\t");
        for (n = 0; n < dataset.getNumCol(); ++n) {
            printWriter.print(dataset.getColumnName(n));
            if (n == dataset.getNumCol() - 1) continue;
            printWriter.print('\t');
        }
        printWriter.println();
        printWriter.print("EWEIGHT\t\t\t");
        for (n = 0; n < dataset.getNumCol(); ++n) {
            printWriter.print("1");
            if (n == dataset.getNumCol() - 1) continue;
            printWriter.print('\t');
        }
        printWriter.println();
        for (n = 0; n < dataset.getNumRow(); ++n) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = dataset.getRowName(n);
            stringBuffer.append(string).append('\t');
            stringBuffer.append(featureAnnot.getNativeDesc(string)).append('\t');
            stringBuffer.append("1\t");
            stringBuffer.append(dataset.getRow(n).toString('\t'));
            printWriter.println(stringBuffer.toString());
        }
        printWriter.close();
        this.doneExport();
    }

    @Override
    public final List parse(String string, InputStream inputStream) {
        Object object;
        Object object2;
        Object object3;
        this.startImport(string);
        int n = FileUtils.countLines(string, true);
        int n2 = n - 2;
        this.log.debug("Number of float lines = " + n2);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = this.nextLine(bufferedReader);
        List list = ParseUtils.string2stringsList(string2, "\t");
        int n3 = list.size();
        list.remove(0);
        list.remove(0);
        list.remove(0);
        this.log.debug("Number of columns of floats = " + list.size());
        this.nextLine(bufferedReader);
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(n2);
        Matrix matrix = new Matrix(n2, list.size());
        int n4 = 0;
        string2 = this.nextLineTrimless(bufferedReader);
        while (string2 != null) {
            object3 = PclParser.string2stringsV2(string2, n3);
            if (object3.size() != n3) {
                throw new ParserException("Invalid format on line: " + string2 + " expected # fields = " + n3 + " but found: " + object3.size());
            }
            object2 = object3.get(0).toString().trim();
            if (((String)object2).length() == 0) {
                throw new ParserException("Bad rowname - cant be empty at: " + n4 + " >" + string2);
            }
            arrayList.add(object2);
            object = object3.get(1).toString().trim();
            if (((String)object).length() == 0) {
                throw new ParserException("Bad rowdescname - cant be empty at: " + n4 + " >" + string2);
            }
            arrayList2.add(object);
            if (Integer.parseInt(object3.get(2).toString()) != 1) {
                throw new ParserException("Expected field was not 1 for GWEIGHT: " + object3.get(2) + " " + string2);
            }
            for (int i2 = 3; i2 < object3.size(); ++i2) {
                String string3 = object3.get(i2).toString().trim();
                float f2 = string3.length() == 0 ? Float.NaN : Float.parseFloat(string3);
                matrix.setElement(n4, i2 - 3, f2);
            }
            ++n4;
            string2 = this.nextLineTrimless(bufferedReader);
        }
        bufferedReader.close();
        object3 = new File(string).getName();
        object2 = new FeatureAnnotImpl((String)object3, arrayList, arrayList2);
        object2.addComment(this.fComment.toString());
        object = new SampleAnnotImpl((String)object3, list, null);
        DefaultDataset defaultDataset = new DefaultDataset((String)object3, matrix, arrayList, list, true, (Annot)new AnnotImpl((FeatureAnnot)object2, (SampleAnnot)object));
        defaultDataset.addComment(this.fComment.toString());
        this.doneImport();
        return PclParser.unmodlist(new PersistentObject[]{defaultDataset});
    }
}

