/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParserException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class GmtParser
extends AbstractParser {
    public GmtParser() {
        super(GeneSetMatrix.class);
    }

    @Override
    public final void export(PersistentObject persistentObject, File file) {
        PrintWriter printWriter = this.startExport(persistentObject, file);
        GeneSetMatrix geneSetMatrix = (GeneSetMatrix)persistentObject;
        for (int i2 = 0; i2 < geneSetMatrix.getNumGeneSets(); ++i2) {
            GeneSet geneSet = geneSetMatrix.getGeneSet(i2);
            StringBuffer stringBuffer = new StringBuffer(geneSet.getName()).append('\t');
            String string = geneSet.getNameEnglish();
            if (this.isNullorNa(string)) {
                string = "na";
            }
            stringBuffer.append(string).append('\t');
            for (int i3 = 0; i3 < geneSet.getNumMembers(); ++i3) {
                stringBuffer.append(geneSet.getMember(i3));
                if (i3 >= geneSet.getNumMembers() - 1) continue;
                stringBuffer.append('\t');
            }
            stringBuffer.append('\n');
            printWriter.print(stringBuffer.toString());
        }
        printWriter.close();
        this.doneExport();
    }

    @Override
    public final List parse(String string, InputStream inputStream) {
        this.startImport(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = this.nextLine(bufferedReader);
        int n = 0;
        ArrayList<FSet> arrayList = new ArrayList<FSet>();
        while (string2 != null) {
            String string3;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t");
            int n2 = stringTokenizer.countTokens();
            if (n2 <= 1) {
                throw new ParserException("Empty gene line: " + string2 + " at row: " + n);
            }
            String string4 = stringTokenizer.nextToken().trim().toUpperCase();
            String string5 = stringTokenizer.nextToken().trim();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken().trim();
                if (this.isNull(string3)) continue;
                arrayList2.add(string3);
            }
            string3 = string.concat("#").concat(string4);
            FSet fSet = new FSet(string3, string5, arrayList2, true);
            arrayList.add(fSet);
            ++n;
            string2 = this.nextLine(bufferedReader);
        }
        bufferedReader.close();
        this.doneImport();
        return GmtParser.unmodlist(new DefaultGeneSetMatrix(string, arrayList));
    }
}

