/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Dataframe;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import gnu.trove.TFloatArrayList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class DataframeParser
extends AbstractParser {
    public DataframeParser() {
        super(Dataframe.class);
    }

    @Override
    public final void export(PersistentObject persistentObject, File file) {
        PrintWriter printWriter = this.startExport(persistentObject, file);
        this._export(persistentObject, printWriter);
    }

    @Override
    public final void export(PersistentObject persistentObject, OutputStream outputStream) {
        PrintWriter printWriter = this.startExport(persistentObject, outputStream, null);
        this._export(persistentObject, printWriter);
    }

    private void _export(PersistentObject persistentObject, PrintWriter printWriter) {
        int n;
        Dataframe dataframe = (Dataframe)persistentObject;
        printWriter.print("NAME\t");
        for (n = 0; n < dataframe.getNumCol(); ++n) {
            printWriter.print(dataframe.getColumnName(n));
            printWriter.print('\t');
        }
        printWriter.println();
        for (n = 0; n < dataframe.getNumRow(); ++n) {
            printWriter.print(dataframe.getRowName(n));
            printWriter.print('\t');
            printWriter.println(dataframe.getRow(n).toString('\t'));
        }
        printWriter.close();
        this.doneExport();
    }

    public final void exportWithDescs(Dataframe dataframe, List list, File file) {
        int n;
        this.startExport(dataframe, file);
        if (list == null) {
            throw new IllegalArgumentException("Param file cannot be null");
        }
        if (dataframe.getNumRow() != list.size()) {
            throw new IllegalArgumentException("Num of rows in dataframe: " + dataframe.getNumRow() + " not equal to num of row descs: " + list.size());
        }
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        printWriter.print("NAME\tDESCRIPTION\t");
        for (n = 0; n < dataframe.getNumCol(); ++n) {
            printWriter.print(dataframe.getColumnName(n));
            printWriter.print('\t');
        }
        printWriter.println();
        for (n = 0; n < dataframe.getNumRow(); ++n) {
            printWriter.print(dataframe.getRowName(n));
            printWriter.print('\t');
            printWriter.print(list.get(n));
            printWriter.print('\t');
            printWriter.println(dataframe.getRow(n).toString('\t'));
        }
        printWriter.close();
        this.doneExport();
    }

    public final List parse(String string, String string2) {
        StringReader stringReader = new StringReader(string);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        return this._parse(string2, bufferedReader);
    }

    public final List parse(String string) {
        String string2 = NamingConventions.generateName("dfr");
        return this.parse(string, string2);
    }

    @Override
    public final List parse(String string, InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return this._parse(string, bufferedReader);
    }

    protected final Dataframe parseDf(String string, BufferedReader bufferedReader) {
        Object object;
        Object object2;
        this.startImport(string);
        String string2 = this.nextLine(bufferedReader);
        List list = ParseUtils.string2stringsList(string2, " \t");
        list.remove(0);
        string2 = this.nextLine(bufferedReader);
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (string2 != null) {
            object2 = ParseUtils.string2stringsList(string2, " \t");
            if (object2.size() != list.size() + 1) {
                throw new ParserException("Bad format - expect ncols: " + (list.size() + 1) + " but found: " + object2.size() + " on line: " + string2);
            }
            object = (String)object2.get(0);
            arrayList.add((String)object);
            for (int i2 = 1; i2 < object2.size(); ++i2) {
                tFloatArrayList.add(Float.parseFloat(object2.get(i2).toString()));
            }
            string2 = this.nextLine(bufferedReader);
        }
        bufferedReader.close();
        this.doneImport();
        this.log.info("Completed parsing DATAFRAME");
        object2 = new Matrix(arrayList.size(), list.size(), tFloatArrayList);
        object = new Dataframe(string, (Matrix)object2, arrayList, list, true, true, true);
        ((AbstractObject)object).addComment(this.fComment.toString());
        return object;
    }

    private List _parse(String string, BufferedReader bufferedReader) {
        Dataframe dataframe = this.parseDf(string, bufferedReader);
        return DataframeParser.unmodlist(new PersistentObject[]{dataframe});
    }
}

