/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.utils.Strings;
import java.io.File;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class AuxUtils {
    private static final Logger klog = XLogger.getLogger(AuxUtils.class);

    private AuxUtils() {
    }

    public static final String[] toAuxNamesNoHash(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray2[i2] = AuxUtils.getAuxNameOnlyNoHash(stringArray[i2]);
        }
        return stringArray2;
    }

    public static final String getAuxNameOnlyIncludingHash(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
        stringTokenizer.nextToken();
        return "#" + stringTokenizer.nextToken();
    }

    public static final String getAuxNameOnlyNoHash(PersistentObject persistentObject) {
        if (persistentObject == null) {
            throw new IllegalArgumentException("Param pob cannot be null");
        }
        return AuxUtils.getAuxNameOnlyNoHash(persistentObject.getName());
    }

    public static final String getAuxNameOnlyNoHash(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
        String string2 = string;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return string2;
    }

    public static final String getBaseNameOnly(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
        return stringTokenizer.nextToken();
    }

    public static final String getAuxNameOnlyNoHash(File file) {
        return AuxUtils.getAuxNameOnlyNoHash(file.getPath());
    }

    public static final File getBaseFileFromFullPath(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter fullPathMaybeWithAux cannot be null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Parameter fullPathMaybeWithAux cannot be empty");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "#@");
        File file = stringTokenizer.countTokens() == 1 ? new File(string) : new File(stringTokenizer.nextToken());
        return file;
    }

    public static final File getBaseFileFromAuxFile(File file) {
        return AuxUtils.getBaseFileFromFullPath(file.getPath());
    }

    public static final String getBasePathFromAuxPath(String string) {
        return AuxUtils.getBaseFileFromFullPath(string).getPath();
    }

    public static final String getBaseStringFromAux(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
        if (stringTokenizer.countTokens() == 1) {
            return string;
        }
        return stringTokenizer.nextToken();
    }

    public static final boolean isAux(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
        if (stringTokenizer.countTokens() == 1) {
            return false;
        }
        if (stringTokenizer.countTokens() >= 2) {
            return true;
        }
        throw new RuntimeException("Cannot process files named # tokens found: " + stringTokenizer.countTokens() + " aux_name_or_path>" + string + "<");
    }

    public static final boolean isAuxFile(File file) {
        if (Strings.contains(file.getAbsolutePath(), "#")) {
            return true;
        }
        return Strings.contains(file.getAbsolutePath(), "@");
    }

    public static final boolean isFromSameBase(String string, String string2) {
        String string3 = AuxUtils.getBaseStringFromAux(string);
        String string4 = AuxUtils.getBaseStringFromAux(string2);
        return string3.equals(string4);
    }

    public static final boolean isAllFromSameBase(String string, String[] stringArray) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            boolean bl = AuxUtils.isFromSameBase(string, stringArray[i2]);
            if (bl) continue;
            klog.debug("Not from same aux: " + string + " and " + stringArray[i2]);
            return false;
        }
        return true;
    }

    public static final boolean isAllFromSameBase(String[] stringArray) {
        return AuxUtils.isAllFromSameBase(stringArray[0], stringArray);
    }

    public static final File getBaseDatasetSourceFile(Dataset dataset) {
        String string = dataset.getName();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "@");
        File file = ParserFactory.getCache().getSourceFile(dataset);
        if (file == null) {
            throw new RuntimeException("No source file for pwd's source dataset: " + dataset.getName());
        }
        if (stringTokenizer.countTokens() == 1) {
            return file;
        }
        String string2 = stringTokenizer.nextToken();
        File file2 = new File(file.getParentFile(), string2);
        if (!file2.exists()) {
            throw new RuntimeException("No such file: " + file2 + " for full file: " + file + " dataset: " + dataset.getName());
        }
        return file2;
    }

    public static final Dataset getBaseDataset(Dataset dataset) {
        File file = AuxUtils.getBaseDatasetSourceFile(dataset);
        return ParserFactory.readDataset(file, true);
    }

    public static final Dataset getBaseDatasetSafe(Dataset dataset) {
        File file = AuxUtils.getBaseDatasetSourceFile(dataset);
        try {
            return ParserFactory.readDataset(file, true);
        }
        catch (Throwable throwable) {
            System.out.println("Dataset na: " + dataset);
            return null;
        }
    }
}

