/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.AbstractParser$Comment;
import edu.mit.broad.genome.parsers.Parser;
import edu.mit.broad.genome.parsers.ParserException;
import edu.mit.broad.genome.utils.ClassUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class AbstractParser
implements Parser {
    protected final Logger log;
    protected static final Logger klog = XLogger.getLogger(AbstractParser.class);
    protected final AbstractParser$Comment fComment;
    private Class fRepClass;
    private String fRepClassName;
    private File _importFile;
    private Object _importObjName;
    private PrintWriter _exportPw;
    private boolean fSilentMode;

    protected AbstractParser(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter repClass cannot be null");
        }
        this.log = XLogger.getLogger(AbstractParser.class);
        this.fComment = new AbstractParser$Comment(this);
        this.fRepClass = clazz;
        this.fRepClassName = ClassUtils.shorten(this.fRepClass);
    }

    @Override
    public void export(PersistentObject persistentObject, OutputStream outputStream) {
        throw new NotImplementedException();
    }

    @Override
    public List parse(String string, File file) {
        this._importFile = file;
        this._importObjName = string;
        return this.parse(string, new FileInputStream(file));
    }

    @Override
    public Class getRepresentationClass() {
        return this.fRepClass;
    }

    @Override
    public void setSilentMode(boolean bl) {
        this.fSilentMode = bl;
    }

    protected final boolean isSilentMode() {
        return this.fSilentMode;
    }

    protected static final List unmodlist(PersistentObject persistentObject, List list) {
        ArrayList<PersistentObject> arrayList = new ArrayList<PersistentObject>(1 + list.size());
        arrayList.add(persistentObject);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            arrayList.add((PersistentObject)list.get(i2));
        }
        return Collections.unmodifiableList(arrayList);
    }

    protected static final List unmodlist(PersistentObject persistentObject) {
        ArrayList<PersistentObject> arrayList = new ArrayList<PersistentObject>(1);
        arrayList.add(persistentObject);
        return Collections.unmodifiableList(arrayList);
    }

    protected static final List unmodlist(PersistentObject[] persistentObjectArray) {
        ArrayList<PersistentObject> arrayList = new ArrayList<PersistentObject>(persistentObjectArray.length);
        for (int i2 = 0; i2 < persistentObjectArray.length; ++i2) {
            arrayList.add(persistentObjectArray[i2]);
        }
        return Collections.unmodifiableList(arrayList);
    }

    protected final String nextLine(BufferedReader bufferedReader) {
        return this.nextLine(bufferedReader, true);
    }

    protected final String nextLine(BufferedReader bufferedReader, boolean bl) {
        String string = bufferedReader.readLine();
        if (string == null) {
            return null;
        }
        string = string.trim();
        while (string != null && (string.length() == 0 || string.startsWith("#"))) {
            if (string.startsWith("#") && bl) {
                this.fComment.add(string);
            }
            if ((string = bufferedReader.readLine()) == null) continue;
            string = string.trim();
        }
        return string;
    }

    protected final String nextNonEmptyLine(BufferedReader bufferedReader) {
        String string = bufferedReader.readLine();
        if (string == null) {
            return null;
        }
        string = string.trim();
        while (string != null && string.length() == 0) {
            string = bufferedReader.readLine();
            if (string == null) continue;
            string = string.trim();
        }
        return string;
    }

    protected final String nextLineTrimless(BufferedReader bufferedReader) {
        String string = bufferedReader.readLine();
        if (string == null) {
            return null;
        }
        while (string != null && (string.length() == 0 || string.startsWith("#"))) {
            if (string.startsWith("#")) {
                this.fComment.add(string);
            }
            string = bufferedReader.readLine();
        }
        return string;
    }

    protected final boolean isNull(Object object) {
        if (object == null) {
            return true;
        }
        String string = object.toString();
        if ((string = string.trim()).length() == 0) {
            return true;
        }
        return "NULL".equalsIgnoreCase(string.trim());
    }

    protected final boolean isNa(String string) {
        return "na".equalsIgnoreCase(string.trim());
    }

    protected final boolean isNullorNa(String string) {
        if (this.isNull(string)) {
            return true;
        }
        return this.isNa(string);
    }

    protected final PrintWriter startExport(PersistentObject persistentObject, File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter file cannot be null");
        }
        return this.startExport(persistentObject, new FileOutputStream(file), file.getName());
    }

    protected final PrintWriter startExport(PersistentObject persistentObject, OutputStream outputStream, String string) {
        if (persistentObject == null) {
            throw new IllegalArgumentException("Parameter pob cannot be null");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("Parameter os cannot be null");
        }
        if (!this.fSilentMode) {
            this.log.debug("Exporting: " + persistentObject.getName() + " to: " + string + " " + persistentObject.getClass());
        }
        this._exportPw = new PrintWriter(outputStream);
        return this._exportPw;
    }

    protected final void doneExport() {
        if (this._exportPw != null) {
            this._exportPw.flush();
            this._exportPw.close();
        }
    }

    protected final void startImport(String string) {
        if (!this.fSilentMode) {
            this.log.info("Begun importing: " + this.fRepClassName + " from: " + string);
        }
    }

    protected final void doneImport() {
    }

    protected static final List string2stringsV2(String string, int n) {
        Object object;
        if (null == string) {
            throw new NullPointerException("Cannot work on null String");
        }
        String string2 = "\t";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (n2 == 0) {
                arrayList.add(((String)object).trim());
            } else if (((String)object).equals(string2)) {
                if (string3.equals(string2)) {
                    arrayList.add("");
                }
            } else {
                arrayList.add(((String)object).trim());
            }
            string3 = object;
            ++n2;
        }
        if (arrayList.size() == n) {
            return arrayList;
        }
        if (arrayList.size() < n) {
            for (int i2 = arrayList.size(); i2 < n; ++i2) {
                arrayList.add("");
            }
            return arrayList;
        }
        object = new ArrayList();
        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
            if (i3 < n) {
                object.add(arrayList.get(i3));
                continue;
            }
            Object e2 = arrayList.get(i3);
            if (e2 == null || e2.toString().trim().length() == 0) continue;
            object.add(e2);
        }
        return object;
    }

    protected static final File toFile(Element element, String string) {
        String string2 = AbstractParser.getReqdAttrValue(element, string);
        if (string2 == null) {
            throw new IllegalArgumentException("Element had no value for attribute_name: DATASET");
        }
        return new File(string2);
    }

    protected static final String getReqdAttrValue(Element element, String string) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter el cannot be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Parameter attrName cannot be null");
        }
        Attribute attribute = element.attribute(string);
        if (attribute == null) {
            throw new IllegalArgumentException("Element specified: " + element.getName() + " has no attribute called: " + string + "\nText: " + element.getText());
        }
        String string2 = attribute.getValue();
        if (string2 == null) {
            throw new IllegalArgumentException("Element had no value for attribute_name: DATASET");
        }
        return string2;
    }

    protected static final int indexOf(String string, List list, boolean bl) {
        int n = list.indexOf(string);
        if (n == -1 && bl) {
            throw new ParserException("Column not found: " + string);
        }
        return n;
    }
}

