/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects.strucs;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.gsea.MhtModes$VarMean;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.genome.objects.strucs.ProbeGeneSetScoreStruc;
import edu.mit.broad.genome.objects.strucs.ProbeNeighborhoodEsStruc$PreCalc;
import org.apache.log4j.Logger;

public class ProbeNeighborhoodEsStruc {
    private String fProbeName;
    private float[] fPreCalcRealNESS;
    private float[] fPreCalcNominalPValues;
    private float[] fPreCalcDiscPValues;
    private float[] fPreCalcValPValues;
    private float[] fPreCalcRealESS;
    private int fSize;
    private static Logger klog = XLogger.getLogger(ProbeNeighborhoodEsStruc.class);
    public ProbeGeneSetScoreStruc[] fGeneSetScoreStrucs;

    public ProbeNeighborhoodEsStruc(String string, float[] fArray, Vector[] vectorArray, GeneSet[] geneSetArray) {
        this.initCalc(string, fArray, vectorArray, geneSetArray);
    }

    public ProbeNeighborhoodEsStruc(String string, ProbeGeneSetScoreStruc[] probeGeneSetScoreStrucArray, GeneSet[] geneSetArray, boolean bl) {
        Object[] objectArray;
        Vector[] vectorArray = null;
        if (bl) {
            objectArray = probeGeneSetScoreStrucArray;
        } else {
            float[] fArray = new float[probeGeneSetScoreStrucArray.length];
            vectorArray = new Vector[probeGeneSetScoreStrucArray.length];
            for (int i2 = 0; i2 < probeGeneSetScoreStrucArray.length; ++i2) {
                fArray[i2] = probeGeneSetScoreStrucArray[i2].getES();
            }
            objectArray = fArray;
        }
        this.initCalc(string, objectArray, vectorArray, geneSetArray);
    }

    public ProbeNeighborhoodEsStruc(String string, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5) {
        this.init(string, fArray, fArray2, fArray3, fArray4, fArray5, null);
    }

    private void initCalc(String string, Object object, Vector[] vectorArray, GeneSet[] geneSetArray) {
        int n = geneSetArray.length;
        EnrichmentResult[] enrichmentResultArray = new EnrichmentResult[n];
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            float f2;
            if (!(object instanceof ProbeGeneSetScoreStruc[])) {
                f2 = ((float[])object)[i2];
                throw new NotImplementedException();
            }
            f2 = ((ProbeGeneSetScoreStruc[])object)[i2].getES();
            enrichmentResultArray[i2] = ((ProbeGeneSetScoreStruc[])object)[i2];
        }
        MhtModes$VarMean mhtModes$VarMean = new MhtModes$VarMean(enrichmentResultArray);
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        float[] fArray3 = new float[n];
        float[] fArray4 = new float[n];
        for (int i3 = 0; i3 < n; ++i3) {
            fArray[i3] = mhtModes$VarMean.getRealNES(i3);
            fArray3[i3] = mhtModes$VarMean.getDiscoveryPValue(i3);
            fArray4[i3] = mhtModes$VarMean.getValidationPValue(i3);
        }
        if (object instanceof ProbeGeneSetScoreStruc[]) {
            this.init(string, null, fArray, fArray2, fArray3, fArray4, (ProbeGeneSetScoreStruc[])object);
        } else {
            this.init(string, (float[])object, fArray, fArray2, fArray3, fArray4, null);
        }
    }

    private void init(String string, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, ProbeGeneSetScoreStruc[] probeGeneSetScoreStrucArray) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter probeName cannot be null");
        }
        int n = fArray2.length;
        if (fArray != null && fArray.length != n) {
            throw new MismatchedSizeException();
        }
        if (n != fArray2.length) {
            throw new MismatchedSizeException();
        }
        if (n != fArray3.length) {
            throw new MismatchedSizeException();
        }
        if (n != fArray4.length) {
            throw new MismatchedSizeException();
        }
        if (n != fArray5.length) {
            throw new MismatchedSizeException();
        }
        if (probeGeneSetScoreStrucArray != null && probeGeneSetScoreStrucArray.length != n) {
            throw new MismatchedSizeException();
        }
        this.fSize = fArray2.length;
        this.fProbeName = string;
        this.fPreCalcRealESS = fArray;
        this.fPreCalcRealNESS = fArray2;
        this.fPreCalcNominalPValues = fArray3;
        this.fPreCalcDiscPValues = fArray4;
        this.fPreCalcValPValues = fArray5;
        this.fGeneSetScoreStrucs = probeGeneSetScoreStrucArray;
    }

    public final String getProbeName() {
        return this.fProbeName;
    }

    public final float[] getRealEScores() {
        if (this.fPreCalcRealESS != null) {
            return this.fPreCalcRealESS;
        }
        if (this.fGeneSetScoreStrucs != null) {
            this.fPreCalcRealESS = new float[this.fGeneSetScoreStrucs.length];
            for (int i2 = 0; i2 < this.fGeneSetScoreStrucs.length; ++i2) {
                this.fPreCalcRealESS[i2] = this.fGeneSetScoreStrucs[i2].getES();
            }
            return this.fPreCalcRealESS;
        }
        throw new IllegalStateException("Prog error - both realess and gsscorestruc are null");
    }

    public final float[] getRealNEScores() {
        return this.fPreCalcRealNESS;
    }

    public final float[] getNominalPValues() {
        return this.fPreCalcNominalPValues;
    }

    public final float[] getDiscoveryPValues() {
        return this.fPreCalcDiscPValues;
    }

    public final float[] getValidationPValues() {
        return this.fPreCalcValPValues;
    }

    public final ProbeNeighborhoodEsStruc$PreCalc getPreCalc(int n) {
        float f2 = Float.NaN;
        if (this.fPreCalcRealESS != null) {
            f2 = this.fPreCalcRealESS[n];
        }
        return new ProbeNeighborhoodEsStruc$PreCalc(f2, this.fPreCalcRealNESS[n], this.fPreCalcNominalPValues[n], this.fPreCalcDiscPValues[n], this.fPreCalcValPValues[n]);
    }

    public final int getSize() {
        return this.fSize;
    }

    public final ProbeGeneSetScoreStruc getDeepInfo(int n) {
        if (this.fGeneSetScoreStrucs == null) {
            throw new IllegalStateException("This object is not in deep info mode");
        }
        return this.fGeneSetScoreStrucs[n];
    }
}

