/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects.strucs;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.strucs.FdrStruc;

public class DefaultFdrStruc
implements FdrStruc {
    private String name;
    private float nominalP;
    private float realScore;
    private float realScoreNorm;
    private float fdr;
    private int moreRealThan;
    private int moreRndThan;
    private float numr;
    private float denr;
    private int totRealCnt;
    private int totRndCnt;

    public static final DefaultFdrStruc create(String string, LabelledVector labelledVector, RankedList rankedList, Dataset dataset, Vector vector, Order order) {
        float f2 = labelledVector.getScore(string);
        Vector vector2 = dataset.getRow(string);
        float f3 = rankedList.getScore(string);
        int n = rankedList.getRank(string) + 1;
        return new DefaultFdrStruc(string, f2, f3, vector2, vector, n, rankedList.getSize(), order);
    }

    public static final DefaultFdrStruc create(String string, RankedList rankedList, Vector vector, Vector vector2, Order order) {
        float f2 = rankedList.getScore(string);
        int n = rankedList.getRank(string) + 1;
        return new DefaultFdrStruc(string, f2, f2, vector, vector2, n, rankedList.getSize(), order);
    }

    public DefaultFdrStruc(String string, float f2, float f3, Vector vector, Vector vector2, int n, int n2, Order order) {
        int n3;
        float f4;
        if (vector == null) {
            throw new IllegalArgumentException("Param rnd_scores_of_name_only cannot be null");
        }
        if (vector2 == null) {
            throw new IllegalArgumentException("Param all_rnd_scores_norm_sorted cannot be null");
        }
        if (vector.getSize() * n2 != vector2.getSize()) {
            throw new MismatchedSizeException("calc_all", vector.getSize() * n2, "all_rnd", vector2.getSize());
        }
        if (order == Order.DESCENDING) {
            f4 = (float)XMath.getPValue(f2, vector);
            n3 = XMath.getMoreThanCount(f3, vector2);
        } else if (order == Order.ASCENDING) {
            f4 = (float)XMath.getPValueLessThan(f2, vector);
            n3 = XMath.getLessThanCount(f3, vector2);
        } else {
            throw new IllegalArgumentException("Unsupported Order: " + order);
        }
        this.init(string, f2, f3, f4, n, n3, n2, vector2.getSize());
    }

    public DefaultFdrStruc(String string, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        this.init(string, f2, f3, f4, n, n2, n3, n4);
    }

    private void init(String string, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        this.name = string;
        this.realScore = f2;
        this.realScoreNorm = f3;
        this.nominalP = f4;
        this.moreRealThan = n;
        this.moreRndThan = n2;
        this.totRealCnt = n3;
        this.totRndCnt = n4;
        this.denr = (float)this.moreRealThan / (float)this.totRealCnt;
        this.numr = (float)this.moreRndThan / (float)this.totRndCnt;
        this.fdr = this.numr / this.denr;
        if (this.fdr > 1.0f) {
            this.fdr = 1.0f;
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final float getRealScore() {
        return this.realScore;
    }

    @Override
    public final float getRealNormalizedScore() {
        return this.realScoreNorm;
    }

    @Override
    public final int getMoreRndThanCnt() {
        return this.moreRndThan;
    }

    @Override
    public final int getMoreRealThanCnt() {
        return this.moreRealThan;
    }

    @Override
    public final float getNumr() {
        return this.numr;
    }

    @Override
    public final float getDenr() {
        return this.denr;
    }

    @Override
    public final float getFdr() {
        return this.fdr;
    }

    @Override
    public final int getTotalRealCnt() {
        return this.totRealCnt;
    }

    @Override
    public final int getTotalRndCnt() {
        return this.totRndCnt;
    }

    public final float getNominalPValue() {
        return this.nominalP;
    }

    @Override
    public final float getTotalRndSkew() {
        throw new NotImplementedException();
    }
}

