/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects.esmatrix.db;

import edu.mit.broad.genome.Errors;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.math.LabelledVectorProcessor;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.esmatrix.db.AbstractEnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.vdb.chip.Chip;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class EnrichmentDbImpl_one_shared_rl
extends AbstractEnrichmentDb {
    private EnrichmentResult[] fResults;
    private RankedList fRankedList_shared;
    private Template fTemplate_opt_shared;
    private Dataset fDataset_shared;
    private Chip fChip_shared;

    @Override
    public EnrichmentDb cloneShallow(Dataset dataset) {
        System.out.println(">>>>>>>>>>>>>>>>>>>>>>: cloneShallow: " + dataset.getQuickInfo());
        if (dataset == null) {
            throw new IllegalArgumentException("Param ds cannot be null");
        }
        Dataset dataset2 = this.getDataset();
        if (dataset2 != null) {
            this.log.warn("Overwriting dataset for edb old: " + dataset2.getQuickInfo() + " with: " + dataset.getQuickInfo());
        }
        this.fDataset_shared = dataset;
        return this;
    }

    public EnrichmentDbImpl_one_shared_rl(String string, RankedList rankedList, Dataset dataset, Template template, EnrichmentResult[] enrichmentResultArray, LabelledVectorProcessor labelledVectorProcessor, Metric metric, Map map, SortMode sortMode, Order order, int n, File file) {
        this.initHere(string, rankedList, dataset, template, enrichmentResultArray, labelledVectorProcessor, metric, map, sortMode, order, n, file);
    }

    public EnrichmentDbImpl_one_shared_rl(String string, EnrichmentResult[] enrichmentResultArray, Dataset dataset, LabelledVectorProcessor labelledVectorProcessor, Metric metric, Map map, SortMode sortMode, Order order, int n, File file) {
        this(string, EnrichmentDbImpl_one_shared_rl._rl_shared(enrichmentResultArray), dataset, EnrichmentDbImpl_one_shared_rl.template_shared(enrichmentResultArray), enrichmentResultArray, labelledVectorProcessor, metric, map, sortMode, order, n, file);
    }

    public EnrichmentDbImpl_one_shared_rl(String string, EnrichmentResult[] enrichmentResultArray, Dataset dataset, EnrichmentDb enrichmentDb) {
        this(string, EnrichmentDbImpl_one_shared_rl._rl_shared(enrichmentResultArray), dataset, EnrichmentDbImpl_one_shared_rl.template_shared(enrichmentResultArray), enrichmentResultArray, enrichmentDb.getRankedListProcessor(), enrichmentDb.getMetric(), enrichmentDb.getMetricParams(), enrichmentDb.getSortMode(), enrichmentDb.getOrder(), enrichmentDb.getNumPerm(), null);
    }

    public EnrichmentDbImpl_one_shared_rl(String string, EnrichmentResult[] enrichmentResultArray, Dataset dataset, EnrichmentDb enrichmentDb, RankedList rankedList) {
        this(string, rankedList, dataset, EnrichmentDbImpl_one_shared_rl.template_shared(enrichmentResultArray), enrichmentResultArray, enrichmentDb.getRankedListProcessor(), enrichmentDb.getMetric(), enrichmentDb.getMetricParams(), enrichmentDb.getSortMode(), enrichmentDb.getOrder(), enrichmentDb.getNumPerm(), null);
    }

    private void initHere(String string, RankedList rankedList, Dataset dataset, Template template, EnrichmentResult[] enrichmentResultArray, LabelledVectorProcessor labelledVectorProcessor, Metric metric, Map map, SortMode sortMode, Order order, int n, File file) {
        if (enrichmentResultArray == null) {
            throw new IllegalArgumentException("Param results cannot be null");
        }
        if (rankedList == null) {
            throw new IllegalArgumentException("Shared ranked list cannot be null");
        }
        this.fResults = enrichmentResultArray;
        this.fRankedList_shared = rankedList;
        this.fTemplate_opt_shared = template;
        this.fDataset_shared = dataset;
        if (this.fDataset_shared != null) {
            this.fChip_shared = this.fDataset_shared.getAnnot().getChip();
        }
        super.init(string, labelledVectorProcessor, metric, map, sortMode, order, n, file);
        super.initResultMaps();
    }

    @Override
    public EnrichmentDb cloneDeep(EnrichmentResult[] enrichmentResultArray) {
        return new EnrichmentDbImpl_one_shared_rl(this.getName(), this.getRankedList(), this.getDataset(), this.getTemplate(), enrichmentResultArray, this.getRankedListProcessor(), this.getMetric(), this.getMetricParams(), this.getSortMode(), this.getOrder(), this.getNumPerm(), this.getEdbDir());
    }

    @Override
    public Template getTemplate() {
        return this.fTemplate_opt_shared;
    }

    @Override
    public Dataset getDataset() {
        return this.fDataset_shared;
    }

    @Override
    public Chip getChip() {
        return this.fChip_shared;
    }

    @Override
    public RankedList getRankedList() {
        return this.fRankedList_shared;
    }

    @Override
    public EnrichmentResult[] getResults() {
        return this.fResults;
    }

    @Override
    public List getResultsList() {
        return Arrays.asList(this.fResults);
    }

    private static RankedList _rl_shared(EnrichmentResult[] enrichmentResultArray) {
        Errors errors = new Errors();
        String string = enrichmentResultArray[0].getRankedList().getName();
        int n = enrichmentResultArray[0].getRankedList().getSize();
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            String string2 = enrichmentResultArray[i2].getRankedList().getName();
            int n2 = enrichmentResultArray[i2].getRankedList().getSize();
            if (!string2.equals(string)) {
                errors.add("Mismatched rl theName: " + string + " name: " + string2 + " at r: " + i2 + " # rls: " + enrichmentResultArray.length);
            }
            if (n2 == n) continue;
            errors.add("Mismatched rl theName: " + string + " name: " + string2 + " at r: " + i2 + " # rls: " + enrichmentResultArray.length);
        }
        errors.barfIfNotEmptyRuntime();
        return enrichmentResultArray[0].getRankedList();
    }

    private static Template template_shared(EnrichmentResult[] enrichmentResultArray) {
        Errors errors = new Errors();
        if (enrichmentResultArray[0].getTemplate() == null) {
            return null;
        }
        String string = enrichmentResultArray[0].getTemplate().getName();
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            String string2 = enrichmentResultArray[i2].getTemplate().getName();
            if (string2.equals(string)) continue;
            errors.add("Mismatched template theName: " + string + " name: " + string2 + " at r: " + i2 + " # results: " + enrichmentResultArray.length);
        }
        errors.barfIfNotEmptyRuntime();
        return enrichmentResultArray[0].getTemplate();
    }
}

