/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects.esmatrix.db;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.gsea.EdbAlgs;
import edu.mit.broad.genome.math.LabelledVectorProcessor;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.IDataframe;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.genome.objects.strucs.FdrStruc;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public abstract class AbstractEnrichmentDb
extends AbstractObject
implements EnrichmentDb {
    private LabelledVectorProcessor fLvp;
    private Metric fMetric;
    private Map fMetricParams;
    private SortMode fSortMode;
    private Order fOrder;
    private int fNumPerms;
    private File fEdbDir_opt;
    private Map fGeneSetNameResultMap;
    private FdrStruc[] fFdrPos;
    private FdrStruc[] fFdrNeg;

    protected AbstractEnrichmentDb() {
    }

    @Override
    public EnrichmentDb cloneShallow(String string) {
        super.setName(string);
        return this;
    }

    public final void init(String string, LabelledVectorProcessor labelledVectorProcessor, Metric metric, Map map, SortMode sortMode, Order order, int n, File file) {
        if (labelledVectorProcessor == null) {
            throw new IllegalArgumentException("Param lvp cannot be null");
        }
        if (metric == null) {
            throw new IllegalArgumentException("Param metric cannot be null");
        }
        if (sortMode == null) {
            throw new IllegalArgumentException("Param sort cannot be null");
        }
        if (order == null) {
            throw new IllegalArgumentException("Param order cannot be null");
        }
        super.initialize(string);
        this.fLvp = labelledVectorProcessor;
        this.fMetric = metric;
        this.fMetricParams = map;
        this.fSortMode = sortMode;
        this.fOrder = order;
        this.fNumPerms = n;
        this.fEdbDir_opt = file;
        this.initResultMaps();
    }

    @Override
    public File getEdbDir() {
        return this.fEdbDir_opt;
    }

    protected final void initResultMaps() {
        if (this.fGeneSetNameResultMap == null) {
            this.fGeneSetNameResultMap = EdbAlgs.hashByGeneSetName(this.getResults());
        }
    }

    @Override
    public int getNumScores(boolean bl) {
        int n = 0;
        for (int i2 = 0; i2 < this.getNumResults(); ++i2) {
            if (bl) {
                if (!XMath.isPositive(this.getResult(i2).getScore().getES())) continue;
                ++n;
                continue;
            }
            if (!XMath.isNegative(this.getResult(i2).getScore().getES())) continue;
            ++n;
        }
        return n;
    }

    @Override
    public EnrichmentResult[] getResults(float f2, float f3, Comparator comparator) {
        ArrayList<EnrichmentResult> arrayList = new ArrayList<EnrichmentResult>();
        for (int i2 = 0; i2 < this.getNumResults(); ++i2) {
            EnrichmentResult enrichmentResult = this.getResult(i2);
            if (!(enrichmentResult.getScore().getNP() <= f2) || !(enrichmentResult.getScore().getFDR() <= f3)) continue;
            arrayList.add(enrichmentResult);
        }
        Collections.sort(arrayList, comparator);
        return arrayList.toArray(new EnrichmentResult[arrayList.size()]);
    }

    @Override
    public int getNumNominallySig(float f2, boolean bl) {
        int n = 0;
        for (int i2 = 0; i2 < this.getNumResults(); ++i2) {
            EnrichmentResult enrichmentResult = this.getResult(i2);
            if (enrichmentResult.getScore().getES() > 0.0f && bl && enrichmentResult.getScore().getNP() <= f2) {
                ++n;
            }
            if (!(enrichmentResult.getScore().getES() < 0.0f) || bl || !(enrichmentResult.getScore().getNP() <= f2)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getNumFDRSig(float f2, boolean bl) {
        return this.getFDRSig(f2, bl).length;
    }

    @Override
    public FdrStruc[] getFDRSig(float f2, boolean bl) {
        FdrStruc[] fdrStrucArray = this.getFDR(bl);
        ArrayList<FdrStruc> arrayList = new ArrayList<FdrStruc>();
        for (int i2 = 0; i2 < fdrStrucArray.length; ++i2) {
            if (!(fdrStrucArray[i2].getFdr() <= f2)) continue;
            arrayList.add(fdrStrucArray[i2]);
        }
        return arrayList.toArray(new FdrStruc[arrayList.size()]);
    }

    private void initFDR() {
        if (this.fFdrPos != null) {
            return;
        }
        ArrayList<FdrStruc> arrayList = new ArrayList<FdrStruc>();
        ArrayList<FdrStruc> arrayList2 = new ArrayList<FdrStruc>();
        for (int i2 = 0; i2 < this.getNumResults(); ++i2) {
            FdrStruc fdrStruc = this.getResult(i2).getFDR();
            if (fdrStruc == null) continue;
            if (XMath.isPositive(fdrStruc.getRealScore())) {
                arrayList.add(fdrStruc);
                continue;
            }
            arrayList2.add(fdrStruc);
        }
        this.fFdrPos = arrayList.toArray(new FdrStruc[arrayList.size()]);
        this.fFdrNeg = arrayList2.toArray(new FdrStruc[arrayList2.size()]);
    }

    @Override
    public FdrStruc[] getFDR_all() {
        int n;
        this.initFDR();
        ArrayList<FdrStruc> arrayList = new ArrayList<FdrStruc>();
        for (n = 0; n < this.fFdrPos.length; ++n) {
            arrayList.add(this.fFdrPos[n]);
        }
        for (n = 0; n < this.fFdrNeg.length; ++n) {
            arrayList.add(this.fFdrNeg[n]);
        }
        return arrayList.toArray(new FdrStruc[arrayList.size()]);
    }

    @Override
    public FdrStruc[] getFDR(boolean bl) {
        this.initFDR();
        if (bl && this.fFdrPos == null) {
            throw new IllegalStateException("Fdrs not yet calculated: " + bl);
        }
        if (!bl && this.fFdrNeg == null) {
            throw new IllegalStateException("Fdrs not yet calculated: " + bl);
        }
        if (bl) {
            return this.fFdrPos;
        }
        return this.fFdrNeg;
    }

    @Override
    public boolean containsGeneSet(String string) {
        return this.fGeneSetNameResultMap.containsKey(string);
    }

    @Override
    public EnrichmentResult getResultForGeneSet(String string) {
        Object v = this.fGeneSetNameResultMap.get(string);
        if (v == null) {
            throw new IllegalArgumentException("No such gset result: " + string);
        }
        return (EnrichmentResult)v;
    }

    @Override
    public String getQuickInfo() {
        return null;
    }

    public final IDataframe getDataframe() {
        throw new NotImplementedException();
    }

    @Override
    public GeneSet[] getGeneSets() {
        return EdbAlgs.getGeneSets(this.getResults());
    }

    @Override
    public List getGeneSetNames() {
        return EdbAlgs.getGeneSetNames(this.getResults());
    }

    @Override
    public String[] getGeneSetNamesArray() {
        List list = this.getGeneSetNames();
        return list.toArray(new String[list.size()]);
    }

    @Override
    public GeneSet[] getGeneSetSignals() {
        return EdbAlgs.getGeneSetSignals(this.getResults());
    }

    @Override
    public GeneSet[] getGeneSets(float f2, float f3, Comparator comparator) {
        return EdbAlgs.getGeneSets(this.getResults(f2, f3, comparator));
    }

    @Override
    public GeneSet[] getGeneSetSignals(float f2, float f3, Comparator comparator) {
        return EdbAlgs.getGeneSetSignals(this.getResults(f2, f3, comparator));
    }

    @Override
    public EnrichmentResult[] getResults(Comparator comparator) {
        List list = this.getResultsList(comparator);
        return list.toArray(new EnrichmentResult[list.size()]);
    }

    @Override
    public EnrichmentResult getResult(int n) {
        return this.getResults()[n];
    }

    @Override
    public List getResultsList(Comparator comparator) {
        List list = this.getResultsList();
        Collections.sort(list, comparator);
        return list;
    }

    @Override
    public EnrichmentResult[] getResults(Comparator comparator, boolean bl) {
        EnrichmentResult[] enrichmentResultArray = this.getResults(comparator);
        ArrayList<EnrichmentResult> arrayList = new ArrayList<EnrichmentResult>();
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            float f2 = enrichmentResultArray[i2].getScore().getES();
            if (bl && XMath.isPositive(f2)) {
                arrayList.add(enrichmentResultArray[i2]);
            }
            if (bl || !XMath.isNegative(f2)) continue;
            arrayList.add(enrichmentResultArray[i2]);
        }
        return arrayList.toArray(new EnrichmentResult[arrayList.size()]);
    }

    @Override
    public int getNumResults() {
        return this.getResults().length;
    }

    @Override
    public LabelledVectorProcessor getRankedListProcessor() {
        return this.fLvp;
    }

    @Override
    public Metric getMetric() {
        return this.fMetric;
    }

    @Override
    public Map getMetricParams() {
        return this.fMetricParams;
    }

    @Override
    public SortMode getSortMode() {
        return this.fSortMode;
    }

    @Override
    public Order getOrder() {
        return this.fOrder;
    }

    @Override
    public int getNumPerm() {
        return this.fNumPerms;
    }

    @Override
    public Vector getESS() {
        Vector vector = new Vector(this.getNumResults());
        for (int i2 = 0; i2 < this.getNumResults(); ++i2) {
            vector.setElement(i2, this.getResult(i2).getScore().getES());
        }
        return vector;
    }

    @Override
    public LabelledVector getESS_lv() {
        return new LabelledVector(this.getName() + "_ess", this.getGeneSetNamesArray(), this.getESS());
    }

    @Override
    public Vector getNESS() {
        Vector vector = new Vector(this.getNumResults());
        for (int i2 = 0; i2 < this.getNumResults(); ++i2) {
            vector.setElement(i2, this.getResult(i2).getScore().getNES());
        }
        return vector;
    }

    @Override
    public LabelledVector getNESS_lv() {
        return new LabelledVector(this.getName() + "_ness", this.getGeneSetNamesArray(), this.getNESS());
    }

    @Override
    public RankedList getNESS_rl() {
        return new LabelledVector(this.getName() + "_ness", this.getGeneSetNamesArray(), this.getNESS()).sort(SortMode.REAL, Order.DESCENDING);
    }

    @Override
    public Vector getNPs() {
        Vector vector = new Vector(this.getNumResults());
        for (int i2 = 0; i2 < this.getNumResults(); ++i2) {
            vector.setElement(i2, this.getResult(i2).getScore().getNP());
        }
        return vector;
    }

    @Override
    public LabelledVector getNPs_lv() {
        return new LabelledVector(this.getName() + "_np", this.getGeneSetNamesArray(), this.getNPs());
    }

    @Override
    public Vector getFDRs() {
        Vector vector = new Vector(this.getNumResults());
        for (int i2 = 0; i2 < this.getNumResults(); ++i2) {
            vector.setElement(i2, this.getResult(i2).getScore().getFDR());
        }
        return vector;
    }

    @Override
    public LabelledVector getFDRs_lv() {
        return new LabelledVector(this.getName() + "_fdr", this.getGeneSetNamesArray(), this.getFDRs());
    }

    @Override
    public Vector getFWERs() {
        Vector vector = new Vector(this.getNumResults());
        for (int i2 = 0; i2 < this.getNumResults(); ++i2) {
            vector.setElement(i2, this.getResult(i2).getScore().getFWER());
        }
        return vector;
    }

    @Override
    public LabelledVector getFWERs_lv() {
        return new LabelledVector(this.getName() + "_fwer", this.getGeneSetNamesArray(), this.getFWERs());
    }

    @Override
    public boolean isCompatible(EnrichmentDb enrichmentDb) {
        throw new NotImplementedException();
    }

    @Override
    public void checkCompatibility(EnrichmentDb enrichmentDb) {
        throw new NotImplementedException();
    }
}

