/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.objects.AbstractTemplate;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.Template$Class;
import edu.mit.broad.genome.objects.Template$Item;
import edu.mit.broad.genome.objects.TemplateImpl$ClassImpl;
import edu.mit.broad.genome.utils.ColorUtils;
import edu.mit.broad.genome.utils.ImmutedException;
import edu.mit.broad.genome.utils.Strings;
import gnu.trove.TIntObjectHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;

public class TemplateImpl
extends AbstractTemplate {
    private ArrayList fClasses;
    private ArrayList fItems;
    private boolean fContinuous;
    private boolean fImmutable = false;
    private int fCoi = 0;
    private boolean fAux;
    static boolean warned = false;
    private boolean checked;
    private boolean fSampleNamesFromDataset;
    private static final Color DEFAULT_CLASS0_COLOR = Color.LIGHT_GRAY;
    private static final Color DEFAULT_CLASS1_COLOR = Color.ORANGE;
    private static final Color[] DEFAULT_COLORS = new Color[]{DEFAULT_CLASS0_COLOR, DEFAULT_CLASS1_COLOR, Color.YELLOW, Color.MAGENTA, Color.GREEN, Color.CYAN, Color.PINK};
    private TIntObjectHashMap fItemProfilePosColorScheme;

    protected TemplateImpl(String string) {
        super(string);
        this.fClasses = new ArrayList();
        this.fItems = new ArrayList();
    }

    protected TemplateImpl() {
    }

    protected TemplateImpl(TemplateImpl templateImpl) {
        this.fClasses = templateImpl.fClasses;
        this.fItems = templateImpl.fItems;
        this.fContinuous = templateImpl.fContinuous;
        this.fImmutable = templateImpl.fImmutable;
        this.fCoi = templateImpl.fCoi;
        this.fItemProfilePosColorScheme = templateImpl.fItemProfilePosColorScheme;
    }

    @Override
    protected final Template$Item _getItemAsIs(int n) {
        return (Template$Item)this.fItems.get(n);
    }

    @Override
    protected final Template$Item[] _getItems() {
        return this.fItems.toArray(new Template$Item[this.fItems.size()]);
    }

    @Override
    public String getClassName(int n) {
        return ((Template$Class)this.fClasses.get(n)).getName();
    }

    @Override
    public Template cloneDeep() {
        return this.cloneDeep(this.getName());
    }

    @Override
    public Template cloneDeep(String string) {
        TemplateImpl templateImpl = new TemplateImpl(string);
        templateImpl.fImmutable = false;
        templateImpl.fContinuous = this.fContinuous;
        for (int i2 = 0; i2 < this.getNumClasses(); ++i2) {
            Template$Class template$Class = this.getClass(i2);
            TemplateImpl$ClassImpl templateImpl$ClassImpl = new TemplateImpl$ClassImpl(template$Class.getName());
            templateImpl.add(templateImpl$ClassImpl);
            for (int i3 = 0; i3 < template$Class.getSize(); ++i3) {
                Template$Item template$Item = template$Class.getItem(i3).cloneDeep();
                templateImpl$ClassImpl.add(template$Item);
                templateImpl.add(template$Item);
            }
        }
        templateImpl.fCoi = this.fCoi;
        return templateImpl;
    }

    @Override
    public int getClassOfInterestIndex() {
        return this.fCoi;
    }

    @Override
    public boolean isContinuous() {
        return this.fContinuous;
    }

    @Override
    public boolean isCategorical() {
        return !this.fContinuous;
    }

    @Override
    public Template$Class getClass(int n) {
        return (Template$Class)this.fClasses.get(n);
    }

    @Override
    public boolean isMemberClass(Template$Class template$Class) {
        int n = this.fClasses.indexOf(template$Class);
        return n != -1;
    }

    @Override
    public int getClassIndex(Template$Class template$Class) {
        return this.fClasses.indexOf(template$Class);
    }

    @Override
    public int getNumItems() {
        return this.fItems.size();
    }

    @Override
    public int getNumClasses() {
        return this.fClasses.size();
    }

    protected final void setAux(boolean bl) {
        if (bl) {
            if (!Strings.contains(this.getName(), "#")) {
                throw new IllegalStateException("Cannot make aux as the name has no # in it. Name: " + this.getName());
            }
        } else if (Strings.contains(this.getName(), "#")) {
            throw new IllegalStateException("Non-aux template cannot have # in its name. Name: " + this.getName());
        }
        this.fAux = bl;
    }

    @Override
    public boolean isAux() {
        if (this.getName().indexOf(35) != -1) {
            return true;
        }
        return this.fAux;
    }

    @Override
    public void setClassOfInterestIndex(int n) {
        this.checkImmutable();
        this.fCoi = n;
    }

    @Override
    public String getClassOfInterestName() {
        return this.getClass(this.fCoi).getName();
    }

    @Override
    public Template$Class getClassOfInterest() {
        return this.getClass(this.fCoi);
    }

    protected final void add(Template$Class template$Class) {
        if (template$Class == null) {
            throw new IllegalArgumentException("Param cl cannot be null");
        }
        this.checkImmutable();
        for (int i2 = 0; i2 < this.getNumClasses(); ++i2) {
            if (!this.getClass(i2).getName().equals(template$Class.getName())) continue;
            throw new IllegalArgumentException("Class with this name already exists: " + template$Class.getName() + " . The Classes in a Template must be unique");
        }
        this.fClasses.add(template$Class);
    }

    protected final void add(Template$Item template$Item) {
        if (template$Item == null) {
            throw new IllegalArgumentException("Param aItem cannot be null");
        }
        this.checkImmutable();
        if (this.isContinuous()) {
            try {
                Float.parseFloat(template$Item.getId());
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException("Template is numeric but Template.Item asked to be added was not Float-parsable " + numberFormatException.toString());
            }
        }
        this.fItems.add(template$Item);
    }

    protected final void runChecks() {
        if (!this.checked) {
            this.runChecksInit();
            this.runChecksPost();
            this.checked = true;
        }
    }

    protected final ArrayList runChecksInit() {
        int n;
        Template$Item[] template$ItemArray;
        if (this.fClasses == null) {
            throw new RuntimeException("Cannot call method as Template has no associated Template.Class's");
        }
        if (this.fItems == null) {
            throw new RuntimeException("Cannot call method as Template has no associated Template.Items's");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.getNumItems());
        for (int i2 = 0; i2 < this.getNumItems(); ++i2) {
            template$ItemArray = (Template$Item[])this.fItems.get(i2);
            Integer n2 = new Integer(template$ItemArray.getProfilePosition());
            if (arrayList.contains(n2)) {
                throw new RuntimeException("ProfilePosition has been reused! Position = " + n2 + " by Item: " + Printf.outs((Template$Item)template$ItemArray));
            }
            arrayList.add(n2);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        template$ItemArray = this.getItemsOrderedByProfilePos();
        for (n = 0; n < template$ItemArray.length; ++n) {
            if (arrayList2.contains(template$ItemArray[n].getId())) continue;
            arrayList2.add(template$ItemArray[n].getId());
        }
        if (!this.isContinuous() && arrayList2.size() != this.fClasses.size()) {
            StringBuffer stringBuffer = new StringBuffer("Mismatched numbers between unique item id's: ").append(arrayList2.size());
            stringBuffer.append(' ').append(arrayList2).append(" and number of Template.Class's: ").append(this.fClasses.size()).append('\n');
            for (int i3 = 0; i3 < this.fClasses.size(); ++i3) {
                stringBuffer.append(((Template$Class)this.fClasses.get(i3)).getName()).append(' ');
            }
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        for (n = 0; n < this.fClasses.size(); ++n) {
        }
        return arrayList2;
    }

    protected final void runChecksPost() {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < this.fClasses.size(); ++i2) {
            Template$Class template$Class = (Template$Class)this.fClasses.get(i2);
            if (hashSet.contains(template$Class.getName())) {
                throw new IllegalArgumentException("Duplicate class names: " + template$Class.getName() + "\n" + hashSet);
            }
            hashSet.add(template$Class.getName());
            if (template$Class.getSize() == 0) {
                throw new IllegalStateException("Empty class: " + template$Class.getName() + " " + template$Class.getSize() + " total # items: " + this.getNumItems());
            }
            Template$Item template$Item = template$Class.getItem(0);
            for (int i3 = 0; i3 < this.fClasses.size(); ++i3) {
                Template$Class template$Class2 = (Template$Class)this.fClasses.get(i3);
                if (!template$Class2.getName().equals(template$Item.getId()) || i3 == i2) continue;
                throw new IllegalStateException("Something obviously wrong items and classes mismatched: \n" + Printf.outs(this));
            }
        }
    }

    protected final void assignItems2ClassInOrder() {
        int n;
        for (int i2 = 0; i2 < this.fClasses.size(); ++i2) {
            if (this.getClass(i2).getSize() == 0) continue;
            throw new RuntimeException("Items already seem to be assigned to class: " + this.getClass(i2).getName());
        }
        ArrayList arrayList = this.runChecksInit();
        Hashtable hashtable = new Hashtable();
        for (n = 0; n < arrayList.size(); ++n) {
            hashtable.put(arrayList.get(n), this.fClasses.get(n));
        }
        for (n = 0; n < this.getNumItems(); ++n) {
            Template$Item template$Item = (Template$Item)this.fItems.get(n);
            TemplateImpl$ClassImpl templateImpl$ClassImpl = (TemplateImpl$ClassImpl)hashtable.get(template$Item.getId());
            templateImpl$ClassImpl.add(template$Item);
        }
        this.runChecksPost();
    }

    protected final void setContinuous(boolean bl) {
        this.checkImmutable();
        this.fContinuous = bl;
        if (bl) {
            if (this.getNumItems() != this.getNumClasses()) {
                throw new IllegalStateException("Cannot make template continuous. # items: " + this.getNumItems() + " is not equal to # classes: " + this.getNumClasses());
            }
            Template$Item template$Item = null;
            try {
                for (int i2 = 0; i2 < this.getNumItems(); ++i2) {
                    template$Item = this._getItemAsIs(i2);
                    template$Item.floatValue();
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException("Item: " + template$Item.getId() + " at pos: " + template$Item.getProfilePosition() + " is not numeric. The Template cannot be set as continuous");
            }
        }
    }

    protected final void setSampleNamesFromDataset(boolean bl) {
        this.fSampleNamesFromDataset = bl;
    }

    @Override
    public boolean isSampleNamesFromDataset() {
        return this.fSampleNamesFromDataset;
    }

    @Override
    public void makeImmutable() {
        this.fImmutable = true;
        this.runChecks();
    }

    protected final boolean isImmutable() {
        return this.fImmutable;
    }

    private void checkImmutable() {
        if (this.fImmutable) {
            throw new ImmutedException();
        }
    }

    @Override
    public Color getItemColor(int n) {
        Object object;
        if (this.fItemProfilePosColorScheme == null) {
            this.makeAutoColors();
        }
        if ((object = this.fItemProfilePosColorScheme.get(n)) == null) {
            this.log.warn("No color for item at profile pos: " + n + " existing pos-color scheme size: " + Printf.outs(this.fItemProfilePosColorScheme));
            return Color.WHITE;
        }
        return (Color)object;
    }

    private void makeAutoColors() {
        this.fItemProfilePosColorScheme = new TIntObjectHashMap();
        if (this.getNumClasses() == 1 || this.isContinuous()) {
            for (int i2 = 0; i2 < this.getNumItems(); ++i2) {
                this.fItemProfilePosColorScheme.put(this._getItemAsIs(i2).getProfilePosition(), Color.WHITE);
            }
        } else if (this.getNumClasses() == 2) {
            Template$Class template$Class = this.getClass(0);
            for (int i3 = 0; i3 < template$Class.getSize(); ++i3) {
                this.fItemProfilePosColorScheme.put(template$Class.getItem(i3).getProfilePosition(), DEFAULT_CLASS0_COLOR);
            }
            Template$Class template$Class2 = this.getClass(1);
            for (int i4 = 0; i4 < template$Class2.getSize(); ++i4) {
                this.fItemProfilePosColorScheme.put(template$Class2.getItem(i4).getProfilePosition(), DEFAULT_CLASS1_COLOR);
            }
        } else {
            Color[] colorArray = ColorUtils.generate(this.getNumClasses(), DEFAULT_COLORS);
            for (int i5 = 0; i5 < this.getNumClasses(); ++i5) {
                Template$Class template$Class = this.getClass(i5);
                for (int i6 = 0; i6 < template$Class.getSize(); ++i6) {
                    this.fItemProfilePosColorScheme.put(template$Class.getItem(i6).getProfilePosition(), colorArray[i5]);
                }
            }
        }
    }
}

