/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.math.AddressedVector;
import edu.mit.broad.genome.math.DoubleElement;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.math.XMath$Const;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetPair;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.MetricWeightStruc;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.RankedList$Helper;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.strucs.DefaultMetricWeightStruc;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class ScoredDatasetImpl
extends AbstractObject
implements ScoredDataset {
    private Dataset fDataset;
    private AddressedVector fIndVector;
    private List fRowNamesInSdsOrder;
    private GeneSet fRowNamesGeneSet;
    private TObjectIntHashMap fRowNameSdsRowIndexMap;
    private MetricWeightStruc ws;

    @Override
    public final Dataset cloneShallow(String string) {
        super.setName(string);
        return this;
    }

    public ScoredDatasetImpl(String string, int n, AddressedVector addressedVector, Dataset dataset) {
        this.init(string, n, addressedVector, dataset);
    }

    public ScoredDatasetImpl(int n, AddressedVector addressedVector, Dataset dataset) {
        this(dataset.getName(), n, addressedVector, dataset);
    }

    public ScoredDatasetImpl(RankedList rankedList, Dataset dataset) {
        this(dataset.getName(), new AddressedVector(rankedList, dataset), dataset);
    }

    public ScoredDatasetImpl(AddressedVector addressedVector, Dataset dataset) {
        this(addressedVector.getSize(), addressedVector, dataset);
    }

    public ScoredDatasetImpl(String string, AddressedVector addressedVector, Dataset dataset) {
        this(string, addressedVector.getSize(), addressedVector, dataset);
    }

    @Override
    public final RankedList cloneShallowRL(String string) {
        super.setName(string);
        return this;
    }

    public final ScoredDataset cloneShallowCutoff(double d2) {
        ArrayList<DoubleElement> arrayList = new ArrayList<DoubleElement>();
        for (int i2 = 0; i2 < this.getNumRow(); ++i2) {
            float f2 = this.getScore(i2);
            if (!((double)f2 >= d2)) continue;
            arrayList.add(new DoubleElement(i2, f2));
        }
        AddressedVector addressedVector = new AddressedVector(arrayList);
        return new ScoredDatasetImpl(addressedVector, this.fDataset);
    }

    public final ScoredDataset cloneShallowReversedScore() {
        String string = this.getName() + "reversedscores";
        Vector vector = new Vector(this.fIndVector.getSize());
        int[] nArray = new int[this.fIndVector.getSize()];
        int n = this.getNumRow() - 1;
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            vector.setElement(i2, this.fIndVector.getScore(i2) * -1.0f);
            nArray[i2] = n - this.fIndVector.getAddress(i2);
        }
        AddressedVector addressedVector = new AddressedVector(vector, nArray, true);
        return new ScoredDatasetImpl(string, addressedVector, this.fDataset);
    }

    private void init(String string, int n, AddressedVector addressedVector, Dataset dataset) {
        if (addressedVector == null) {
            throw new NullPointerException("Param AddressedVector cannot be null");
        }
        if (dataset == null) {
            throw new NullPointerException("Param Dataset cannot be null");
        }
        super.initialize(string);
        if (n < 0) {
            throw new IllegalArgumentException("# features: " + n + " cannot be less than sero");
        }
        if (n > addressedVector.getSize()) {
            throw new IllegalArgumentException("# features: " + n + " cannot be > than number of sorted elements: " + addressedVector.getSize());
        }
        if (addressedVector.getSize() > dataset.getNumRow()) {
            throw new IllegalArgumentException("# sorted elements: " + addressedVector.getSize() + " cannot be > Dataset length: " + dataset.getNumRow());
        }
        this.fDataset = dataset;
        this.fIndVector = new AddressedVector(n, addressedVector);
        this.fRowNamesInSdsOrder = new ArrayList(n);
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = this.sdsrown2posinds(i2);
            this.fRowNamesInSdsOrder.add(dataset.getRowName(n2));
        }
        this.fRowNamesInSdsOrder = Collections.unmodifiableList(this.fRowNamesInSdsOrder);
    }

    @Override
    public final Annot getAnnot() {
        return this.fDataset.getAnnot();
    }

    @Override
    public final Vector getRow(int n) {
        return this.fDataset.getRow(this.sdsrown2posinds(n));
    }

    @Override
    public final Vector getRow(String string) {
        return this.fDataset.getRow(string);
    }

    @Override
    public final Vector[] getRows(GeneSet geneSet) {
        return this.fDataset.getRows(geneSet);
    }

    @Override
    public final Vector getColumn(String string) {
        throw new NotImplementedException();
    }

    @Override
    public final int[] getColumnIndices(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            nArray[i2] = this.getColumnIndex(stringArray[i2]);
        }
        return nArray;
    }

    @Override
    public final Vector[] getColumns(String[] stringArray) {
        throw new NotImplementedException();
    }

    @Override
    public final Vector getColumn(int n) {
        throw new NotImplementedException();
    }

    @Override
    public final LabelledVector getColumnLV(String string) {
        throw new NotImplementedException();
    }

    @Override
    public final LabelledVector getColumnLV(int n) {
        throw new NotImplementedException();
    }

    @Override
    public final RankedList getColumnRL(String string, SortMode sortMode, Order order) {
        throw new NotImplementedException();
    }

    @Override
    public final RankedList getColumnRL(int n, SortMode sortMode, Order order) {
        throw new NotImplementedException();
    }

    @Override
    public final Vector getColumn(int n, GeneSet geneSet) {
        return this.fDataset.getColumn(n, geneSet);
    }

    @Override
    public final Vector getColumn(String string, GeneSet geneSet) {
        return this.fDataset.getColumn(string, geneSet);
    }

    @Override
    public final float getElement(int n, int n2) {
        return this.fDataset.getElement(this.sdsrown2posinds(n), n2);
    }

    @Override
    public final float getElement(int n, String string) {
        return this.getElement(n, this.getColumnIndex(string));
    }

    @Override
    public final float getElement(String string, int n) {
        return this.getElement(this.getRowIndex(string), n);
    }

    @Override
    public final float getElement(String string, String string2) {
        return this.getElement(this.getRowIndex(string), this.getColumnIndex(string2));
    }

    @Override
    public final String getRowName(int n) {
        return (String)this.fRowNamesInSdsOrder.get(n);
    }

    public final String getRowSortName(int n) {
        return "Sorted Rank: " + n + " PosInDs: " + this.sdsrown2posinds(n);
    }

    @Override
    public final List getRankedNames() {
        return Collections.unmodifiableList(this.fRowNamesInSdsOrder);
    }

    @Override
    public final List getRowNames() {
        return this.getRankedNames();
    }

    @Override
    public final GeneSet getRowNamesGeneSet() {
        if (this.fRowNamesGeneSet == null) {
            this.fRowNamesGeneSet = new FSet(this.getName(), new HashSet(this.getRankedNames()));
        }
        return this.fRowNamesGeneSet;
    }

    public final GeneSet createOrderedGeneSet() {
        return new FSet(this.getName() + "_orderedgeneset", this.getNameEnglish(), Collections.unmodifiableList(this.fRowNamesInSdsOrder), true);
    }

    @Override
    public final int getRowIndex(String string) {
        int n;
        if (this.fRowNameSdsRowIndexMap == null) {
            this.cacheRowNameIndex();
        }
        if ((n = this.fRowNameSdsRowIndexMap.get(string)) == 0) {
            if (!this.fRowNameSdsRowIndexMap.containsKey(string)) {
                return -1;
            }
            return 0;
        }
        return n;
    }

    private void cacheRowNameIndex() {
        if (this.fRowNameSdsRowIndexMap == null) {
            this.fRowNameSdsRowIndexMap = new TObjectIntHashMap();
            for (int i2 = 0; i2 < this.getNumRow(); ++i2) {
                this.fRowNameSdsRowIndexMap.put(this.getRowName(i2), i2);
            }
        }
    }

    @Override
    public final String[] getRankedNamesArray() {
        return this.fRowNamesInSdsOrder.toArray(new String[this.fRowNamesInSdsOrder.size()]);
    }

    @Override
    public final String[] getRowNamesArray() {
        return this.getRankedNamesArray();
    }

    @Override
    public final List getColumnNames() {
        return this.fDataset.getColumnNames();
    }

    @Override
    public final List getColumnNames(Template template) {
        return this.fDataset.getColumnNames(template);
    }

    @Override
    public final int getColumnIndex(String string) {
        return this.fDataset.getColumnIndex(string);
    }

    @Override
    public final String[] getColumnNamesArray() {
        return this.fDataset.getColumnNamesArray();
    }

    @Override
    public final GeneSet getColumnNamesGeneSet() {
        return this.fDataset.getColumnNamesGeneSet();
    }

    @Override
    public final String getColumnName(int n) {
        return this.fDataset.getColumnName(n);
    }

    @Override
    public final int getNumRow() {
        return this.fIndVector.getSize();
    }

    @Override
    public final int getNumCol() {
        return this.fDataset.getNumCol();
    }

    @Override
    public final int getDim() {
        return this.fDataset.getDim();
    }

    @Override
    public final String getQuickInfo() {
        StringBuffer stringBuffer = new StringBuffer().append(this.getNumRow()).append('x').append(this.getNumCol());
        return stringBuffer.toString();
    }

    @Override
    public final String toString(char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            stringBuffer.append(this.getRankName(i2)).append('=').append(this.getScore(i2)).append(c2);
        }
        return stringBuffer.toString();
    }

    @Override
    public final Matrix getMatrix() {
        Matrix matrix = new Matrix(this.fIndVector.getSize(), this.fDataset.getNumCol());
        for (int i2 = 0; i2 < this.fIndVector.getSize(); ++i2) {
            matrix.setRow(i2, this.fDataset.getRow(this.sdsrown2posinds(i2)));
        }
        return matrix;
    }

    private int sdsrown2posinds(int n) {
        return this.fIndVector.getAddress(n);
    }

    public final int[] getSortOrder() {
        return this.fIndVector.getAddresses();
    }

    public final int getUnscoredDatasetPosition(int n) {
        return this.sdsrown2posinds(n);
    }

    @Override
    public final int getRank(String string) {
        return this.getRowIndex(string);
    }

    @Override
    public final boolean isMember(String string) {
        return this.fRowNamesInSdsOrder.contains(string);
    }

    @Override
    public final float getValue(String string, XMath$Const xMath$Const) {
        if (xMath$Const.isScore()) {
            return this.getScore(string);
        }
        return this.getRank(string);
    }

    @Override
    public final float getScore(int n) {
        return this.fIndVector.getScore(n);
    }

    @Override
    public final float getScore(String string) {
        int n = this.getRowIndex(string);
        if (n == -1) {
            throw new IllegalArgumentException("Could not find feat index for: " + n + " " + string);
        }
        return this.fIndVector.getScore(n);
    }

    public final float[] getScores() {
        return this.fIndVector.getScoresArray();
    }

    @Override
    public final LabelledVector getRowLV(String string) {
        return this.getRowLV(this.getRowIndex(string));
    }

    @Override
    public final LabelledVector getRowLV(int n) {
        return new LabelledVector(this.getRowName(n), this.getColumnNamesArray(), this.getMatrix().getRowV(n));
    }

    @Override
    public final RankedList getRowRL(String string, SortMode sortMode, Order order) {
        return this.getRowLV(string).sort(sortMode, order);
    }

    @Override
    public final RankedList getRowRL(int n, SortMode sortMode, Order order) {
        return this.getRowLV(n).sort(sortMode, order);
    }

    @Override
    public final Vector getScoresV(boolean bl) {
        return this.fIndVector.getScoresV(bl);
    }

    public final Vector getScoreVector(int n) {
        Vector vector = this.fIndVector.getScoresV(true);
        vector.truncate(n);
        return vector;
    }

    @Override
    public final LabelledVector getScoreVectorL() {
        return new LabelledVector(this.getRankedNamesArray(), this.fIndVector.getScoresV(true));
    }

    public final float getMaxScore() {
        return this.fIndVector.getScoresV(false).max();
    }

    public final float getMinScore() {
        return this.fIndVector.getScoresV(false).min();
    }

    public final GeneSet getTopMarkers(int n, boolean bl) {
        String string = this.getName() + "top" + n + "_twosided" + bl;
        if (bl) {
            int[] nArray = XMath.splitTwoSided(n);
            int n2 = nArray[0];
            int n3 = nArray[1];
            return new FSet(string, new GeneSet[]{this._getTopMarkers(n2), this._getBottomMarkers(n3)});
        }
        return this._getTopMarkers(n);
    }

    public final GeneSet getBottomMarkers(int n, boolean bl) {
        String string = this.getName() + "bot" + n + "_twosided" + bl;
        if (bl) {
            int[] nArray = XMath.splitTwoSided(n);
            int n2 = nArray[0];
            int n3 = nArray[1];
            return new FSet(string, new GeneSet[]{this._getTopMarkers(n2), this._getBottomMarkers(n3)});
        }
        return this._getBottomMarkers(n);
    }

    private GeneSet _getTopMarkers(int n) {
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i2 = 0; i2 < n; ++i2) {
            arrayList.add(this.getRowName(i2));
        }
        return new FSet(this.getName() + "_top" + n, this.getNameEnglish(), arrayList, false);
    }

    private GeneSet _getBottomMarkers(int n) {
        ArrayList<String> arrayList = new ArrayList<String>(n);
        int n2 = this.getNumRow() - 1;
        for (int i2 = 0; i2 < n; ++i2) {
            arrayList.add(this.getRowName(n2));
            --n2;
        }
        return new FSet(this.getName() + "_bot" + n, this.getNameEnglish(), arrayList, false);
    }

    @Override
    public final int getSize() {
        return this.getNumRow();
    }

    @Override
    public final int getSize(ScoreMode scoreMode) {
        return this.getScoresV(false).getSize(scoreMode);
    }

    @Override
    public final String getRankName(int n) {
        return this.getRowName(n);
    }

    @Override
    public final float[] getScores(GeneSet geneSet) {
        float[] fArray = new float[geneSet.getNumMembers()];
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            fArray[i2] = this.getScore(geneSet.getMember(i2));
        }
        return fArray;
    }

    @Override
    public final int[] getRanks(GeneSet geneSet) {
        return RankedList$Helper.getRanks(geneSet, this);
    }

    @Override
    public final Vector getRanksV(GeneSet geneSet) {
        return RankedList$Helper.getRanksV(geneSet, this);
    }

    @Override
    public final List getNamesOfUpOrDnXRanks(int n, boolean bl) {
        return RankedList$Helper.getLabelsOfUpOrDnXRanks(n, bl, this);
    }

    @Override
    public final GeneSet getNamesOfUpOrDnXRanks_gs(int n, boolean bl) {
        return RankedList$Helper.getLabelsOfUpOrDnXRanks_gs(n, bl, this);
    }

    @Override
    public final GeneSetPair getNamesOfUpAndDnXRanks(int n) {
        return RankedList$Helper.getLabelsOfUpAndDnXRanks(n, this);
    }

    @Override
    public final String[] getNamesOfUpOrDnXRanks_array(int n, boolean bl) {
        return RankedList$Helper.getLabelsOfUpOrDnXRanks_array(n, bl, this);
    }

    @Override
    public final RankedList extractRanked(ScoreMode scoreMode) {
        return RankedList$Helper.extractRanked(scoreMode, (RankedList)this);
    }

    @Override
    public final RankedList extractRanked(int n) {
        return RankedList$Helper.extractRanked(n, (RankedList)this);
    }

    @Override
    public final RankedList extractRanked(GeneSet geneSet) {
        return RankedList$Helper.extract(geneSet, (RankedList)this);
    }

    public final ScoredDataset extractSds(GeneSet geneSet) {
        return this.extractSds(geneSet.getName(true), geneSet);
    }

    public final ScoredDataset extractSds(String string, GeneSet geneSet) {
        ScoredDatasetImpl scoredDatasetImpl = new ScoredDatasetImpl(this.extractRanked(geneSet), this.fDataset);
        scoredDatasetImpl.setName(string);
        return scoredDatasetImpl;
    }

    @Override
    public final RankedList extractRanked(int n, boolean bl) {
        return RankedList$Helper.extractRanked(n, bl, this);
    }

    @Override
    public final RankedList extractRanked(float f2, float f3) {
        return RankedList$Helper.extract(f2, f3, this);
    }

    @Override
    public final int getNumScores(float f2, float f3) {
        return RankedList$Helper.getNumScores(f2, f3, this);
    }

    @Override
    public final GeneSet getScores_gs(float f2, float f3) {
        return RankedList$Helper.getScores_gs(f2, f3, this);
    }

    @Override
    public final RankedList extractRanked(String[] stringArray) {
        return RankedList$Helper.extract(stringArray, (RankedList)this);
    }

    @Override
    public final RankedList extractRanked(List list) {
        return RankedList$Helper.extract(list, (RankedList)this);
    }

    @Override
    public final GeneSet toGeneSet() {
        return this.fRowNamesGeneSet;
    }

    @Override
    public final String toString(char c2, boolean bl) {
        return RankedList$Helper.toString(c2, bl, this);
    }

    @Override
    public final MetricWeightStruc getMetricWeightStruc() {
        if (this.ws == null) {
            this.ws = new DefaultMetricWeightStruc(null, this);
        }
        return this.ws;
    }
}

