/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.objects.AbstractRankedListDb_base;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.RankedListDb;
import edu.mit.broad.genome.objects.RankedListDb$Extracted;
import edu.mit.broad.genome.objects.RankedListDb$OrderedSampleNames;
import edu.mit.broad.genome.objects.RankedListDbImpl;
import edu.mit.broad.genome.objects.TemplateCohort;
import edu.mit.broad.genome.objects.TemplateCohort$Comp;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.vdb.chip.Chip;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RankedListDbSimple
extends AbstractRankedListDb_base
implements RankedListDb {
    private Dataset fFullDataset;
    private RankedList[] fRankedLists;

    public RankedListDbSimple(String string, Annot annot, Dataset dataset, RankedList[] rankedListArray) {
        if (rankedListArray == null) {
            throw new IllegalArgumentException("Param rls cannot be null");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (rankedListArray.length > 0) {
            int n = rankedListArray[0].getSize();
            for (int i2 = 0; i2 < rankedListArray.length; ++i2) {
                if (rankedListArray[i2].getSize() != n) {
                    throw new IllegalArgumentException("Unequal length of ranked lists: " + n + " and " + rankedListArray[i2].getSize() + " at index: " + i2 + " name: " + rankedListArray[i2].getName());
                }
                arrayList.add(rankedListArray[i2].getName());
            }
        }
        this.fRankedLists = rankedListArray;
        this.fFullDataset = dataset;
        Chip chip = null;
        if (annot != null) {
            chip = annot.getChip();
        } else if (dataset != null && dataset.getAnnot() != null) {
            chip = this.fFullDataset.getAnnot().getChip();
        }
        super.init(string, rankedListArray[0].getRankedNames(), arrayList, chip, annot);
    }

    @Override
    public final String getQuickInfo() {
        return "RankedLists " + this.fRankedLists.length;
    }

    @Override
    public final RankedListDb cloneShallow(String[] stringArray, boolean bl) {
        Object object;
        if (bl) {
            RankedList[] rankedListArray = new RankedList[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                rankedListArray[i2] = this.getRankedList(stringArray[i2]);
            }
            return new RankedListDbImpl(this.getName() + "_" + stringArray.length, rankedListArray, this.getChip(), this.getAnnot(), this.getDataset(), null);
        }
        ArrayList<RankedList> arrayList = new ArrayList<RankedList>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        List<String> list = Arrays.asList(stringArray);
        this.log.debug("Dont use: " + list);
        for (int i3 = 0; i3 < this.getNumRankedLists(); ++i3) {
            object = this.getRankedList(i3);
            String string = ParseUtils.string2strings(object.getName(), ".", false)[0];
            if (list.contains(string)) continue;
            arrayList.add((RankedList)object);
            arrayList2.add(string);
        }
        this.log.debug("## # excluded: " + stringArray.length + " # included: " + arrayList.size());
        Dataset dataset = new DatasetGenerators().extractColumns(this.fFullDataset.getName(), this.fFullDataset, arrayList2);
        object = this.getAnnot().cloneDeeep(arrayList2.toArray(new String[arrayList2.size()]));
        return new RankedListDbImpl(this.getName() + "_" + arrayList.size(), arrayList.toArray(new RankedList[arrayList.size()]), this.getChip(), (Annot)object, dataset, null);
    }

    @Override
    public final RankedList getRankedList(int n) {
        return this.fRankedLists[n];
    }

    @Override
    public final RankedList getRankedList(String string) {
        return this.fRankedLists[this.getRankedListIndex(string)];
    }

    @Override
    public final RankedListDb$OrderedSampleNames getSampleNames(int[] nArray, boolean bl) {
        throw new NotImplementedException();
    }

    @Override
    public final Dataset getDataset() {
        return this.fFullDataset;
    }

    @Override
    public final TemplateCohort getTemplateCohort() {
        throw new NotImplementedException();
    }

    @Override
    public final TemplateCohort$Comp getComp(String string) {
        throw new NotImplementedException();
    }

    @Override
    public final TemplateCohort$Comp getComp(int n) {
        throw new NotImplementedException();
    }

    @Override
    public final RankedListDb$Extracted extract(String string) {
        throw new NotImplementedException();
    }

    @Override
    public final RankedListDb$Extracted extract(int n) {
        throw new NotImplementedException();
    }

    @Override
    public final RankedListDb$Extracted extract(String string, GeneSet geneSet) {
        throw new NotImplementedException();
    }

    @Override
    public final RankedListDb$Extracted extract(int n, GeneSet geneSet) {
        throw new NotImplementedException();
    }

    @Override
    public final RankedListDb$Extracted extract(String string, int n) {
        throw new NotImplementedException();
    }

    @Override
    public final RankedListDb$Extracted extract(int n, int n2) {
        throw new NotImplementedException();
    }
}

