/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DatasetProxy;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.PersistentObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HClustDatasetStanford
extends AbstractObject
implements PersistentObject {
    private Dataset fDataset;
    private DatasetProxy fDatasetProxy;
    private List fGeneXNames;
    private List fArrayXNames;

    public HClustDatasetStanford(String string, Dataset dataset, List list, List list2, boolean bl) {
        if (dataset == null) {
            throw new IllegalArgumentException("Parameter ds cannot be null");
        }
        if (list == null) {
            throw new IllegalArgumentException("Parameter genexnames cannot be null");
        }
        if (list2 == null) {
            throw new IllegalArgumentException("Parameter arrayxnames cannot be null");
        }
        if (bl) {
            this.init(string, dataset, list, list2);
        } else {
            DefaultDataset defaultDataset = new DefaultDataset(dataset.getName(), dataset);
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (int i2 = 0; i2 < list.size(); ++i2) {
                arrayList.add(list.get(i2).toString());
            }
            ArrayList<String> arrayList2 = new ArrayList<String>(list2.size());
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                arrayList2.add(list2.get(i3).toString());
            }
            this.init(string, defaultDataset, arrayList, arrayList2);
        }
    }

    private void init(String string, Dataset dataset, List list, List list2) {
        super.initialize(string);
        if (dataset.getNumRow() != list.size()) {
            throw new IllegalArgumentException("Dataset nrows: " + dataset.getNumRow() + " must equal genexnames size: " + list.size());
        }
        if (dataset.getNumCol() != list2.size()) {
            throw new IllegalArgumentException("Dataset ncols: " + dataset.getNumCol() + " must equal arrayxnames size: " + list2.size());
        }
        this.fDataset = dataset;
        this.fDatasetProxy = new DatasetProxy(this.fDataset);
        this.fGeneXNames = Collections.unmodifiableList(list);
        this.fArrayXNames = Collections.unmodifiableList(list2);
    }

    public final Dataset getDataset() {
        return this.fDatasetProxy;
    }

    public final String getGeneXName(int n) {
        return (String)this.fGeneXNames.get(n);
    }

    public final int getGeneXIndex(String string) {
        return this.fGeneXNames.indexOf(string);
    }

    public final String getArrayXName(int n) {
        return (String)this.fArrayXNames.get(n);
    }

    public final int getArrayXIndex(String string) {
        return this.fArrayXNames.indexOf(string);
    }

    @Override
    public final String getQuickInfo() {
        return this.fDataset.getQuickInfo();
    }
}

