/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GPWrappers;
import edu.mit.broad.genome.objects.HClustDataset$Images;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import org.apache.log4j.Logger;
import org.genepattern.clustering.hierarchical.ArrayTreePanel;
import org.genepattern.clustering.hierarchical.AtrGtrReader;
import org.genepattern.clustering.hierarchical.GeneTreePanel;
import org.genepattern.clustering.hierarchical.image.HCLImage;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.heatmap.image.DisplaySettings;

public class HClustDataset {
    private Logger log = XLogger.getLogger(HClustDataset.class);
    private Dataset fDataset_ordered;
    private File fGtrFile_opt;
    private File fAtrFile_opt;
    private ArrayTreePanel fArrayTreePanel;
    private GeneTreePanel fGeneTreePanel;

    public HClustDataset(Dataset dataset, File file, File file2) {
        AtrGtrReader atrGtrReader;
        if (dataset == null) {
            throw new IllegalArgumentException("Param ds_ordered cannot be null");
        }
        if (file != null) {
            this.fGtrFile_opt = file;
            atrGtrReader = new AtrGtrReader(dataset.getRowNamesArray(), this.fGtrFile_opt.getName());
            this.fGeneTreePanel = new GeneTreePanel(atrGtrReader);
        }
        if (file2 != null) {
            this.fAtrFile_opt = file2;
            atrGtrReader = new AtrGtrReader(dataset.getRowNamesArray(), this.fGtrFile_opt.getName());
            this.fArrayTreePanel = new ArrayTreePanel(atrGtrReader);
        }
        this.init(dataset, this.fArrayTreePanel, this.fGeneTreePanel);
    }

    public HClustDataset(Dataset dataset, ArrayTreePanel arrayTreePanel, GeneTreePanel geneTreePanel) {
        this.init(dataset, arrayTreePanel, geneTreePanel);
    }

    private void init(Dataset dataset, ArrayTreePanel arrayTreePanel, GeneTreePanel geneTreePanel) {
        this.fArrayTreePanel = arrayTreePanel;
        this.fGeneTreePanel = geneTreePanel;
        this.fDataset_ordered = dataset;
        this.log.debug("Inited hclust to geneNames: " + this.fDataset_ordered.getNumRow() + " arrayNames: " + this.fDataset_ordered.getNumCol() + " fGtrFile: " + this.fGtrFile_opt + " fAtrFile: " + this.fAtrFile_opt + " fArrayTreePanel: " + this.fArrayTreePanel + " fGeneTreePanel: " + this.fGeneTreePanel);
    }

    public final String[] getGeneNames() {
        return this.fDataset_ordered.getRowNamesArray();
    }

    public final String[] getArrayNames() {
        return this.fDataset_ordered.getColumnNamesArray();
    }

    public final Dataset getDatasetOrdered() {
        return this.fDataset_ordered;
    }

    public final GeneTreePanel getGeneTreePanel() {
        return this.fGeneTreePanel;
    }

    public final ArrayTreePanel getArrayTreePanel() {
        return this.fArrayTreePanel;
    }

    public final boolean hasGtr() {
        return this.fGeneTreePanel != null;
    }

    public final boolean hasAtr() {
        return this.fArrayTreePanel != null;
    }

    public final HClustDataset$Images createImages(int n) {
        Object object;
        Dataset dataset = this.getDatasetOrdered();
        ArrayTreePanel arrayTreePanel = this.getArrayTreePanel();
        if (arrayTreePanel != null) {
            arrayTreePanel.setBottomGutter(0);
            arrayTreePanel.setTopGutter(0);
            arrayTreePanel.setElementWidth(n);
            object = new Dimension(arrayTreePanel.getPreferredSize().width, 150);
            arrayTreePanel.setPreferredSize((Dimension)object);
            arrayTreePanel.setSize((Dimension)object);
        }
        object = GPWrappers.createIExpressionData(dataset);
        DisplaySettings displaySettings = new DisplaySettings();
        displaySettings.drawGrid = false;
        displaySettings.rowSize = n;
        displaySettings.columnSize = n;
        displaySettings.drawRowDescriptions = true;
        displaySettings.drawRowNames = true;
        displaySettings.drawGrid = false;
        displaySettings.gridLinesColor = Color.LIGHT_GRAY;
        displaySettings.sampleAnnotationSpacing = 10;
        displaySettings.sampleAnnonationsHeight = 20;
        displaySettings.showFeatureGridLines = true;
        displaySettings.showSampleGridLines = true;
        HClustDataset$Images hClustDataset$Images = new HClustDataset$Images();
        GeneTreePanel geneTreePanel = this.getGeneTreePanel();
        if (geneTreePanel != null) {
            geneTreePanel.setElementHeight(n);
            Dimension dimension = new Dimension(geneTreePanel.getPreferredSize().width, 2);
            geneTreePanel.setPreferredSize(dimension);
            geneTreePanel.setSize(dimension);
            hClustDataset$Images.geneTree = this.getGeneTreePanel().snapshot();
        }
        if (arrayTreePanel != null) {
            hClustDataset$Images.arrayTree = arrayTreePanel.snapshot();
        }
        hClustDataset$Images.fullImage = HCLImage.createImage((IExpressionData)object, hClustDataset$Images.geneTree, hClustDataset$Images.arrayTree, displaySettings, GPWrappers.createSampleAnnotator(dataset, null), GPWrappers.createFeatureAnnotator(dataset));
        return hClustDataset$Images;
    }
}

