/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.Id;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.DataFormat;
import edu.mit.broad.genome.utils.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class AbstractObject
implements PersistentObject {
    private String fName;
    private String fNameEnglish;
    private Id fId;
    private StringBuffer fComment;
    protected transient Logger log;
    private boolean fInited;
    private Properties prp;

    protected AbstractObject(String string) {
        this.initialize(Id.createId(), string);
    }

    protected AbstractObject(String string, String string2) {
        this.initialize(Id.createId(), string, string2);
    }

    protected AbstractObject() {
        this.log = XLogger.getLogger(this.getClass());
    }

    protected final void initialize(Id id, String string) {
        this.initialize(id, string, null);
    }

    protected final void initialize(Id id, String string, String string2) {
        if (this.fInited) {
            throw new IllegalStateException("Already initialized. disp name " + string);
        }
        if (id == null) {
            throw new NullPointerException("Parameter id cannot be null");
        }
        if (string == null) {
            throw new NullPointerException("Parameter name cannot be null");
        }
        this.log = XLogger.getLogger(this.getClass());
        this.fId = id;
        this.fName = this.removeExtension(string);
        if (string2 != null) {
            this.fNameEnglish = this.removeExtension(string2);
        }
        this.fInited = true;
    }

    protected final void initialize(String string) {
        this.initialize(Id.createId(), string);
    }

    protected final void initialize(String string, String string2) {
        this.initialize(Id.createId(), string, string2);
    }

    protected final boolean isInited() {
        return this.fInited;
    }

    private String removeExtension(String string) {
        return string;
    }

    @Override
    public Id getId() {
        this.checkInit();
        return this.fId;
    }

    private void checkInit() {
        if (!this.fInited) {
            throw new IllegalStateException("Uninitialized: " + this.fName);
        }
    }

    @Override
    public String getName() {
        this.checkInit();
        return this.fName;
    }

    @Override
    public String getNameEnglish() {
        this.checkInit();
        return this.fNameEnglish;
    }

    @Override
    public String getComment() {
        if (this.fComment == null) {
            return "";
        }
        return this.fComment.toString();
    }

    @Override
    public void addComment(String string) {
        if (this.fComment == null) {
            this.fComment = new StringBuffer(string);
        }
    }

    public final void addComment(StringBuffer stringBuffer) {
        if (this.fComment == null) {
            this.fComment = new StringBuffer(stringBuffer.toString());
        }
    }

    protected final void setName(String string) {
        if (string == null) {
            this.log.warn("Ignoring rename request as newname is null");
        } else {
            this.fName = string;
        }
    }

    public static final String enforceNamingConvention(String string, Class clazz) {
        String string2;
        if (Strings.contains(string, "#")) {
            return string;
        }
        String string3 = NamingConventions.getExtension(string);
        if (string3.equals(string2 = DataFormat.getExtension(clazz))) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string).append('.').append(string2);
        return stringBuffer.toString();
    }

    public static final List getNames(PersistentObject[] persistentObjectArray) {
        ArrayList<String> arrayList = new ArrayList<String>(persistentObjectArray.length);
        for (int i2 = 0; i2 < persistentObjectArray.length; ++i2) {
            arrayList.add(persistentObjectArray[i2].getName());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static final String[] getNamesArray(FSet[] fSetArray) {
        List list = AbstractObject.getNames(fSetArray);
        return list.toArray(new String[list.size()]);
    }

    @Override
    public void setProperty(String string, String string2) {
        if (this.prp == null) {
            this.prp = new Properties();
        }
        this.prp.put(string, string2);
    }

    @Override
    public boolean hasProperty(String string) {
        if (this.prp == null) {
            return false;
        }
        String string2 = this.prp.getProperty(string);
        return string2 != null && string2.length() > 0;
    }

    @Override
    public String getProperty(String string) {
        if (this.prp == null) {
            return null;
        }
        return this.prp.getProperty(string);
    }
}

