/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.Errors;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.BitSetDataset;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSetMatrixHelper;
import edu.mit.broad.genome.parsers.AuxUtils;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractGeneSetMatrix
extends AbstractObject
implements GeneSetMatrix {
    private List fGeneSets;
    private Set fGeneSetNames_nonaux = null;
    private Map fNameGeneSetMap;

    protected AbstractGeneSetMatrix() {
    }

    @Override
    public GeneSetMatrix cloneShallow(String string) {
        this.setName(string);
        return this;
    }

    protected final void initMatrix(String string, GeneSet[] geneSetArray) {
        super.initialize(string);
        if (geneSetArray == null) {
            throw new IllegalArgumentException("Param gsets cannot be null");
        }
        HashSet<String> hashSet = new HashSet<String>();
        Errors errors = new Errors();
        this.fGeneSets = new ArrayList(geneSetArray.length);
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            if (geneSetArray[i2] == null) {
                throw new IllegalArgumentException("Null GeneSet not allowed at index: " + i2 + " total len: " + geneSetArray.length);
            }
            if (hashSet.contains(geneSetArray[i2].getName())) {
                errors.add("GeneSets should have unique names. The lookup is case INsensitive. Found duplicate name: " + geneSetArray[i2].getName());
            } else {
                hashSet.add(geneSetArray[i2].getName());
            }
            this.fGeneSets.add(geneSetArray[i2]);
        }
        errors.barfIfNotEmptyRuntime();
    }

    @Override
    public boolean containsSet(String string) {
        if (this.fGeneSetNames_nonaux == null) {
            this.fGeneSetNames_nonaux = new THashSet();
            for (int i2 = 0; i2 < this.getNumGeneSets(); ++i2) {
                this.fGeneSetNames_nonaux.add(AuxUtils.getAuxNameOnlyNoHash(this.getGeneSet(i2).getName()));
            }
        }
        if (this.fGeneSetNames_nonaux.contains(string)) {
            return true;
        }
        return this.fGeneSetNames_nonaux.contains(AuxUtils.getAuxNameOnlyNoHash(string));
    }

    @Override
    public String getQuickInfo() {
        StringBuffer stringBuffer = new StringBuffer().append(this.getNumGeneSets()).append(" gene sets");
        return stringBuffer.toString();
    }

    @Override
    public int getNumGeneSets() {
        return this.fGeneSets.size();
    }

    @Override
    public GeneSet getGeneSet(int n) {
        return (GeneSet)this.fGeneSets.get(n);
    }

    @Override
    public Dataset createTagMatrix(boolean bl, boolean bl2) {
        float f2 = 0.0f;
        if (bl2) {
            f2 = 0.01f;
        }
        if (bl) {
            String[] stringArray = this.getGeneSetNames(true);
            String[] stringArray2 = this.getAllMemberNamesOnlyOnce();
            this.log.info("Making TagMatrix ...rown: " + stringArray2.length + " coln: " + stringArray.length);
            Matrix matrix = new Matrix(stringArray2.length, stringArray.length);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                GeneSet geneSet = this.getGeneSet(i2);
                for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                    if (geneSet.isMember(stringArray2[i3])) {
                        matrix.setElement(i3, i2, 1.0f);
                        continue;
                    }
                    matrix.setElement(i3, i2, f2);
                }
            }
            DefaultDataset defaultDataset = new DefaultDataset(this.getName() + "_tag_matrix", matrix, stringArray2, stringArray, true);
            this.log.debug("Done making TagMatrix:" + defaultDataset.getQuickInfo());
            return defaultDataset;
        }
        String[] stringArray = this.getGeneSetNames(true);
        String[] stringArray3 = this.getAllMemberNamesOnlyOnce();
        this.log.info("Making TagMatrix ...rown: " + stringArray3.length + " coln: " + stringArray.length);
        Matrix matrix = new Matrix(stringArray.length, stringArray3.length);
        for (int i4 = 0; i4 < stringArray.length; ++i4) {
            GeneSet geneSet = this.getGeneSet(i4);
            for (int i5 = 0; i5 < stringArray3.length; ++i5) {
                if (geneSet.isMember(stringArray3[i5])) {
                    matrix.setElement(i4, i5, 1.0f);
                    continue;
                }
                matrix.setElement(i4, i5, f2);
            }
        }
        DefaultDataset defaultDataset = new DefaultDataset(this.getName() + "_tag_matrix", matrix, stringArray, stringArray3, true);
        this.log.debug("Done making TagMatrix:" + defaultDataset.getQuickInfo());
        return defaultDataset;
    }

    @Override
    public GeneSet getGeneSet(String string) {
        Object object;
        String string2 = string.replace('|', '/');
        string2 = AuxUtils.getAuxNameOnlyNoHash(string);
        string2 = string2.toUpperCase();
        if (this.fNameGeneSetMap == null) {
            this.fNameGeneSetMap = new HashMap(this.getNumGeneSets());
            for (int i2 = 0; i2 < this.getNumGeneSets(); ++i2) {
                object = this.getGeneSet(i2);
                this.fNameGeneSetMap.put(object.getName().toUpperCase(), object);
                this.fNameGeneSetMap.put(AuxUtils.getAuxNameOnlyNoHash(object.getName()).toUpperCase(), object);
            }
        }
        Object v = this.fNameGeneSetMap.get(string2);
        object = null;
        if (v == null) {
            object = string2;
            if (string2.indexOf("#") == -1) {
                object = this.getName() + "#" + string2;
            }
            v = this.fNameGeneSetMap.get(object);
        }
        if (v == null) {
            object = string2;
            if (string2.indexOf("#") == -1) {
                object = this.getName() + "#" + string2;
            }
            if ((v = this.fNameGeneSetMap.get(object = ((String)object).replace('\\', '/'))) == null) {
                object = string2;
                if (string2.indexOf("#") == -1) {
                    object = this.getName() + "#" + string2;
                }
                object = ((String)object).replace('/', '\\');
                v = this.fNameGeneSetMap.get(object);
            }
            if (v == null) {
                object = string2.replace('|', '/');
                if (string2.indexOf("#") == -1) {
                    object = this.getName() + "#" + string2;
                }
                object = ((String)object).replace('/', '\\');
                v = this.fNameGeneSetMap.get(object);
            }
        }
        if (v == null) {
            StringBuffer stringBuffer = new StringBuffer("In GeneSetMatrix: " + this.getName() + " no GeneSet found with name: " + string2);
            stringBuffer.append("\nAvailable GeneSets are: \n");
            for (Object k2 : this.fNameGeneSetMap.keySet()) {
                stringBuffer.append(k2.toString()).append('\n');
            }
            stringBuffer.append("Also tried looking for gset: ").append((String)object);
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        return (GeneSet)v;
    }

    @Override
    public GeneSet[] getGeneSets() {
        return this.fGeneSets.toArray(new GeneSet[this.fGeneSets.size()]);
    }

    @Override
    public List getGeneSetsL() {
        return Collections.unmodifiableList(this.fGeneSets);
    }

    @Override
    public GeneSet[] getGeneSets(int n, int n2) {
        return GeneSetMatrixHelper.getGeneSets(this, n, n2);
    }

    @Override
    public List getGeneSetsL(int n, int n2) {
        return GeneSetMatrixHelper.getGeneSetsL(this, n, n2);
    }

    @Override
    public String[] getGeneSetNames(boolean bl) {
        List list = this.getGeneSetNamesL(bl);
        return list.toArray(new String[list.size()]);
    }

    @Override
    public List getGeneSetNamesL(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < this.getNumGeneSets(); ++i2) {
            String string = this.getGeneSet(i2).getName();
            if (bl) {
                arrayList.add(AuxUtils.getAuxNameOnlyNoHash(string));
                continue;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    public Set getGeneSetNamesS(boolean bl) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < this.getNumGeneSets(); ++i2) {
            String string = this.getGeneSet(i2).getName();
            if (bl) {
                hashSet.add(AuxUtils.getAuxNameOnlyNoHash(string));
                continue;
            }
            hashSet.add(string);
        }
        return hashSet;
    }

    @Override
    public int getMaxGeneSetSize() {
        return GeneSetMatrixHelper.getMaxMemberCount(this.fGeneSets);
    }

    @Override
    public String[] getAllMemberNamesOnlyOnce() {
        return GeneSetMatrixHelper.getAllMemberNames(this.fGeneSets);
    }

    @Override
    public GeneSet getAllMemberNames_gset() {
        return new FSet(this.getName(), this.getAllMemberNamesOnlyOnceS());
    }

    @Override
    public Set getAllMemberNamesOnlyOnceS() {
        return GeneSetMatrixHelper.getAllMemberNamesS(this.fGeneSets);
    }

    @Override
    public List getAllMemberNamesL() {
        return GeneSetMatrixHelper.getAllMemberNameOccurrencesL(this.fGeneSets);
    }

    @Override
    public String[] getAllMemberNames() {
        return GeneSetMatrixHelper.getAllMemberNameOccurrences(this.fGeneSets);
    }

    @Override
    public String getGeneSetName(int n) {
        return this.getGeneSet(n).getName();
    }

    public final String[] getAllGeneSetNames() {
        return GeneSetMatrixHelper.getAllGeneSetNames(this);
    }

    @Override
    public String[] getGeneSetMembershipNames(String string) {
        return GeneSetMatrixHelper.getGeneSetMembershipNames(string, this);
    }

    @Override
    public BitSet getGeneSetMembershipBitSet(String string) {
        return GeneSetMatrixHelper.getGeneSetMembershipBitSet(string, this);
    }

    @Override
    public BitSetDataset getGeneSetMembershipBitSetDataset(String string, String[] stringArray) {
        return GeneSetMatrixHelper.getGeneSetMembershipBitSetDataset(string, stringArray, this);
    }

    @Override
    public BitSetDataset getGeneSetMembershipBitSetDataset() {
        return GeneSetMatrixHelper.getGeneSetMembershipBitSetDataset(this);
    }

    @Override
    public GeneSet[] getGeneSets(Set set) {
        return GeneSetMatrixHelper.getGeneSets(set, (GeneSetMatrix)this);
    }

    @Override
    public GeneSetMatrix getGeneSetMatrix(GeneSet geneSet) {
        return GeneSetMatrixHelper.getGeneSetMatrix(geneSet, this);
    }

    @Override
    public GeneSet[] getGeneSets(String[] stringArray) {
        return GeneSetMatrixHelper.getGeneSets(stringArray, (GeneSetMatrix)this);
    }

    @Override
    public GeneSet[] getGeneSetMembershipSets(String string) {
        return GeneSetMatrixHelper.getGeneSetMemberships(string, this);
    }
}

