/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.math.AddressedVector;
import edu.mit.broad.genome.math.DoubleElement;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.Range;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector$ComputeSet;
import edu.mit.broad.genome.math.VectorFunctor$Statistic;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.utils.ImmutedException;
import gnu.trove.TDoubleArrayList;
import gnu.trove.TFloatArrayList;
import gnu.trove.TFloatHashSet;
import gnu.trove.TIntArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Vector {
    protected int elementCount;
    protected float[] elementData;
    public transient Vector$ComputeSet computeset = new Vector$ComputeSet(this);
    private boolean fImmuted;
    private Vector fNaNless;
    private Vector fSortedVectorForPercentiles;

    public Vector(int n) {
        this.elementCount = n;
        this.elementData = new float[n];
        if (this.computeset == null) {
            this.computeset = new Vector$ComputeSet(this);
        }
    }

    public Vector(int n, float f2) {
        this.elementCount = n;
        this.elementData = new float[n];
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.elementData[i2] = f2;
        }
        if (this.computeset == null) {
            this.computeset = new Vector$ComputeSet(this);
        }
    }

    public Vector(float[] fArray, boolean bl) {
        this.elementCount = fArray.length;
        if (bl) {
            this.elementData = fArray;
        } else {
            this.elementData = new float[this.elementCount];
            System.arraycopy(fArray, 0, this.elementData, 0, this.elementCount);
        }
        if (this.computeset == null) {
            this.computeset = new Vector$ComputeSet(this);
        }
    }

    public Vector(Vector vector, ScoreMode scoreMode) {
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            float f2 = vector.getElement(i2);
            if (scoreMode.isPostiveOnly() && XMath.isPositive(f2)) {
                tFloatArrayList.add(f2);
                continue;
            }
            if (scoreMode.isNegativeOnly() && XMath.isNegative(f2)) {
                tFloatArrayList.add(f2);
                continue;
            }
            if (scoreMode.isPostiveAndNegTogether()) {
                tFloatArrayList.add(vector.elementData);
                break;
            }
            throw new IllegalArgumentException("Unkniwn ScoreMode: " + scoreMode);
        }
        this.elementCount = tFloatArrayList.size();
        this.elementData = tFloatArrayList.toNativeArray();
        if (this.computeset == null) {
            this.computeset = new Vector$ComputeSet(this);
        }
    }

    public Vector(Vector[] vectorArray) {
        int n;
        if (vectorArray == null) {
            throw new IllegalArgumentException("Param vectors cannot be null");
        }
        int n2 = 0;
        for (n = 0; n < vectorArray.length; ++n) {
            n2 += vectorArray[n].getSize();
        }
        this.elementCount = n2;
        this.elementData = new float[n2];
        n = 0;
        for (int i2 = 0; i2 < vectorArray.length; ++i2) {
            System.arraycopy(vectorArray[i2].elementData, 0, this.elementData, n, vectorArray[i2].elementCount);
            n += vectorArray[i2].elementCount;
        }
        if (this.computeset == null) {
            this.computeset = new Vector$ComputeSet(this);
        }
    }

    public Vector(int[] nArray) {
        this(nArray.length);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.elementData[i2] = nArray[i2];
        }
    }

    public Vector(float[] fArray) {
        this(fArray, false);
    }

    public Vector(Matrix matrix) {
        this(matrix.elementData, false);
    }

    public Vector(List list) {
        this(DoubleElement.toFloats(list));
    }

    public Vector(DoubleElement[] doubleElementArray) {
        this(DoubleElement.toFloats(doubleElementArray));
    }

    public Vector(Vector vector, boolean bl) {
        this(vector.elementData, bl);
    }

    public Vector(double[] dArray) {
        this(dArray.length);
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            this.elementData[i2] = (float)dArray[i2];
        }
    }

    public Vector(String string) {
        this(ParseUtils.string2floats(string));
    }

    public Vector(TDoubleArrayList tDoubleArrayList) {
        this(tDoubleArrayList.toNativeArray());
    }

    public Vector(TFloatArrayList tFloatArrayList) {
        this(tFloatArrayList.toNativeArray());
    }

    public Vector(TIntArrayList tIntArrayList) {
        this(tIntArrayList.toNativeArray());
    }

    public Vector(Vector vector) {
        this(vector.elementCount, vector);
    }

    public Vector(int n, Vector vector) {
        this(n);
        System.arraycopy(vector.elementData, 0, this.elementData, 0, n);
    }

    public Vector(float[] fArray, int n) {
        this(n);
        System.arraycopy(fArray, 0, this.elementData, 0, this.elementCount);
    }

    public Vector(int n, int n2) {
        this(n2 - n + 1);
        int n3 = 0;
        for (int i2 = n; i2 < n2 + 1; ++i2) {
            this.setElement(n3++, i2);
        }
    }

    public Vector(Vector vector, Vector vector2) {
        this(new Vector[]{vector, vector2});
    }

    public static final Vector createByMerging(Vector[] vectorArray, VectorFunctor$Statistic vectorFunctor$Statistic) {
        Vector.enforceEqualSize(vectorArray, true);
        int n = vectorArray[0].getSize();
        Vector vector = new Vector(n);
        for (int i2 = 0; i2 < n; ++i2) {
            Vector vector2 = new Vector(vectorArray.length);
            for (int i3 = 0; i3 < vectorArray.length; ++i3) {
                vector2.setElement(i3, vectorArray[i3].getElement(i2));
            }
            double d2 = vectorFunctor$Statistic.getValue(vector2);
            vector.setElement(i2, (float)d2);
        }
        return vector;
    }

    public static final Vector createRunningProfile(Vector[] vectorArray, VectorFunctor$Statistic vectorFunctor$Statistic) {
        Vector vector = new Vector(vectorArray.length);
        for (int i2 = 0; i2 < vectorArray.length; ++i2) {
            vector.setElement(i2, (float)vectorFunctor$Statistic.getValue(vectorArray[i2]));
        }
        return vector;
    }

    public static final void enforceEqualSize(Vector[] vectorArray, boolean bl) {
        if (vectorArray == null) {
            throw new IllegalArgumentException("Param vs cannot be null");
        }
        if (vectorArray.length == 0) {
            if (bl) {
                throw new IllegalArgumentException("Zero length vector array not allowed: " + vectorArray.length);
            }
            return;
        }
        boolean bl2 = false;
        int n = vectorArray[0].getSize();
        for (int i2 = 0; i2 < vectorArray.length; ++i2) {
            if (vectorArray[i2].getSize() == n) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            StringBuffer stringBuffer = new StringBuffer("Not all vectors have the same size. Offenders are\n");
            for (int i3 = 0; i3 < vectorArray.length; ++i3) {
                stringBuffer.append(i3).append(" size: ").append(vectorArray[i3].getSize());
            }
            throw new IllegalArgumentException(stringBuffer.toString());
        }
    }

    public static final int findMaxSize(Vector[] vectorArray) {
        if (vectorArray == null) {
            throw new IllegalArgumentException("Param vs cannot be null");
        }
        int n = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < vectorArray.length; ++i2) {
            if (n >= vectorArray[i2].getSize()) continue;
            n = vectorArray[i2].getSize();
        }
        return n;
    }

    public static final int findMinSize(Vector[] vectorArray) {
        if (vectorArray == null) {
            throw new IllegalArgumentException("Param vs cannot be null");
        }
        int n = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < vectorArray.length; ++i2) {
            if (n <= vectorArray[i2].getSize()) continue;
            n = vectorArray[i2].getSize();
        }
        return n;
    }

    public final void exp(double d2) {
        this.checkImmutable();
        for (int i2 = 0; i2 < this.elementData.length; ++i2) {
            float f2 = this.elementData[i2];
            this.elementData[i2] = (float)Math.pow(d2, f2);
        }
    }

    public final double sum() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            d2 += (double)this.elementData[i2];
        }
        return d2;
    }

    public final double sum_abs() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            d2 += (double)Math.abs(this.elementData[i2]);
        }
        return d2;
    }

    public final double sum(int n, int n2) {
        double d2 = 0.0;
        for (int i2 = n; i2 < n2; ++i2) {
            d2 += (double)this.elementData[i2];
        }
        return d2;
    }

    public final double sum(ScoreMode scoreMode) {
        return this._sum(scoreMode)[0];
    }

    private double[] _sum(ScoreMode scoreMode) {
        double d2 = 0.0;
        int n = 0;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            if (scoreMode.isPostiveAndNegTogether()) {
                return new double[]{this.sum(), this.getSize()};
            }
            if (scoreMode.isPostiveOnly() && XMath.isPositive(this.elementData[i2])) {
                d2 += (double)this.elementData[i2];
                ++n;
                continue;
            }
            if (!scoreMode.isNegativeOnly() || !XMath.isNegative(this.elementData[i2])) continue;
            d2 += (double)this.elementData[i2];
            ++n;
        }
        return new double[]{d2, n};
    }

    public final double sumNanSafe() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            if (Float.isNaN(this.elementData[i2])) continue;
            d2 += (double)this.elementData[i2];
        }
        return d2;
    }

    public final double sqrtsum() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            d2 += Math.sqrt(this.elementData[i2]);
        }
        return d2;
    }

    public final double squaresum() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            d2 += (double)(this.elementData[i2] * this.elementData[i2]);
        }
        return d2;
    }

    public final double squaresumNanSafe() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            if (Float.isNaN(this.elementData[i2])) continue;
            d2 += (double)(this.elementData[i2] * this.elementData[i2]);
        }
        return d2;
    }

    public final double mean() {
        this.computeset.mean = this.sum() / (double)this.elementCount;
        return this.computeset.mean;
    }

    public final double meanOrMedian(boolean bl) {
        if (bl) {
            return this.mean();
        }
        return this.median();
    }

    public final double mad(boolean bl) {
        double d2 = this.meanOrMedian(bl);
        Vector vector = new Vector(this.elementData.length);
        for (int i2 = 0; i2 < this.elementData.length; ++i2) {
            vector.setElement(i2, Math.abs((double)this.elementData[i2] - d2));
        }
        return vector.meanOrMedian(bl);
    }

    public final double mean(int n, int n2) {
        return this.sum(n, n2) / (double)(n2 - n);
    }

    public final double mean(ScoreMode scoreMode) {
        return this._mean(scoreMode)[0];
    }

    private double[] _mean(ScoreMode scoreMode) {
        double[] dArray = this._sum(scoreMode);
        return new double[]{dArray[0] / dArray[1], dArray[1]};
    }

    public final double median() {
        if (this.elementCount == 0) {
            return Double.NaN;
        }
        int n = this.elementCount;
        float[] fArray = new float[n];
        System.arraycopy(this.elementData, 0, fArray, 0, n);
        Arrays.sort(fArray);
        int n2 = (n - 1) / 2;
        if (XMath.isEven(n)) {
            return (fArray[n2] + fArray[n / 2]) / 2.0f;
        }
        return fArray[n2];
    }

    public final int medianIndex() {
        if (this.elementCount == 0) {
            return -1;
        }
        int n = this.elementCount;
        float[] fArray = new float[n];
        System.arraycopy(this.elementData, 0, fArray, 0, n);
        Arrays.sort(fArray);
        int n2 = (n - 1) / 2;
        return n2;
    }

    public final Vector toVectorNaNless() {
        if (this.fNaNless == null) {
            TFloatArrayList tFloatArrayList = new TFloatArrayList();
            for (int i2 = 0; i2 < this.getSize(); ++i2) {
                float f2 = this.getElement(i2);
                if (Float.isNaN(f2)) continue;
                tFloatArrayList.add(f2);
            }
            if (tFloatArrayList.size() == 0) {
                this.fNaNless = this;
            } else {
                this.fNaNless = new Vector(tFloatArrayList);
                this.fNaNless.setImmutable();
            }
        }
        return this.fNaNless;
    }

    public final float sig(double d2) {
        float[] fArray = new float[this.elementCount];
        System.arraycopy(this.elementData, 0, fArray, 0, this.elementCount);
        Arrays.sort(fArray);
        int n = (int)(d2 * (double)this.elementCount);
        return this.elementData[n];
    }

    public final double var(boolean bl, boolean bl2) {
        if (bl2) {
            double d2;
            this.stddev(bl, bl2);
            this.computeset.var = d2 = this.computeset.stddev * this.computeset.stddev;
            return d2;
        }
        return this._var(bl);
    }

    private double _var(boolean bl) {
        double d2;
        double d3 = 0.0;
        int n = this.elementCount;
        if (!bl) {
            --n;
        }
        if (n <= 0) {
            return d3;
        }
        this.computeset.mean = d2 = this.mean();
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            double d4 = (double)this.elementData[i2] - d2;
            d3 += d4 * d4;
        }
        return d3 / (double)n;
    }

    public final double stddev(boolean bl, boolean bl2) {
        double d2 = Math.sqrt(this._var(bl));
        double d3 = this.computeset.mean;
        if (bl2) {
            double d4 = 0.2 * Math.abs(d3);
            if (d4 == 0.0) {
                d4 = 0.2;
            }
            if (!(d4 < d2)) {
                d2 = d4;
            }
        }
        this.computeset.stddev = d2;
        return this.computeset.stddev;
    }

    public final double vard(boolean bl, boolean bl2) {
        return this.stddev(bl, bl2) / this.mean();
    }

    public final float max_TTTT(String string) {
        float f2 = Float.NEGATIVE_INFINITY;
        int n = -1;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            if (!(this.elementData[i2] > f2)) continue;
            f2 = this.elementData[i2];
            n = i2;
        }
        if (this.computeset == null) {
            this.computeset = new Vector$ComputeSet(this);
        }
        this.computeset.max = f2;
        this.computeset.maxindex = n;
        if (n == -1) {
            System.out.println("WARNING: could not find max for: " + string + " " + this.toString(','));
            f2 = Float.NaN;
        }
        return f2;
    }

    public final float max_cached() {
        if (this.computeset == null || Float.isNaN((float)this.computeset.max)) {
            this.max();
        }
        return (float)this.computeset.max;
    }

    public final float min_cached() {
        if (this.computeset == null || Float.isNaN((float)this.computeset.min)) {
            this.min();
        }
        return (float)this.computeset.min;
    }

    public final float max() {
        float f2 = Float.NEGATIVE_INFINITY;
        int n = -1;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            if (!(this.elementData[i2] > f2)) continue;
            f2 = this.elementData[i2];
            n = i2;
        }
        if (this.computeset == null) {
            this.computeset = new Vector$ComputeSet(this);
        }
        this.computeset.max = f2;
        this.computeset.maxindex = n;
        if (n == -1) {
            System.out.println("WARNING: could not find max for: " + this.toString(','));
            f2 = Float.NaN;
        }
        return f2;
    }

    public final int maxAtIndex() {
        float f2 = Float.NEGATIVE_INFINITY;
        int n = -1;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            if (!(this.elementData[i2] > f2)) continue;
            f2 = this.elementData[i2];
            n = i2;
        }
        if (n == -1) {
            throw new IllegalStateException("No max found. Values are:\n" + Printf.outs(this.elementData));
        }
        this.computeset.max = f2;
        this.computeset.maxindex = n;
        return n;
    }

    public final float maxDevFrom0() {
        float f2 = this.max();
        float f3 = this.min();
        if (Math.abs(f3) > f2) {
            return f3;
        }
        return f2;
    }

    public final int maxDevFrom0Index() {
        float f2 = this.max();
        float f3 = this.min();
        if (Math.abs(f3) > f2) {
            return this.minAtIndex();
        }
        return this.maxAtIndex();
    }

    public final float min() {
        float f2 = Float.POSITIVE_INFINITY;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            if (!(this.elementData[i2] < f2)) continue;
            f2 = this.elementData[i2];
        }
        this.computeset.min = f2;
        return f2;
    }

    public final int minAtIndex() {
        float f2 = Float.POSITIVE_INFINITY;
        int n = -1;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            if (!(this.elementData[i2] < f2)) continue;
            f2 = this.elementData[i2];
            n = i2;
        }
        if (n == -1) {
            throw new IllegalStateException("No max found. Values are:\n" + Printf.outs(this.elementData));
        }
        this.computeset.min = f2;
        this.computeset.minindex = n;
        return n;
    }

    public final TIntArrayList minAtIndex_all_of_them() {
        int n = this.minAtIndex();
        float f2 = this.getElement(n);
        return this.getElementIndices(f2);
    }

    public final TIntArrayList getElementIndices(float f2) {
        TIntArrayList tIntArrayList = new TIntArrayList();
        for (int i2 = 0; i2 < this.elementData.length; ++i2) {
            if (this.elementData[i2] != f2) continue;
            tIntArrayList.add(i2);
        }
        return tIntArrayList;
    }

    public final TFloatHashSet getUniqueValues() {
        return new TFloatHashSet(this.elementData);
    }

    public final double norm() {
        this.checkImmutable();
        return Math.sqrt(this.normSquared());
    }

    public final double normSquared() {
        this.checkImmutable();
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            d2 += (double)(this.elementData[i2] * this.elementData[i2]);
        }
        return d2;
    }

    public final void normalize(Vector vector) {
        this.checkImmutable();
        this.set(vector);
        this.normalize();
    }

    public final void normalize() {
        this.checkImmutable();
        double d2 = this.norm();
        int n = 0;
        while (n < this.elementCount) {
            int n2 = n++;
            this.elementData[n2] = (float)((double)this.elementData[n2] / d2);
        }
    }

    public final void normalizeToMeanStddev(boolean bl, boolean bl2) {
        this.checkImmutable();
        float f2 = (float)this.mean();
        float f3 = (float)this.stddev(bl, bl2);
        this.subtract(f2);
        this.divide(f3);
    }

    public final void normalizeToMeanVar(boolean bl, boolean bl2) {
        this.checkImmutable();
        float f2 = (float)this.mean();
        float f3 = (float)this.var(bl, bl2);
        this.subtract(f2);
        this.divide(f3);
    }

    public final void normalizeToMinZeroMaxOne() {
        this.checkImmutable();
        double d2 = this.max();
        double d3 = this.min();
        double d4 = d2 - d3;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.elementData[i2] = (float)(((double)this.elementData[i2] - d3) / d4);
        }
    }

    public final void normToMaxOneMinNegOne_IgnoringZeroes_seperately(boolean bl) {
        float f2;
        this.checkImmutable();
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        TFloatArrayList tFloatArrayList2 = new TFloatArrayList();
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            f2 = this.getElement(i2);
            if (bl && f2 == 0.0f) {
                tFloatArrayList.add(f2);
                tFloatArrayList2.add(f2);
            }
            if (f2 > 0.0f) {
                tFloatArrayList.add(f2);
                continue;
            }
            if (!(f2 < 0.0f)) continue;
            tFloatArrayList2.add(f2);
        }
        if (tFloatArrayList2.size() == 0) {
            float f3 = XMath.max(tFloatArrayList);
            f2 = XMath.min(tFloatArrayList);
            float f4 = f3 - f2;
            for (int i3 = 0; i3 < this.getSize(); ++i3) {
                float f5 = this.getElement(i3);
                if (f5 > 0.0f) {
                    this.setElement(i3, (f5 - f2) / f4);
                    continue;
                }
                if (f5 < 0.0f) {
                    throw new IllegalStateException();
                }
                this.setElement(i3, 0.0f);
            }
        } else if (tFloatArrayList.size() == 0) {
            float f6 = XMath.max(tFloatArrayList2);
            f2 = XMath.min(tFloatArrayList2);
            float f7 = f6 - f2;
            for (int i4 = 0; i4 < this.getSize(); ++i4) {
                float f8 = this.getElement(i4);
                if (f8 > 0.0f) {
                    throw new IllegalStateException();
                }
                if (f8 < 0.0f) {
                    float f9 = (f8 - f6) / f7;
                    this.setElement(i4, -1.0f * Math.abs(f9));
                    continue;
                }
                this.setElement(i4, 0.0f);
            }
        } else {
            float f10 = XMath.max(tFloatArrayList);
            f2 = XMath.min(tFloatArrayList);
            float f11 = XMath.max(tFloatArrayList2);
            float f12 = XMath.min(tFloatArrayList2);
            float f13 = f10 - f2;
            float f14 = f11 - f12;
            for (int i5 = 0; i5 < this.getSize(); ++i5) {
                float f15 = this.getElement(i5);
                if (f15 > 0.0f) {
                    this.setElement(i5, (f15 - f2) / f13);
                    continue;
                }
                if (f15 < 0.0f) {
                    float f16 = (f15 - f11) / f14;
                    this.setElement(i5, -1.0f * Math.abs(f16));
                    continue;
                }
                if (Float.isNaN(f15)) {
                    this.setElement(i5, Float.NaN);
                    continue;
                }
                this.setElement(i5, 0.0f);
            }
        }
    }

    public final void normToMaxOneMinNegOne_IgnoringZeroes_together() {
        float f2;
        this.checkImmutable();
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        TFloatArrayList tFloatArrayList2 = new TFloatArrayList();
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            f2 = this.getElement(i2);
            if (f2 > 0.0f) {
                tFloatArrayList.add(f2);
                continue;
            }
            if (!(f2 < 0.0f)) continue;
            tFloatArrayList2.add(f2);
        }
        if (tFloatArrayList2.size() == 0) {
            float f3 = XMath.max(tFloatArrayList);
            f2 = XMath.min(tFloatArrayList);
            float f4 = f3 - f2;
            for (int i3 = 0; i3 < this.getSize(); ++i3) {
                float f5 = this.getElement(i3);
                if (f5 > 0.0f) {
                    this.setElement(i3, (f5 - f2) / f4);
                    continue;
                }
                if (f5 < 0.0f) {
                    throw new IllegalStateException();
                }
                this.setElement(i3, 0.0f);
            }
        } else if (tFloatArrayList.size() == 0) {
            float f6 = XMath.max(tFloatArrayList2);
            f2 = XMath.min(tFloatArrayList2);
            float f7 = f6 - f2;
            for (int i4 = 0; i4 < this.getSize(); ++i4) {
                float f8 = this.getElement(i4);
                if (f8 > 0.0f) {
                    throw new IllegalStateException();
                }
                if (f8 < 0.0f) {
                    float f9 = (f8 - f6) / f7;
                    this.setElement(i4, -1.0f * Math.abs(f9));
                    continue;
                }
                this.setElement(i4, 0.0f);
            }
        } else {
            float f10 = XMath.max(tFloatArrayList);
            f2 = XMath.min(tFloatArrayList);
            float f11 = f10 - f2;
            float f12 = XMath.max(tFloatArrayList2);
            float f13 = XMath.min(tFloatArrayList2);
            float f14 = f12 - f13;
            for (int i5 = 0; i5 < this.getSize(); ++i5) {
                float f15 = this.getElement(i5);
                if (f15 > 0.0f) {
                    this.setElement(i5, (f15 - f2) / f11);
                    continue;
                }
                if (f15 < 0.0f) {
                    float f16 = (f15 - f12) / f14;
                    this.setElement(i5, -1.0f * Math.abs(f16));
                    continue;
                }
                this.setElement(i5, 0.0f);
            }
        }
    }

    public final void normalizeToMinNegOneMaxOne() {
        this.checkImmutable();
        double d2 = this.max();
        double d3 = this.min();
        double d4 = d2 - d3;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.elementData[i2] = (float)(((double)this.elementData[i2] - d3) / d4 * 2.0 - 1.0);
        }
    }

    public final void normalizeByZScore(boolean bl) {
        this.checkImmutable();
        double d2 = this.meanOrMedian(bl);
        double d3 = this.stddev(true, false);
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.elementData[i2] = (float)(((double)this.elementData[i2] - d2) / d3);
        }
    }

    public final void normalizeByZScore_mad(boolean bl) {
        this.checkImmutable();
        double d2 = this.meanOrMedian(bl);
        double d3 = this.mad(bl);
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.elementData[i2] = (float)(((double)this.elementData[i2] - d2) / d3);
            if (!Float.isInfinite(this.elementData[i2])) continue;
            this.elementData[i2] = 0.0f;
        }
    }

    public final Vector normalizeByMFC(boolean bl, float f2, float f3) {
        float[] fArray = new float[this.getSize()];
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            float f4 = this.getElement(i2);
            if (f4 < f2) {
                f4 = f2;
            }
            if (f4 > f3) {
                f4 = f3;
            }
            TFloatArrayList tFloatArrayList = new TFloatArrayList();
            for (int i3 = 0; i3 < this.getSize(); ++i3) {
                if (i2 == i3) continue;
                float f5 = this.getElement(i3);
                if (f5 < f2) {
                    f5 = f2;
                }
                if (f5 > f3) {
                    f5 = f3;
                }
                float f6 = f4 / f5;
                tFloatArrayList.add(f6);
            }
            fArray[i2] = XMath.meanmed(tFloatArrayList, bl);
        }
        return new Vector(fArray);
    }

    public final void normalizeByGsea() {
        this.checkImmutable();
        Vector vector = this.extract(ScoreMode.POS_ONLY);
        Vector vector2 = this.extract(ScoreMode.NEG_ONLY);
        float f2 = (float)vector.mean();
        float f3 = (float)vector2.mean();
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.elementData[i2] = XMath.isPositive(this.elementData[i2]) ? this.elementData[i2] / f2 : this.elementData[i2] / f3;
        }
    }

    public final float getPercentile(float f2) {
        int n = (int)((float)this.getSize() * f2);
        if (this.fSortedVectorForPercentiles == null) {
            this.fSortedVectorForPercentiles = new Vector(this);
            this.fSortedVectorForPercentiles.sort(SortMode.REAL, Order.ASCENDING);
        }
        return this.fSortedVectorForPercentiles.getElement(n);
    }

    public final void scale(float f2, Vector vector) {
        this.checkImmutable();
        this.set(vector);
        this.scale(f2);
    }

    public final void scale(float f2) {
        this.checkImmutable();
        int n = 0;
        while (n < this.elementCount) {
            int n2 = n++;
            this.elementData[n2] = this.elementData[n2] * f2;
        }
    }

    public final void scaleSum(float f2, Vector vector, Vector vector2) {
        this.checkImmutable();
        float[] fArray = vector.elementData;
        float[] fArray2 = vector2.elementData;
        if (this.elementCount != vector.elementCount) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.elementCount + " != v1's size:" + vector.elementCount);
        }
        if (this.elementCount != vector2.elementCount) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.elementCount + " != v2's size:" + vector2.elementCount);
        }
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.elementData[i2] = f2 * fArray[i2] + fArray2[i2];
        }
    }

    public final void sum(Vector vector) {
        this.checkImmutable();
        float[] fArray = vector.elementData;
        if (this.elementCount != vector.elementCount) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.elementCount + " != v2's size:" + vector.elementCount);
        }
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            int n = i2;
            this.elementData[n] = this.elementData[n] + fArray[i2];
        }
    }

    public final void sumNanSafe(Vector vector) {
        this.checkImmutable();
        float[] fArray = vector.elementData;
        if (this.elementCount != vector.elementCount) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.elementCount + " != v2's size:" + vector.elementCount);
        }
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            if (Float.isNaN(fArray[i2])) continue;
            if (Float.isNaN(this.elementData[i2])) {
                this.elementData[i2] = fArray[i2];
                continue;
            }
            int n = i2;
            this.elementData[n] = this.elementData[n] + fArray[i2];
        }
    }

    public final void divide(float f2) {
        this.checkImmutable();
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.elementData[i2] = this.elementData[i2] / f2;
        }
    }

    public final void multiply(float f2) {
        this.checkImmutable();
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.elementData[i2] = this.elementData[i2] * f2;
        }
    }

    public final void divide(Vector vector) {
        this.checkImmutable();
        Vector.enforceEqualSize(new Vector[]{this, vector}, true);
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.elementData[i2] = this.elementData[i2] / vector.elementData[i2];
        }
    }

    public final void amplitude(Vector vector) {
        this.checkImmutable();
        Vector.enforceEqualSize(new Vector[]{this, vector}, true);
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            float f2 = this.elementData[i2] - vector.elementData[i2];
            float f3 = (this.elementData[i2] + vector.elementData[i2]) / 2.0f;
            this.elementData[i2] = f2 / f3;
        }
    }

    public final void subtract(float f2) {
        this.checkImmutable();
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.elementData[i2] = this.elementData[i2] - f2;
        }
    }

    public final void add(float f2) {
        this.checkImmutable();
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.elementData[i2] = this.elementData[i2] + f2;
        }
    }

    public final void sum(Vector vector, Vector vector2) {
        this.checkImmutable();
        this.set(vector);
        this.sum(vector2);
    }

    public final double sumprod(Vector vector) {
        if (this.getSize() != vector.getSize()) {
            throw new RuntimeException("Unequal vector sizes x: " + this.getSize() + " y: " + vector.getSize());
        }
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            d2 += (double)(this.getElement(i2) * vector.getElement(i2));
        }
        return d2;
    }

    public final void negate() {
        this.checkImmutable();
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.elementData[i2] = -this.elementData[i2];
        }
    }

    public final void zero() {
        this.checkImmutable();
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.elementData[i2] = 0.0f;
        }
    }

    public final void truncate(int n) {
        this.checkImmutable();
        if (n == this.elementCount) {
            return;
        }
        if (n > this.getSize()) {
            throw new IllegalArgumentException("Truncated size: " + n + " cannot be more than current size: " + this.getSize());
        }
        float[] fArray = this.elementData;
        this.elementData = new float[n];
        System.arraycopy(fArray, 0, this.elementData, 0, n);
        this.elementCount = n;
    }

    public final void sort() {
        this.checkImmutable();
        Arrays.sort(this.elementData);
    }

    public final void revsort() {
        this.checkImmutable();
        Arrays.sort(this.elementData);
        this.reverse();
    }

    public final void abssort() {
        this.abs();
        this.sort();
    }

    public final void abs() {
        this.checkImmutable();
        for (int i2 = 0; i2 < this.elementData.length; ++i2) {
            this.elementData[i2] = Math.abs(this.elementData[i2]);
        }
    }

    public final void sort(SortMode sortMode, Order order) {
        this.checkImmutable();
        if (sortMode.isAbsolute()) {
            this.abs();
        }
        if (order.isAscending()) {
            this.sort();
        } else {
            this.revsort();
        }
    }

    public final Vector removeValues(float f2) {
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            float f3 = this.getElement(i2);
            if (f3 == f2) continue;
            tFloatArrayList.add(f3);
        }
        return new Vector(tFloatArrayList);
    }

    public final void replaceValues(float f2, float f3) {
        this.checkImmutable();
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            float f4 = this.getElement(i2);
            if (Float.isNaN(f4) && Float.isNaN(f2)) {
                this.setElement(i2, f3);
            }
            if (f4 != f2) continue;
            this.setElement(i2, f3);
        }
    }

    public final void reverse() {
        this.checkImmutable();
        float[] fArray = new float[this.elementData.length];
        int n = this.elementCount - 1;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            fArray[n - i2] = this.elementData[i2];
        }
        this.elementData = fArray;
    }

    public static final DoubleElement[] toDoubleElements(Vector vector) {
        DoubleElement[] doubleElementArray = new DoubleElement[vector.getSize()];
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            doubleElementArray[i2] = new DoubleElement(i2, vector.getElement(i2));
        }
        return doubleElementArray;
    }

    public static final AddressedVector toIndexedVector(Vector vector) {
        return new AddressedVector(vector, false);
    }

    public final int[] toRanks(SortMode sortMode, Order order, boolean bl) {
        int n = 0;
        if (bl) {
            n = 1;
        }
        DoubleElement[] doubleElementArray = Vector._sort(new AddressedVector(this, true), sortMode, order);
        int[] nArray = new int[this.getSize()];
        for (int i2 = 0; i2 < doubleElementArray.length; ++i2) {
            nArray[i2] = doubleElementArray[i2].fIndex + n;
        }
        return nArray;
    }

    public final Vector toRanksV(SortMode sortMode, Order order, boolean bl) {
        return new Vector(this.toRanks(sortMode, order, bl));
    }

    private static DoubleElement[] _sort(AddressedVector addressedVector, SortMode sortMode, Order order) {
        DoubleElement[] doubleElementArray = new DoubleElement[addressedVector.getSize()];
        for (int i2 = 0; i2 < addressedVector.getSize(); ++i2) {
            doubleElementArray[i2] = new DoubleElement(addressedVector.getAddress(i2), addressedVector.getScore(i2));
        }
        return DoubleElement.sort(sortMode, order, doubleElementArray);
    }

    public final void set(double[] dArray) {
        this.checkImmutable();
        System.arraycopy(dArray, 0, this.elementData, 0, this.elementCount);
    }

    public final void setDirectly(float[] fArray) {
        this.checkImmutable();
        this.elementData = fArray;
        this.elementCount = fArray.length;
    }

    public final void set(Vector vector) {
        this.checkImmutable();
        System.arraycopy(vector.elementData, 0, this.elementData, 0, this.elementCount);
    }

    public final int getSize() {
        return this.elementCount;
    }

    public final int getSize(ScoreMode scoreMode) {
        if (scoreMode.isPostiveAndNegTogether()) {
            return this.getSize();
        }
        if (scoreMode.isPostiveAndNegSeperately()) {
            throw new IllegalArgumentException("Not a valid scoee mode");
        }
        if (scoreMode.isPostiveOnly()) {
            int n = 0;
            for (int i2 = 0; i2 < this.getSize(); ++i2) {
                if (!XMath.isPositive(this.getElement(i2))) continue;
                ++n;
            }
            return n;
        }
        if (scoreMode.isNegativeOnly()) {
            int n = 0;
            for (int i3 = 0; i3 < this.getSize(); ++i3) {
                if (!XMath.isNegative(this.getElement(i3))) continue;
                ++n;
            }
            return n;
        }
        throw new IllegalArgumentException("Unknown score mode: " + scoreMode);
    }

    public final int getSizeNanSafe() {
        int n = 0;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            if (Float.isNaN(this.elementData[i2])) continue;
            ++n;
        }
        return n;
    }

    public final float getElement(int n) {
        try {
            return this.elementData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("index:" + n + " must be in [0, " + (this.elementCount - 1) + "]");
        }
    }

    public final void setElement(int n, float f2) {
        this.checkImmutable();
        try {
            this.elementData[n] = f2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("index:" + n + " must be in [0, " + (this.elementCount - 1) + "]");
        }
    }

    public final void setElement(int n, double d2) {
        this.setElement(n, (float)d2);
    }

    public final String[] toStrings() {
        String[] stringArray = new String[this.getSize()];
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            stringArray[i2] = this.getElement(i2) + "";
        }
        return stringArray;
    }

    public final String toString() {
        if (this.getSize() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int i2 = 0; i2 < this.elementCount - 1; ++i2) {
            stringBuffer.append(this.elementData[i2]);
            stringBuffer.append(",");
        }
        stringBuffer.append(this.elementData[this.elementCount - 1]);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public final String toString(char c2) {
        if (this.getSize() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.elementCount - 1; ++i2) {
            if (!Float.isNaN(this.elementData[i2])) {
                stringBuffer.append(this.elementData[i2]);
            }
            stringBuffer.append(c2);
        }
        if (!Float.isNaN(this.elementData[this.elementCount - 1])) {
            stringBuffer.append(this.elementData[this.elementCount - 1]);
        } else {
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public final String toString(char c2, int n) {
        if (this.getSize() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.elementCount - 1; ++i2) {
            if (!Float.isNaN(this.elementData[i2])) {
                stringBuffer.append(Printf.format(this.elementData[i2], n));
            }
            stringBuffer.append(c2);
        }
        if (!Float.isNaN(this.elementData[this.elementCount - 1])) {
            stringBuffer.append(Printf.format(this.elementData[this.elementCount - 1], n));
        } else {
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public final java.util.Vector toUtilVector() {
        java.util.Vector<Float> vector = new java.util.Vector<Float>(this.getSize());
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            vector.add(new Float(this.elementData[i2]));
        }
        return vector;
    }

    public final float[] toArray() {
        float[] fArray = new float[this.elementData.length];
        System.arraycopy(this.elementData, 0, fArray, 0, this.elementData.length);
        return fArray;
    }

    public final double[] toArrayDouble() {
        double[] dArray = new double[this.elementData.length];
        for (int i2 = 0; i2 < this.elementData.length; ++i2) {
            dArray[i2] = this.elementData[i2];
        }
        return dArray;
    }

    public final int[] toArrayInt() {
        int[] nArray = new int[this.elementData.length];
        for (int i2 = 0; i2 < this.elementData.length; ++i2) {
            nArray[i2] = (int)this.elementData[i2];
        }
        return nArray;
    }

    public final Vector toPositiveOnlyElementsV() {
        return new Vector(this.toPositiveOnlyElements());
    }

    public final TFloatArrayList toPositiveOnlyElements() {
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        for (int i2 = 0; i2 < this.elementData.length; ++i2) {
            if (!XMath.isPositive(this.elementData[i2])) continue;
            tFloatArrayList.add(this.elementData[i2]);
        }
        return tFloatArrayList;
    }

    public final Vector toNegativeOnlyElementsV() {
        return new Vector(this.toNegativeOnlyElements());
    }

    public final TFloatArrayList toNegativeOnlyElements() {
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        for (int i2 = 0; i2 < this.elementData.length; ++i2) {
            if (!XMath.isPositive(this.elementData[i2])) continue;
            tFloatArrayList.add(this.elementData[i2]);
        }
        return tFloatArrayList;
    }

    public final int hashCode() {
        int n = 0;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            long l2 = Double.doubleToLongBits(this.elementData[i2]);
            n ^= (int)(l2 ^ l2 >> 32);
        }
        return n;
    }

    public final boolean equals(Vector vector) {
        if (vector == null) {
            return false;
        }
        if (this.elementCount != vector.elementCount) {
            return false;
        }
        float[] fArray = vector.elementData;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            if (this.elementData[i2] == fArray[i2]) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(Object object) {
        return object != null && object instanceof Vector && this.equals((Vector)object);
    }

    public final boolean epsilonEquals(Vector vector, double d2) {
        if (this.elementCount != vector.elementCount) {
            return false;
        }
        float[] fArray = vector.elementData;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            if (!((double)Math.abs(this.elementData[i2] - fArray[i2]) > d2)) continue;
            return false;
        }
        return true;
    }

    public final double dot(Vector vector) {
        float[] fArray = vector.elementData;
        if (this.elementCount != vector.elementCount) {
            throw new IllegalArgumentException("this.size:" + this.elementCount + " != v1.size:" + vector.elementCount);
        }
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            d2 += (double)(this.elementData[i2] * fArray[i2]);
        }
        return d2;
    }

    public final double angle(Vector vector) {
        return Math.acos(this.dot(vector) / this.norm() / vector.norm());
    }

    public final void interpolate(Vector vector, float f2) {
        float[] fArray = vector.elementData;
        if (this.elementCount != vector.elementCount) {
            throw new IllegalArgumentException("this.size:" + this.elementCount + " != v1.size:" + vector.elementCount);
        }
        float f3 = (float)(1.0 - (double)f2);
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.elementData[i2] = f3 * this.elementData[i2] + f2 * fArray[i2];
        }
    }

    public final void bin(Range[] rangeArray, boolean bl) {
        int n;
        int n2 = 0;
        for (n = 0; n < this.getSize(); ++n) {
            boolean bl2 = false;
            for (int i2 = 0; i2 < rangeArray.length; ++i2) {
                if (!rangeArray[i2].isInRange(this.elementData[n])) continue;
                rangeArray[i2].increment();
                bl2 = true;
                ++n2;
                break;
            }
            if (!bl || bl2) continue;
            throw new RuntimeException("Value was not binned as it didnt fall in any of the Ranges: " + this.elementData[n]);
        }
        n = n2;
        if (bl && n != this.elementData.length) {
            throw new IllegalStateException("Bad binning! Binned: " + n + " but elements in Vector: " + this.elementData.length);
        }
    }

    public static final Map floats2VectorMap(Map map) {
        HashMap<String, Vector> hashMap = new HashMap<String, Vector>(map.size());
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            TFloatArrayList tFloatArrayList = (TFloatArrayList)map.get(string);
            hashMap.put(string, new Vector(tFloatArrayList));
        }
        if (hashMap.size() != map.size()) {
            throw new IllegalStateException("Wierdly corr output map has diff size: " + hashMap.size() + " than input map: " + map.size());
        }
        return hashMap;
    }

    public final void pnormalize() {
        this.checkImmutable();
        float f2 = -1.0f;
        float f3 = this.min();
        float f4 = this.max();
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.elementData[i2] = f2 + (this.elementData[i2] - f3) / (f4 - f3) * 2.0f;
        }
    }

    public static final Vector mean(Vector[] vectorArray) {
        Vector.enforceEqualSize(vectorArray, true);
        int n = vectorArray[0].getSize();
        Vector vector = new Vector(n);
        for (int i2 = 0; i2 < n; ++i2) {
            float[] fArray = new float[vectorArray.length];
            for (int i3 = 0; i3 < vectorArray.length; ++i3) {
                fArray[i3] = vectorArray[i3].getElement(i2);
            }
            vector.setElement(i2, XMath.mean(fArray));
        }
        return vector;
    }

    public static final Vector max(Vector[] vectorArray) {
        Vector.enforceEqualSize(vectorArray, true);
        int n = vectorArray[0].getSize();
        Vector vector = new Vector(n);
        for (int i2 = 0; i2 < n; ++i2) {
            float[] fArray = new float[vectorArray.length];
            for (int i3 = 0; i3 < vectorArray.length; ++i3) {
                fArray[i3] = vectorArray[i3].getElement(i2);
            }
            vector.setElement(i2, XMath.max(fArray));
        }
        return vector;
    }

    public static final Vector median(Vector[] vectorArray) {
        Vector.enforceEqualSize(vectorArray, true);
        int n = vectorArray[0].getSize();
        Vector vector = new Vector(n);
        for (int i2 = 0; i2 < n; ++i2) {
            float[] fArray = new float[vectorArray.length];
            for (int i3 = 0; i3 < vectorArray.length; ++i3) {
                fArray[i3] = vectorArray[i3].getElement(i2);
            }
            vector.setElement(i2, XMath.median(fArray));
        }
        return vector;
    }

    public static final String getSummaryStatistics(Vector[] vectorArray) {
        StringBuffer stringBuffer = new StringBuffer("Number of Vectors : ").append(vectorArray.length).append('\n');
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        for (int i2 = 0; i2 < vectorArray.length; ++i2) {
            if (d2 > (double)vectorArray[i2].min()) {
                d2 = vectorArray[i2].computeset.min;
            }
            if (!(d3 < (double)vectorArray[i2].max())) continue;
            d3 = vectorArray[i2].computeset.max;
        }
        stringBuffer.append("Absolute min: ").append(d2).append('\n');
        stringBuffer.append("Absolute max: ").append(d3).append('\n');
        return stringBuffer.toString();
    }

    public static final int maxSize(Vector[] vectorArray) {
        int n = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < vectorArray.length; ++i2) {
            if (n >= vectorArray[i2].getSize()) continue;
            n = vectorArray[i2].getSize();
        }
        return n;
    }

    public static final int minSize(Vector[] vectorArray) {
        int n = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < vectorArray.length; ++i2) {
            if (n <= vectorArray[i2].getSize()) continue;
            n = vectorArray[i2].getSize();
        }
        return n;
    }

    public static final Vector multiply(Vector vector, Vector vector2) {
        Vector.enforceEqualSize(new Vector[]{vector, vector2}, true);
        Vector vector3 = new Vector(vector.getSize());
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            vector3.setElement(i2, vector.getElement(i2) * vector2.getElement(i2));
        }
        return vector3;
    }

    public static final Vector multiply(Vector vector, Vector vector2, Vector vector3) {
        Vector.enforceEqualSize(new Vector[]{vector, vector2, vector3}, true);
        Vector vector4 = new Vector(vector.getSize());
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            vector4.setElement(i2, vector.getElement(i2) * vector2.getElement(i2) * vector3.getElement(i2));
        }
        return vector4;
    }

    public final void setImmutable() {
        this.fImmuted = true;
    }

    public final boolean isImmutable() {
        return this.fImmuted;
    }

    private void checkImmutable() {
        if (this.fImmuted) {
            throw new ImmutedException();
        }
    }

    public final boolean isNanOrZero() {
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            if (this.getElement(i2) == 0.0f && Float.isNaN(this.getElement(i2))) continue;
            return false;
        }
        return true;
    }

    public final Vector extract(int[] nArray, boolean bl) {
        if (bl) {
            float[] fArray = new float[nArray.length];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                fArray[i2] = this.getElement(nArray[i2]);
            }
            return new Vector(fArray, true);
        }
        TIntArrayList tIntArrayList = new TIntArrayList(nArray);
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        for (int i3 = 0; i3 < this.getSize(); ++i3) {
            if (tIntArrayList.contains(i3)) continue;
            tFloatArrayList.add(this.getElement(i3));
        }
        return new Vector(tFloatArrayList);
    }

    public final Vector extract(float f2, ScoreMode scoreMode) {
        if (scoreMode.isPostiveAndNegSeperately()) {
            if (XMath.isPositive(f2)) {
                return this.extract(ScoreMode.POS_ONLY);
            }
            return this.extract(ScoreMode.NEG_ONLY);
        }
        return this.extract(scoreMode);
    }

    public final Vector extract(ScoreMode scoreMode) {
        TFloatArrayList tFloatArrayList;
        if (scoreMode.isPostiveAndNegTogether()) {
            return this;
        }
        if (scoreMode.isPostiveOnly()) {
            tFloatArrayList = new TFloatArrayList();
            for (int i2 = 0; i2 < this.getSize(); ++i2) {
                float f2 = this.getElement(i2);
                if (!XMath.isPositive(f2)) continue;
                tFloatArrayList.add(f2);
            }
        } else if (scoreMode.isNegativeOnly()) {
            tFloatArrayList = new TFloatArrayList();
            for (int i3 = 0; i3 < this.getSize(); ++i3) {
                float f3 = this.getElement(i3);
                if (!XMath.isNegative(f3)) continue;
                tFloatArrayList.add(f3);
            }
        } else {
            throw new IllegalArgumentException("Unknown smode: " + scoreMode.getName());
        }
        return new Vector(tFloatArrayList.toNativeArray(), true);
    }
}

