/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.utils.containers.ClassNamePair;

public class Orientation {
    public static final Orientation ROW = new Orientation("By Row");
    public static final Orientation COL = new Orientation("By Col");
    public static final Orientation[] ALL = new Orientation[]{ROW, COL};
    public static final ClassNamePair[] ALL_CNP = new ClassNamePair[]{new ClassNamePair(ROW.getClass(), Orientation.ROW.fType), new ClassNamePair(COL.getClass(), Orientation.COL.fType)};
    private final String fType;

    private Orientation(String string) {
        this.fType = string;
    }

    public final String toString() {
        return this.fType;
    }

    public final boolean isByRow() {
        return this.equals(ROW);
    }

    public final boolean isByCol() {
        return this.equals(COL);
    }

    public final boolean equals(Object object) {
        return object instanceof Orientation && ((Orientation)object).fType.equals(this.fType);
    }

    public final int hashCode() {
        return this.fType.hashCode();
    }

    public static final Orientation lookup(Object object) {
        if (object == null) {
            throw new NullPointerException("Null mode cabbot be looked up");
        }
        if (object instanceof Orientation) {
            return (Orientation)object;
        }
        String string = object.toString();
        if (string.equalsIgnoreCase(Orientation.ROW.fType)) {
            return ROW;
        }
        if (string.equalsIgnoreCase(COL.toString())) {
            return COL;
        }
        throw new IllegalArgumentException("Unable to lookup Orientation: " + object);
    }
}

