/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.math.IMatrix;
import edu.mit.broad.genome.utils.ImmutedException;
import org.apache.log4j.Logger;

public class ObjectMatrix
implements IMatrix {
    private Object[] elementData;
    private int fRowCnt;
    private int fColCnt;
    private boolean fImmuted;
    private static final transient Logger klog = XLogger.getLogger(ObjectMatrix.class);

    public ObjectMatrix() {
    }

    public ObjectMatrix(int n, int n2) {
        if (n < 0) {
            throw new NegativeArraySizeException(n + " < 0");
        }
        if (n2 < 0) {
            throw new NegativeArraySizeException(n2 + " < 0");
        }
        this.fRowCnt = n;
        this.fColCnt = n2;
        this.elementData = new Object[this.fRowCnt * this.fColCnt];
    }

    public ObjectMatrix(ObjectMatrix objectMatrix, boolean bl) {
        this.fRowCnt = objectMatrix.fRowCnt;
        this.fColCnt = objectMatrix.fColCnt;
        this.fImmuted = objectMatrix.fImmuted;
        this.fImmuted = bl ? objectMatrix.fImmuted : false;
        if (bl) {
            this.elementData = objectMatrix.elementData;
        } else {
            int n = this.fRowCnt * this.fColCnt;
            this.elementData = new String[n];
            System.arraycopy(objectMatrix.elementData, 0, this.elementData, 0, n);
        }
    }

    public final ObjectMatrix cloneDeep() {
        klog.debug("Making cloneDeep of ObjectMatrix");
        return new ObjectMatrix(this, false);
    }

    @Override
    public final int getNumRow() {
        return this.fRowCnt;
    }

    @Override
    public final int getDim() {
        return this.getNumRow() * this.getNumCol();
    }

    @Override
    public final int getNumCol() {
        return this.fColCnt;
    }

    public final Object getElement(int n, int n2) {
        if (this.fRowCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " > matrix's fRowCnt:" + this.fRowCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " < 0");
        }
        if (this.fColCnt <= n2) {
            throw new ArrayIndexOutOfBoundsException("column:" + n2 + " > matrix's fColCnt:" + this.fColCnt);
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("column:" + n2 + " < 0");
        }
        return this.elementData[n * this.fColCnt + n2];
    }

    public final void setElement(int n, int n2, Object object) {
        this.checkImmutable();
        if (this.fRowCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " > matrix's fRowCnt:" + this.fRowCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " < 0");
        }
        if (this.fColCnt <= n2) {
            throw new ArrayIndexOutOfBoundsException("column:" + n2 + " <= matrix's fColCnt:" + this.fColCnt);
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("column:" + n2 + " < 0");
        }
        this.elementData[n * this.fColCnt + n2] = object;
    }

    public final void setRow(int n, Object[] objectArray) {
        this.checkImmutable();
        if (this.fRowCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("row: " + n + " > matrix's fRowCnt: " + this.fRowCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("row: " + n + " < 0");
        }
        if (objectArray.length < this.fColCnt) {
            throw new ArrayIndexOutOfBoundsException("specified array length: " + objectArray.length + " < matrix's fColCnt: " + this.fColCnt);
        }
        System.arraycopy(objectArray, 0, this.elementData, n * this.fColCnt, this.fColCnt);
    }

    public final void setColumn(int n, Object[] objectArray) {
        this.checkImmutable();
        if (this.fColCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " > matrix's fColCnt=" + this.fColCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " < 0");
        }
        if (objectArray.length < this.fRowCnt) {
            throw new ArrayIndexOutOfBoundsException("array length:" + objectArray.length + " < matrix's fRowCnt:" + this.fRowCnt);
        }
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            this.elementData[i2 * this.fColCnt + n] = objectArray[i2];
        }
    }

    public final Object[] getColumn(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " < 0");
        }
        Object[] objectArray = new Object[this.fRowCnt];
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            objectArray[i2] = this.elementData[i2 * this.fColCnt + n];
        }
        return objectArray;
    }

    public final Object[] getRow(int n) {
        if (this.fRowCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " > matrix's fRowCnt:" + this.fRowCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " < 0");
        }
        Object[] objectArray = new Object[this.fColCnt];
        System.arraycopy(this.elementData, n * this.fColCnt, objectArray, 0, this.fColCnt);
        return objectArray;
    }

    public final int hashCode() {
        int n = 0;
        for (int i2 = 0; i2 < this.fRowCnt * this.fColCnt; ++i2) {
            long l2 = this.elementData[i2].hashCode();
            n ^= (int)(l2 ^ l2 >> 32);
        }
        return n;
    }

    public final void setImmutable() {
        this.fImmuted = true;
    }

    public final boolean isImmutable() {
        return this.fImmuted;
    }

    private void checkImmutable() {
        if (this.fImmuted) {
            throw new ImmutedException();
        }
    }
}

