/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.utils.containers.ClassNamePair;

public class GraphMode {
    public static final GraphMode LINEAR = new GraphMode("Linear");
    public static final GraphMode LOG = new GraphMode("Log");
    public static final GraphMode[] ALL = new GraphMode[]{LINEAR, LOG};
    public static final ClassNamePair[] ALL_CNP = new ClassNamePair[]{new ClassNamePair(LINEAR.getClass(), GraphMode.LINEAR.fType), new ClassNamePair(LOG.getClass(), GraphMode.LOG.fType)};
    private final String fType;

    private GraphMode(String string) {
        this.fType = string;
    }

    public final String toString() {
        return this.fType;
    }

    public final boolean isLinear() {
        return this.fType.equalsIgnoreCase(GraphMode.LINEAR.fType);
    }

    public final boolean IsLog() {
        return this.fType.equalsIgnoreCase(GraphMode.LOG.fType);
    }

    public final boolean equals(Object object) {
        return object instanceof GraphMode && ((GraphMode)object).fType.equals(this.fType);
    }

    public final int hashCode() {
        return this.fType.hashCode();
    }

    public static final GraphMode lookup(Object object) {
        if (object == null) {
            throw new NullPointerException("Null dir not allowed");
        }
        if (object instanceof GraphMode) {
            return (GraphMode)object;
        }
        if (object instanceof String) {
            if (object.toString().equalsIgnoreCase(GraphMode.LINEAR.fType)) {
                return LINEAR;
            }
            if (object.toString().equalsIgnoreCase(GraphMode.LOG.fType)) {
                return LOG;
            }
        }
        throw new IllegalArgumentException("Unable to lookup GraphMode String: " + object);
    }
}

