/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.utils.ImmutedException;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class FrequencyMap {
    private TObjectIntHashMap fElementInstanceCounter = new TObjectIntHashMap();
    private String fName;
    private boolean fImmutable;
    private LabelledVector lv;

    public FrequencyMap(String string) {
        this.fName = string;
        this.fImmutable = false;
    }

    public final String getName() {
        return this.fName;
    }

    public final void setImmutable() {
        this.fImmutable = true;
    }

    private void ensureMutable() {
        if (this.fImmutable) {
            throw new ImmutedException();
        }
    }

    public final void add(Object object) {
        this.ensureMutable();
        int n = 0;
        if (this.fElementInstanceCounter.containsKey(object)) {
            n = this.fElementInstanceCounter.get(object);
        }
        this.fElementInstanceCounter.put(object, ++n);
    }

    public final void addAll(Collection collection) {
        this.ensureMutable();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public final void addAll(Object[] objectArray) {
        this.ensureMutable();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            this.add(objectArray[i2]);
        }
    }

    public final Set getElements(int n) {
        HashSet<Object> hashSet = new HashSet<Object>();
        TObjectIntIterator tObjectIntIterator = this.fElementInstanceCounter.iterator();
        int n2 = this.fElementInstanceCounter.size();
        while (n2-- > 0) {
            tObjectIntIterator.advance();
            if (tObjectIntIterator.value() < n) continue;
            hashSet.add(tObjectIntIterator.key());
        }
        return hashSet;
    }

    public final Object[] getElementsArray(int n) {
        Set set = this.getElements(n);
        return set.toArray(new Object[set.size()]);
    }

    public final LabelledVector toLabelledVector() {
        if (this.lv == null) {
            Object[] objectArray = this.getElementsArray();
            ArrayList<String> arrayList = new ArrayList<String>(objectArray.length);
            Vector vector = new Vector(objectArray.length);
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                vector.setElement(i2, this.getFrequency(objectArray[i2]));
                arrayList.add(objectArray[i2].toString());
            }
            this.lv = new LabelledVector(arrayList, vector, true);
        }
        return this.lv;
    }

    public final int getSize() {
        return this.fElementInstanceCounter.size();
    }

    public final Object[] getElementsArray() {
        return this.fElementInstanceCounter.keys();
    }

    public final Set getElements() {
        HashSet<Object> hashSet = new HashSet<Object>();
        Object[] objectArray = this.getElementsArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            hashSet.add(objectArray[i2]);
        }
        if (hashSet.size() != objectArray.length) {
            throw new IllegalStateException("Wierd duplicate keys");
        }
        return hashSet;
    }

    public final int getFrequency(Object object) {
        if (!this.fElementInstanceCounter.containsKey(object)) {
            throw new IllegalArgumentException("No such key: " + object);
        }
        return this.fElementInstanceCounter.get(object);
    }
}

