/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.Dataset;
import gnu.trove.TIntObjectHashMap;

public class DatasetModed {
    private Dataset fOrigDataset;
    private TIntObjectHashMap fColIndexExtractedVectorMap;
    private ScoreMode fScoreMode;
    private SortMode fSort;
    private Order fOrder;

    public DatasetModed(Dataset dataset, ScoreMode scoreMode, SortMode sortMode, Order order) {
        if (dataset == null) {
            throw new IllegalArgumentException("Param orig cannot be null");
        }
        if (scoreMode == null) {
            throw new IllegalArgumentException("Param smode cannot be null");
        }
        this.fOrigDataset = dataset;
        this.fScoreMode = scoreMode;
        this.fColIndexExtractedVectorMap = new TIntObjectHashMap();
        this.fSort = sortMode;
        this.fOrder = order;
    }

    public final int getNumRow(int n) {
        return this.getColumn_sorted(n).getSize();
    }

    public final int getNumCol() {
        return this.fOrigDataset.getNumCol();
    }

    public final int getDim_orig() {
        return this.fOrigDataset.getDim();
    }

    public final Vector getColumn_sorted(int n) {
        Object object = this.fColIndexExtractedVectorMap.get(n);
        if (object == null) {
            Vector vector = this.fOrigDataset.getColumn(n);
            vector = vector.extract(this.fScoreMode);
            vector.sort(this.fSort, this.fOrder);
            object = vector;
            this.fColIndexExtractedVectorMap.put(n, vector);
        }
        return (Vector)object;
    }
}

