/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.math.DoubleElement;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.utils.ArrayUtils;
import gnu.trove.TFloatArrayList;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.util.List;

public class AddressedVector {
    private int[] fAddresses;
    private Vector fVector;

    public AddressedVector(Vector vector, int[] nArray, boolean bl) {
        if (vector == null) {
            throw new IllegalArgumentException("Param v cannot be null");
        }
        if (nArray == null) {
            throw new IllegalArgumentException("Parameter addresses cannot be null");
        }
        if (bl) {
            this.init(vector, nArray);
        } else {
            Vector vector2 = new Vector(vector);
            int[] nArray2 = new int[nArray.length];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            this.init(vector2, nArray2);
        }
    }

    public AddressedVector(TFloatArrayList tFloatArrayList, TIntArrayList tIntArrayList) {
        if (tFloatArrayList == null) {
            throw new IllegalArgumentException("Param scores cannot be null");
        }
        if (tIntArrayList == null) {
            throw new IllegalArgumentException("Parameter addresses cannot be null");
        }
        this.init(new Vector(tFloatArrayList), tIntArrayList.toNativeArray());
    }

    public AddressedVector(AddressedVector addressedVector, boolean bl) {
        this(addressedVector.fVector, addressedVector.fAddresses, bl);
    }

    public AddressedVector(Vector vector, boolean bl) {
        this(vector, ArrayUtils.rangeAsElements(0, AddressedVector._max(vector)), bl);
    }

    private static int _max(Vector vector) {
        int n = vector.getSize() - 1;
        if (vector.getSize() == 0) {
            n = 0;
        }
        return n;
    }

    public AddressedVector(RankedList rankedList, Dataset dataset) {
        Vector vector = new Vector(rankedList.getSize());
        int[] nArray = new int[rankedList.getSize()];
        for (int i2 = 0; i2 < rankedList.getSize(); ++i2) {
            vector.setElement(i2, rankedList.getScore(i2));
            nArray[i2] = dataset.getRowIndex(rankedList.getRankName(i2));
        }
        this.init(vector, nArray);
    }

    public AddressedVector(int n, AddressedVector addressedVector) {
        Vector vector = new Vector(n, addressedVector.fVector);
        int[] nArray = new int[n];
        System.arraycopy(addressedVector.fAddresses, 0, nArray, 0, n);
        this.init(vector, nArray);
    }

    public AddressedVector(List list) {
        if (list == null) {
            throw new IllegalArgumentException("Param listWithDoubleElements cannot be null");
        }
        Vector vector = new Vector(DoubleElement.valueArray(list));
        int[] nArray = DoubleElement.indexArray(list);
        this.init(vector, nArray);
    }

    public AddressedVector(DoubleElement[] doubleElementArray) {
        if (doubleElementArray == null) {
            throw new IllegalArgumentException("Param dels cannot be null");
        }
        Vector vector = new Vector(DoubleElement.valueArray(doubleElementArray));
        int[] nArray = DoubleElement.indexArray(doubleElementArray);
        this.init(vector, nArray);
    }

    private void init(Vector vector, int[] nArray) {
        if (vector == null) {
            throw new IllegalArgumentException("Parameter v cannot be null");
        }
        if (nArray == null) {
            throw new IllegalArgumentException("Parameter addresses cannot be null");
        }
        if (vector.getSize() != nArray.length) {
            throw new MismatchedSizeException("Unequal lengths - Vector", vector.getSize(), "Index addresses", nArray.length);
        }
        this.fVector = vector;
        this.fAddresses = nArray;
        this.fVector.setImmutable();
    }

    public final int[] getAddresses() {
        int[] nArray = new int[this.fAddresses.length];
        System.arraycopy(this.fAddresses, 0, nArray, 0, this.fAddresses.length);
        return nArray;
    }

    public final int getAddress(int n) {
        return this.fAddresses[n];
    }

    public final float getScore(int n) {
        return this.fVector.getElement(n);
    }

    public final float[] getScoresArray() {
        return this.fVector.toArray();
    }

    public final Vector getScoresV(boolean bl) {
        return new Vector(this.fVector, bl);
    }

    public final int getSize() {
        return this.fVector.getSize();
    }

    public final TIntHashSet toAddressesSet() {
        TIntHashSet tIntHashSet = new TIntHashSet(this.fAddresses.length);
        tIntHashSet.addAll(this.fAddresses);
        if (tIntHashSet.size() != this.fAddresses.length) {
            throw new IllegalStateException("Addresses NOT unique! # of addresses: " + this.fAddresses.length + " not preserved after hashing set size: " + tIntHashSet.size());
        }
        return tIntHashSet;
    }
}

