/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.markers;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.alg.DatasetMetrics;
import edu.mit.broad.genome.alg.DatasetMetrics$ScoredStruc;
import edu.mit.broad.genome.alg.DatasetStatsCore;
import edu.mit.broad.genome.alg.DatasetStatsCore$TwoClassMarkerStats;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.Metrics$Signal2Noise;
import edu.mit.broad.genome.alg.RankedListGenerators;
import edu.mit.broad.genome.alg.markers.AbstractPermutationTest;
import edu.mit.broad.genome.math.LabelledVectorProcessor;
import edu.mit.broad.genome.math.LabelledVectorProcessors$None;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.RandomSeedGenerator;
import edu.mit.broad.genome.math.RandomSeedGenerators$Timestamp;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.MetricWeightStruc;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateFactoryRandomizer;
import edu.mit.broad.genome.objects.strucs.TemplateRandomizerType;
import gnu.trove.TIntArrayList;
import java.util.Map;

public class PermutationTestImpl
extends AbstractPermutationTest {
    private Template[] fRndTemplates;
    private ScoredDataset fRealScoredDataset;
    private Matrix fRndFullMatrix;
    private Map fMarkerScores;
    private TIntArrayList fMetricCrossOverRanks;
    private MetricWeightStruc[] fRndMetricWeightStrucs;
    private RankedList fRealRankedList;

    public PermutationTestImpl(int n, int n2, LabelledVectorProcessor labelledVectorProcessor, Metric metric, SortMode sortMode, Order order, Map map, Dataset dataset, Template template, float[] fArray, RandomSeedGenerator randomSeedGenerator, TemplateRandomizerType templateRandomizerType, boolean bl, boolean bl2) {
        this(new StringBuffer(NamingConventions.generateName(dataset, template, true) + "_" + n + "_markers").toString(), n, n2, labelledVectorProcessor, metric, sortMode, order, map, dataset, template, fArray, randomSeedGenerator, templateRandomizerType, bl, bl2);
    }

    public PermutationTestImpl(int n, int n2, Dataset dataset, Template template, boolean bl) {
        this(n, n2, new LabelledVectorProcessors$None(), new Metrics$Signal2Noise(), SortMode.REAL, Order.DESCENDING, DatasetMetrics.getDefaultMetricParams(), dataset, template, DEFAULT_SIG_LEVELS, new RandomSeedGenerators$Timestamp(), TemplateRandomizerType.NO_BALANCE, false, bl);
    }

    public PermutationTestImpl(String string, int n, int n2, LabelledVectorProcessor labelledVectorProcessor, Metric metric, SortMode sortMode, Order order, Map map, Dataset dataset, Template template, float[] fArray, RandomSeedGenerator randomSeedGenerator, TemplateRandomizerType templateRandomizerType, boolean bl, boolean bl2) {
        Template[] templateArray = TemplateFactoryRandomizer.createRandomTemplates(n2, template, templateRandomizerType, randomSeedGenerator);
        this.initHere(string, n, n2, labelledVectorProcessor, metric, sortMode, order, map, dataset, template, fArray, bl, templateArray, bl2);
    }

    private void initHere(String string, int n, int n2, LabelledVectorProcessor labelledVectorProcessor, Metric metric, SortMode sortMode, Order order, Map map, Dataset dataset, Template template, float[] fArray, boolean bl, Template[] templateArray, boolean bl2) {
        super.init(string, n, n2, labelledVectorProcessor, metric, sortMode, order, map, dataset, template, fArray, bl2);
        this.fRndTemplates = templateArray;
        DatasetMetrics datasetMetrics = new DatasetMetrics();
        DatasetMetrics$ScoredStruc datasetMetrics$ScoredStruc = datasetMetrics.scoreDatasetStruc(this.fMetric, this.fSort, this.fOrder, this.fMetricParams, this.fLabelledVectorProc, this.getDataset(), this.getTemplate());
        this.fRealScoredDataset = datasetMetrics$ScoredStruc.sds;
        this.fMetricCrossOverRanks = new TIntArrayList(this.fNumPerms);
        this.fRndMetricWeightStrucs = new MetricWeightStruc[this.fNumPerms];
        this.fMarkerScores = new DatasetStatsCore().calc2ClassCategoricalMetricMarkerScores(this.getDataset(), this.getTemplate(), this.fMetric, this.fMetricParams);
        Matrix matrix = new Matrix(this.fNumMarkers, this.fNumPerms);
        Matrix matrix2 = new Matrix(this.fNumMarkers, this.fNumPerms);
        if (bl) {
            this.fRndFullMatrix = new Matrix(dataset.getNumRow(), this.fNumPerms);
        }
        for (int i2 = 0; i2 < this.fNumPerms; ++i2) {
            int n3;
            DatasetMetrics$ScoredStruc datasetMetrics$ScoredStruc2 = datasetMetrics.scoreDatasetStruc(this.fMetric, this.fSort, this.fOrder, this.fMetricParams, this.fLabelledVectorProc, this.getDataset(), this.fRndTemplates[i2]);
            ScoredDataset scoredDataset = datasetMetrics$ScoredStruc2.sds;
            for (n3 = 0; n3 < this.fNumMarkers; ++n3) {
                matrix.setElement(n3, i2, scoredDataset.getScore(n3));
            }
            n3 = dataset.getNumRow() - 1;
            int n4 = 0;
            while (n4 < this.fNumMarkers) {
                matrix2.setElement(n4, i2, scoredDataset.getScore(n3));
                ++n4;
                --n3;
            }
            if (bl) {
                this.fRndFullMatrix.setColumn(i2, datasetMetrics$ScoredStruc2.getDatasetSynchedScores());
            }
            for (n4 = 0; n4 < scoredDataset.getSize(); ++n4) {
                if (!XMath.isNegative(scoredDataset.getScore(n4))) continue;
                this.fMetricCrossOverRanks.add(n4 + 1);
                break;
            }
            this.fRndMetricWeightStrucs[i2] = scoredDataset.getMetricWeightStruc();
            if (i2 % 10 != 0) continue;
            System.out.println("Done permutation #: " + (i2 + 1) + " / " + this.fNumPerms + " for: " + this.getName());
        }
        this.calcAndSetSignificanceLevels(matrix, matrix2);
    }

    public final Matrix getFullRandomMatrix() {
        return this.fRndFullMatrix;
    }

    @Override
    public final MetricWeightStruc[] getRandomMetricWeights() {
        return this.fRndMetricWeightStrucs;
    }

    @Override
    public final DatasetStatsCore$TwoClassMarkerStats getScore(String string) {
        Object v = this.fMarkerScores.get(string);
        if (v == null) {
            throw new IllegalArgumentException("No such feature: " + string);
        }
        return (DatasetStatsCore$TwoClassMarkerStats)v;
    }

    @Override
    public final Template[] getTemplatesRandom() {
        return this.fRndTemplates;
    }

    @Override
    public final TIntArrayList getMetricCrossOverRanks() {
        return this.fMetricCrossOverRanks;
    }

    @Override
    public final int getRealMetricCrossOverRank() {
        int n = 0;
        for (int i2 = 0; i2 < this.fRealScoredDataset.getSize(); ++i2) {
            if (!XMath.isNegative(this.fRealScoredDataset.getScore(i2))) continue;
            n = i2 + 1;
            break;
        }
        return n;
    }

    @Override
    public final MetricWeightStruc getRealMetricWeight() {
        return this.fRealScoredDataset.getMetricWeightStruc();
    }

    @Override
    public final RankedList getRankedList() {
        if (this.fRealRankedList == null) {
            this.fRealRankedList = RankedListGenerators.createBySorting(this.fRealScoredDataset, this.fSort, this.fOrder);
        }
        return this.fRealRankedList;
    }

    @Override
    public final ScoredDataset getScoredDataset() {
        return this.fRealScoredDataset;
    }

    @Override
    public final int getNumSigMarkers(float f2) {
        throw new NotImplementedException();
    }

    @Override
    public final GeneSet getSigMarkers(float f2) {
        throw new NotImplementedException();
    }
}

