/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.markers;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.alg.DatasetMetrics;
import edu.mit.broad.genome.alg.DatasetMetrics$ScoredStruc;
import edu.mit.broad.genome.alg.DatasetStatsCore;
import edu.mit.broad.genome.alg.DatasetStatsCore$TwoClassMarkerStats;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.RankedListGenerators;
import edu.mit.broad.genome.alg.markers.AbstractPermutationTest;
import edu.mit.broad.genome.math.LabelledVectorProcessor;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.MetricWeightStruc;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.objects.Template;
import gnu.trove.TIntArrayList;
import java.util.Map;

public class PermutationTestBuilder
extends AbstractPermutationTest {
    private Template[] fRndTemplates;
    private ScoredDataset fRealScoredDataset;
    private Map fMarkerScores;
    private TIntArrayList fMetricCrossOverRanks;
    private MetricWeightStruc[] fRndMetricWeightStrucs;
    private Matrix nMarkersUpMatrix;
    private Matrix nMarkersDnMatrix;
    private int fNumSetCalls;
    private RankedList fRealRankedList;

    public PermutationTestBuilder(String string, int n, int n2, LabelledVectorProcessor labelledVectorProcessor, Metric metric, SortMode sortMode, Order order, Map map, Dataset dataset, Template template, float[] fArray, boolean bl) {
        super.init(string, n, n2, labelledVectorProcessor, metric, sortMode, order, map, dataset, template, fArray, bl);
        DatasetMetrics datasetMetrics = new DatasetMetrics();
        DatasetMetrics$ScoredStruc datasetMetrics$ScoredStruc = datasetMetrics.scoreDatasetStruc(this.fMetric, this.fSort, this.fOrder, this.fMetricParams, this.fLabelledVectorProc, this.getDataset(), this.getTemplate());
        this.fRealScoredDataset = datasetMetrics$ScoredStruc.sds;
        if (bl) {
            this.fMarkerScores = new DatasetStatsCore().calc2ClassCategoricalMetricMarkerScores(this.getDataset(), this.getTemplate(), this.fMetric, this.fMetricParams);
        }
        this.nMarkersUpMatrix = new Matrix(this.fNumMarkers, this.fNumPerms);
        this.nMarkersDnMatrix = new Matrix(this.fNumMarkers, this.fNumPerms);
        this.fRndTemplates = new Template[this.fNumPerms];
        this.fMetricCrossOverRanks = new TIntArrayList(this.fNumPerms);
        this.fRndMetricWeightStrucs = new MetricWeightStruc[this.fNumPerms];
    }

    public final void doCalc() {
        this.checkIfDone();
        this.calcAndSetSignificanceLevels(this.nMarkersUpMatrix, this.nMarkersDnMatrix);
    }

    public final void addRnd(Template template, RankedList rankedList) {
        int n;
        if (this.fNumSetCalls == this.getNumPerms()) {
            throw new IllegalStateException("Already done fNumSetCalls: " + this.fNumSetCalls + " getNumPerms: " + this.getNumPerms());
        }
        this.fRndTemplates[this.fNumSetCalls] = template;
        for (n = 0; n < this.fNumMarkers; ++n) {
            this.nMarkersUpMatrix.setElement(n, this.fNumSetCalls, rankedList.getScore(n));
        }
        n = this.getDataset().getNumRow() - 1;
        int n2 = 0;
        while (n2 < this.fNumMarkers) {
            this.nMarkersDnMatrix.setElement(n2, this.fNumSetCalls, rankedList.getScore(n));
            ++n2;
            --n;
        }
        for (n2 = 0; n2 < rankedList.getSize(); ++n2) {
            if (!XMath.isNegative(rankedList.getScore(n2))) continue;
            this.fMetricCrossOverRanks.add(n2 + 1);
            break;
        }
        this.fRndMetricWeightStrucs[this.fNumSetCalls] = rankedList.getMetricWeightStruc();
        ++this.fNumSetCalls;
    }

    private void checkIfDone() {
        if (this.fNumSetCalls != this.getNumPerms()) {
            throw new IllegalStateException("Not yet done: fNumSetCalls: " + this.fNumSetCalls + " nperm: " + this.getNumPerms());
        }
    }

    @Override
    public final MetricWeightStruc[] getRandomMetricWeights() {
        this.checkIfDone();
        return this.fRndMetricWeightStrucs;
    }

    @Override
    public final DatasetStatsCore$TwoClassMarkerStats getScore(String string) {
        if (this.fMarkerScores == null) {
            throw new IllegalStateException("MarkerScores is null .. are you sure this is a categorical template: " + this.getTemplate().getName());
        }
        Object v = this.fMarkerScores.get(string);
        if (v == null) {
            throw new IllegalArgumentException("No such feature: " + string);
        }
        return (DatasetStatsCore$TwoClassMarkerStats)v;
    }

    @Override
    public final Template[] getTemplatesRandom() {
        this.checkIfDone();
        return this.fRndTemplates;
    }

    @Override
    public final TIntArrayList getMetricCrossOverRanks() {
        this.checkIfDone();
        return this.fMetricCrossOverRanks;
    }

    @Override
    public final int getRealMetricCrossOverRank() {
        int n = 0;
        for (int i2 = 0; i2 < this.fRealScoredDataset.getSize(); ++i2) {
            if (!XMath.isNegative(this.fRealScoredDataset.getScore(i2))) continue;
            n = i2 + 1;
            break;
        }
        return n;
    }

    @Override
    public final MetricWeightStruc getRealMetricWeight() {
        return this.fRealScoredDataset.getMetricWeightStruc();
    }

    @Override
    public final RankedList getRankedList() {
        if (this.fRealRankedList == null) {
            this.fRealRankedList = RankedListGenerators.createBySorting(this.fRealScoredDataset, this.fSort, this.fOrder);
        }
        return this.fRealRankedList;
    }

    @Override
    public final ScoredDataset getScoredDataset() {
        return this.fRealScoredDataset;
    }

    @Override
    public final int getNumSigMarkers(float f2) {
        throw new NotImplementedException();
    }

    @Override
    public final GeneSet getSigMarkers(float f2) {
        throw new NotImplementedException();
    }
}

