/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.alg.gsea.Norms$AbstractNormOne;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;

public class Norms$VarMeanPosNegSeperate
extends Norms$AbstractNormOne {
    private static String NAME = "VarMeanPosNegSeperate";
    int numRndPos;
    int numRndNeg;
    float meanPos_orig;
    float varPos_orig;
    float meanNeg_orig;
    float varNeg_orig;
    float meanNeg_after_norm;
    float varNeg_after_norm;
    float meanPos_after_norm;
    float varPos_after_norm;

    public Norms$VarMeanPosNegSeperate(float f2, Vector vector) {
        super(NAME);
        this.real_orig = f2;
        this.rnd_orig = vector;
        Vector vector2 = this.rnd_orig.extract(ScoreMode.POS_ONLY);
        Vector vector3 = this.rnd_orig.extract(ScoreMode.NEG_ONLY);
        this.meanPos_orig = (float)vector2.mean();
        this.varPos_orig = (float)Math.sqrt(vector2.var(false, false));
        this.meanNeg_orig = (float)vector3.mean();
        this.varNeg_orig = (float)Math.sqrt(vector3.var(false, false));
        this.rndNorm = new Vector(this.rnd_orig.getSize());
        for (int i2 = 0; i2 < this.rnd_orig.getSize(); ++i2) {
            float f3 = this.rnd_orig.getElement(i2);
            if (XMath.isPositive(f3)) {
                if (XMath.isNegative(f3 = (f3 - this.meanPos_orig) / this.varPos_orig)) {
                    f3 = 0.0f;
                }
                ++this.numRndPos;
            } else {
                if (XMath.isPositive(f3 = (f3 - this.meanNeg_orig) / this.varNeg_orig)) {
                    f3 = 0.0f;
                }
                ++this.numRndNeg;
            }
            this.rndNorm.setElement(i2, f3);
        }
        if (XMath.isPositive(this.real_orig)) {
            this.realNorm = (this.real_orig - this.meanPos_orig) / this.varPos_orig;
            if (XMath.isNegative(this.realNorm)) {
                this.realNorm = 0.0f;
            }
        } else {
            this.realNorm = (this.real_orig - this.meanNeg_orig) / this.varNeg_orig;
            if (XMath.isPositive(this.realNorm)) {
                this.realNorm = 0.0f;
            }
        }
        this.meanPos_after_norm = (float)this.rndNorm.extract(ScoreMode.POS_ONLY).mean();
        this.varPos_after_norm = (float)this.rndNorm.extract(ScoreMode.POS_ONLY).stddev(false, false);
        this.meanNeg_after_norm = (float)this.rndNorm.extract(ScoreMode.NEG_ONLY).mean();
        this.varNeg_after_norm = (float)this.rndNorm.extract(ScoreMode.NEG_ONLY).stddev(false, false);
    }

    static final /* synthetic */ String access$100() {
        return NAME;
    }
}

