/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.alg.gsea.MhtMode;
import edu.mit.broad.genome.alg.gsea.MhtModes;
import edu.mit.broad.genome.alg.gsea.MhtModes$Base;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;

public class MhtModes$Var
extends MhtModes$Base {
    private float[] fRVars;

    public MhtModes$Var() {
        super("var_norm");
    }

    public MhtModes$Var(EnrichmentResult[] enrichmentResultArray) {
        this();
        this.setData(enrichmentResultArray);
    }

    @Override
    public final MhtMode cloneShallow() {
        return new MhtModes$Var();
    }

    @Override
    public final void setData(EnrichmentResult[] enrichmentResultArray) {
        int n;
        super.setData(enrichmentResultArray);
        int n2 = MhtModes.checkAndGetNumPerms(enrichmentResultArray);
        MhtModes.access$400().debug("# dtgs: " + enrichmentResultArray.length + " # of perms: " + n2);
        this.fRndMatrix = new Matrix(enrichmentResultArray.length, n2);
        this.fRVars = new float[enrichmentResultArray.length];
        for (n = 0; n < enrichmentResultArray.length; ++n) {
            if (enrichmentResultArray[n] == null) {
                throw new IllegalArgumentException("dtgs cannot be null at: " + n);
            }
            Vector vector = enrichmentResultArray[n].getRndESS();
            this.fRVars[n] = (float)Math.sqrt(vector.var(false, false));
        }
        for (n = 0; n < enrichmentResultArray.length; ++n) {
            if (enrichmentResultArray[n] == null) {
                throw new IllegalArgumentException("dtgs cannot be null at: " + n);
            }
            this.fRndMatrix.setRow(n, this.getRndNES(n));
        }
    }

    @Override
    public final Vector getRndNES(int n) {
        Vector vector = this.fDtgs[n].getRndESS();
        vector.divide(this.fRVars[n]);
        return vector;
    }

    @Override
    public final float getRealNES(int n) {
        return this.fDtgs[n].getScore().getES() / this.fRVars[n];
    }
}

