/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.RankedListGenerators;
import edu.mit.broad.genome.alg.gsea.GeneSetScoringTable;
import edu.mit.broad.genome.alg.gsea.GeneSetScoringTables$Classic;
import edu.mit.broad.genome.alg.gsea.GeneSetScoringTables$Weighted;
import edu.mit.broad.genome.alg.gsea.GeneSetScoringTables$WeightedDoubleSided;
import edu.mit.broad.genome.alg.gsea.GeneSetScoringTables$WeightedDoubleSidedAs;
import edu.mit.broad.genome.alg.gsea.GeneSetScoringTables$WeightedDoubleSidedAs1;
import edu.mit.broad.genome.alg.gsea.GeneSetScoringTables$WeightedLinear;
import edu.mit.broad.genome.alg.gsea.GeneSetScoringTables$WeightedNative;
import edu.mit.broad.genome.alg.gsea.GeneSetScoringTables$WeightedOnePointFive;
import edu.mit.broad.genome.alg.gsea.GeneSetScoringTables$WeightedSquared;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.RankedList;
import gnu.trove.TFloatArrayList;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class GeneSetScoringTables {
    private static final Logger klog = XLogger.getLogger(GeneSetScoringTables.class);

    public static final GeneSetScoringTable[] createAllScoringTables() {
        return new GeneSetScoringTable[]{new GeneSetScoringTables$Classic(), new GeneSetScoringTables$Weighted(), new GeneSetScoringTables$WeightedSquared(), new GeneSetScoringTables$WeightedOnePointFive()};
    }

    public static final GeneSetScoringTable[] createAllScoringTables_all() {
        return new GeneSetScoringTable[]{new GeneSetScoringTables$Classic(), new GeneSetScoringTables$Weighted(), new GeneSetScoringTables$WeightedNative(), new GeneSetScoringTables$WeightedLinear(), new GeneSetScoringTables$WeightedSquared(), new GeneSetScoringTables$WeightedOnePointFive(), new GeneSetScoringTables$WeightedDoubleSided(), new GeneSetScoringTables$WeightedDoubleSidedAs(), new GeneSetScoringTables$WeightedDoubleSidedAs1()};
    }

    public static final GeneSetScoringTable lookupGeneSetScoringTable(Object object) {
        if (object == null) {
            throw new NullPointerException("Cannot lookup for null object");
        }
        if (object instanceof GeneSetScoringTable) {
            return (GeneSetScoringTable)object;
        }
        GeneSetScoringTable[] geneSetScoringTableArray = GeneSetScoringTables.createAllScoringTables();
        for (int i2 = 0; i2 < geneSetScoringTableArray.length; ++i2) {
            if (!geneSetScoringTableArray[i2].getName().equalsIgnoreCase(object.toString())) continue;
            return geneSetScoringTableArray[i2];
        }
        throw new RuntimeException("Cannot lookup GeneSetScoringTable for: " + object);
    }

    private static float _abs(float f2) {
        if (Float.isNaN(f2) || Float.isInfinite(f2)) {
            return 0.01f;
        }
        return Math.abs(f2);
    }

    private static RankedList linearize(RankedList rankedList) {
        float f2;
        int n = rankedList.getMetricWeightStruc().getTotalPosLength();
        int n2 = rankedList.getMetricWeightStruc().getTotalNegLength();
        float f3 = f2 = (float)XMath.min(n, n2);
        float f4 = (float)rankedList.getSize() - f2;
        ArrayList<String> arrayList = new ArrayList<String>();
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        for (int i2 = 0; i2 < rankedList.getSize(); ++i2) {
            float f5 = (float)i2 < f3 ? (f2 - (float)i2) / f2 : ((float)i2 > f4 ? (f2 - (float)(rankedList.getSize() - 1 - i2)) / f2 : 0.0f);
            tFloatArrayList.add(f5);
            arrayList.add(rankedList.getRankName(i2));
        }
        return RankedListGenerators.createBySorting(rankedList.getName() + "_linearized", arrayList, tFloatArrayList, SortMode.REAL, Order.DESCENDING);
    }

    static final /* synthetic */ float access$000(float f2) {
        return GeneSetScoringTables._abs(f2);
    }

    static final /* synthetic */ RankedList access$100(RankedList rankedList) {
        return GeneSetScoringTables.linearize(rankedList);
    }

    static final /* synthetic */ Logger access$200() {
        return klog;
    }
}

