/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.alg.gsea.GeneSetScoringTable;
import edu.mit.broad.genome.alg.gsea.GeneSetScoringTables$AbstractScoringTable;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.RankedList;

public class GeneSetScoringTables$WeightedSquared
extends GeneSetScoringTables$AbstractScoringTable {
    private static final String NAME = "weighted_p2";
    private float totalWeight_sq;
    private float nhExpected;
    private float miss_score;
    private GeneSet gset;
    private RankedList rankedList;

    public GeneSetScoringTables$WeightedSquared() {
    }

    public GeneSetScoringTables$WeightedSquared(GeneSet geneSet, RankedList rankedList) {
        this.gset = geneSet;
        this.nhExpected = geneSet.getNumMembers();
        if (this.nhExpected == 0.0f) {
            throw new IllegalArgumentException("Number of members in gene set cannot be 0: " + geneSet.getName());
        }
        this.rankedList = rankedList;
        for (int i2 = 0; i2 < this.gset.getNumMembers(); ++i2) {
            float f2 = this.rankedList.getScore(geneSet.getMember(i2));
            this.totalWeight_sq += f2 * f2;
        }
        float f3 = this.rankedList.getSize();
        this.miss_score = 1.0f / (f3 - this.nhExpected);
    }

    @Override
    public final String getName() {
        return NAME;
    }

    @Override
    public final RankedList getRankedList() {
        return this.rankedList;
    }

    @Override
    public final boolean isTwoSidedEs() {
        return false;
    }

    @Override
    public final GeneSetScoringTable createTable(GeneSet geneSet, RankedList rankedList, RankedList rankedList2) {
        return new GeneSetScoringTables$WeightedSquared(geneSet, rankedList);
    }

    @Override
    public final float getHitScore(String string) {
        float f2 = this.rankedList.getScore(string);
        return f2 * f2 / this.totalWeight_sq;
    }

    @Override
    public final float getMissScore(String string) {
        return this.miss_score;
    }
}

