/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.distrib;

import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Range;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.Dataframe;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;

public class RangeUtils {
    private static String[] COL_NAMES = new String[]{"MAX", "MIN", "COUNT", "FRACTION"};

    public static final int[] toIntArray(Range range) {
        int n = (int)range.getSpread();
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = (int)range.getMin();
        while (n3 <= (int)range.getMax()) {
            nArray[n2++] = n3++;
        }
        return nArray;
    }

    public static final void setImmutable(Range[] rangeArray) {
        if (rangeArray == null) {
            throw new IllegalArgumentException("Parameter ranges cannot be null");
        }
        for (int i2 = 0; i2 < rangeArray.length; ++i2) {
            rangeArray[i2].setImmutable();
        }
    }

    public static final int[] createStopIndices(int n, int n2, int n3, boolean bl) {
        RangeUtils.checkRangeIndices(n, n2);
        TIntArrayList tIntArrayList = new TIntArrayList();
        int n4 = n;
        n4 += n3;
        do {
            tIntArrayList.add(n4);
        } while ((n4 += n3) <= n2);
        if (bl && !tIntArrayList.contains(n2)) {
            tIntArrayList.add(n2);
        }
        return tIntArrayList.toNativeArray();
    }

    public static final Dataframe toDataframe(String string, Range[] rangeArray) {
        int n = RangeUtils.getTotalCount(rangeArray);
        ArrayList<String> arrayList = new ArrayList<String>(rangeArray.length);
        Matrix matrix = new Matrix(rangeArray.length, COL_NAMES.length);
        for (int i2 = 0; i2 < rangeArray.length; ++i2) {
            int n2 = 0;
            arrayList.add(rangeArray[i2].getName());
            matrix.setElement(i2, n2++, (float)rangeArray[i2].getMax());
            matrix.setElement(i2, n2++, (float)rangeArray[i2].getMin());
            matrix.setElement(i2, n2++, rangeArray[i2].getCount());
            matrix.setElement(i2, n2, (float)rangeArray[i2].getCount() / (float)n);
        }
        return new Dataframe(string, matrix, arrayList, COL_NAMES, true, true);
    }

    public static final int getTotalCount(Range[] rangeArray) {
        int n = 0;
        for (int i2 = 0; i2 < rangeArray.length; ++i2) {
            n += rangeArray[i2].getCount();
        }
        return n;
    }

    protected static final void checkRangeIndices(int n, int n2) {
        if (n >= n2) {
            throw new IllegalArgumentException("fromIndex: " + n + " must be smaller than toIndex: " + n2);
        }
    }

    public static final Vector toVector(Range[] rangeArray) {
        Vector vector = new Vector(rangeArray.length);
        for (int i2 = 0; i2 < rangeArray.length; ++i2) {
            vector.setElement(i2, rangeArray[i2].getCount());
        }
        return vector;
    }

    public static final String[] toNames(Range[] rangeArray) {
        String[] stringArray = new String[rangeArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = rangeArray[i2].getName();
        }
        return stringArray;
    }
}

