/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.DatasetMetrics;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.TemplateStats$Composition;
import edu.mit.broad.genome.alg.TemplateStats$RandomRankedListMode;
import edu.mit.broad.genome.alg.TemplateStats$TemplateHitStruc;
import edu.mit.broad.genome.alg.TemplateStats$TemplateHitStruc$Hit;
import edu.mit.broad.genome.math.LabelledVectorProcessor;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.RandomSeedGenerator;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.Template$Class;
import edu.mit.broad.genome.objects.Template$Item;
import edu.mit.broad.genome.objects.TemplateFactoryRandomizer;
import edu.mit.broad.genome.objects.strucs.DefaultMetricWeightStruc;
import edu.mit.broad.genome.objects.strucs.TemplateRandomizerType;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class TemplateStats {
    private static final Logger klog = XLogger.getLogger(TemplateStats.class);

    private TemplateStats() {
    }

    public static final String[] getClassNamesInOrder(Template template) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < template.getNumItems(); ++i2) {
            Template$Class template$Class = template.getClassByProfilePos(i2);
            String string = template$Class == null ? "N" : template$Class.getName();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static final Vector calcAverageHammingDists(Template template, Template[] templateArray) {
        Vector vector = new Vector(templateArray.length);
        for (int i2 = 0; i2 < templateArray.length; ++i2) {
            vector.setElement(i2, TemplateStats.calcAverageHammingDist(template, templateArray[i2]));
        }
        return vector;
    }

    public static final int calcAverageHammingDist(Template template, Template template2) {
        int n = 0;
        for (int i2 = 0; i2 < template.getNumItems(); ++i2) {
            Template$Item template$Item = template.getItemByProfilePos(i2);
            Template$Item template$Item2 = template2.getItemByProfilePos(i2);
            if (template$Item.getId().equals(template$Item2.getId())) continue;
            ++n;
        }
        return n;
    }

    public static final TemplateStats$Composition getComposition(Template[] templateArray) {
        return new TemplateStats$Composition(templateArray);
    }

    public static final TemplateStats$TemplateHitStruc createRandomTemplates(float f2, float f3, int n, int n2, SortMode sortMode, Order order, Metric metric, Map map, LabelledVectorProcessor labelledVectorProcessor, Dataset dataset, Template template, TemplateRandomizerType templateRandomizerType, RandomSeedGenerator randomSeedGenerator, TemplateStats$RandomRankedListMode templateStats$RandomRankedListMode) {
        Object object;
        DatasetMetrics datasetMetrics = new DatasetMetrics();
        ScoredDataset scoredDataset = datasetMetrics.scoreDataset(metric, sortMode, order, map, labelledVectorProcessor, dataset, template);
        DefaultMetricWeightStruc defaultMetricWeightStruc = new DefaultMetricWeightStruc(metric.getName(), scoredDataset);
        float f4 = defaultMetricWeightStruc.getTotalPosLength_frac();
        float f5 = defaultMetricWeightStruc.getTotalPosWeight_frac();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (!templateStats$RandomRankedListMode.isRandom()) {
            if (templateStats$RandomRankedListMode.isSameLength()) {
                n3 = n;
            } else if (templateStats$RandomRankedListMode.isSameWeight()) {
                n4 = n;
            } else if (templateStats$RandomRankedListMode.isSameLengthAndWeight()) {
                n5 = n;
            } else {
                throw new IllegalArgumentException("Invalid rmode: " + templateStats$RandomRankedListMode);
            }
        }
        klog.info("For real template real_length_frac: " + f4 + " real_weight_frac: " + f5);
        ArrayList<TemplateStats$TemplateHitStruc$Hit> arrayList = new ArrayList<TemplateStats$TemplateHitStruc$Hit>();
        ArrayList<TemplateStats$TemplateHitStruc$Hit> arrayList2 = new ArrayList<TemplateStats$TemplateHitStruc$Hit>();
        ArrayList<TemplateStats$TemplateHitStruc$Hit> arrayList3 = new ArrayList<TemplateStats$TemplateHitStruc$Hit>();
        ArrayList<TemplateStats$TemplateHitStruc$Hit> arrayList4 = new ArrayList<TemplateStats$TemplateHitStruc$Hit>();
        int n6 = 0;
        boolean bl = false;
        boolean bl2 = false;
        do {
            object = TemplateFactoryRandomizer.createRandomTemplates(1, template, templateRandomizerType, randomSeedGenerator, true)[0];
            if (templateStats$RandomRankedListMode.isRandom()) {
                arrayList4.add(new TemplateStats$TemplateHitStruc$Hit((Template)object, null, null));
                if (arrayList4.size() >= n) {
                    bl2 = false;
                    bl = true;
                }
            } else {
                ScoredDataset scoredDataset2 = datasetMetrics.scoreDataset(metric, sortMode, order, map, labelledVectorProcessor, dataset, (Template)object);
                DefaultMetricWeightStruc defaultMetricWeightStruc2 = new DefaultMetricWeightStruc(metric.getName(), scoredDataset2);
                float f6 = defaultMetricWeightStruc2.getTotalPosLength_frac();
                float f7 = defaultMetricWeightStruc2.getTotalPosWeight_frac();
                if (Math.abs(f4 - f6) <= f2) {
                    arrayList.add(new TemplateStats$TemplateHitStruc$Hit((Template)object, defaultMetricWeightStruc2, scoredDataset2));
                }
                if (Math.abs(f5 - f7) <= f3) {
                    arrayList2.add(new TemplateStats$TemplateHitStruc$Hit((Template)object, defaultMetricWeightStruc2, scoredDataset2));
                }
                if (Math.abs(f4 - f6) <= f2 && Math.abs(f5 - f7) <= f3) {
                    arrayList3.add(new TemplateStats$TemplateHitStruc$Hit((Template)object, defaultMetricWeightStruc2, scoredDataset2));
                }
                if (arrayList.size() < n3) {
                    bl = false;
                }
                if (arrayList2.size() < n4) {
                    bl = false;
                }
                if (arrayList3.size() < n5) {
                    bl = false;
                }
                if (arrayList.size() >= n3 && arrayList2.size() >= n4 && arrayList3.size() >= n5) {
                    bl = true;
                }
                if (n6 % 50 == 0) {
                    System.out.println("numAttempts: " + n6 + " / " + n2 + " hitsLength: " + arrayList.size() + " / " + n3 + " hitsWeight: " + arrayList2.size() + " / " + n4 + " hitsLengthAndWeight: " + arrayList3.size() + " / " + n5);
                }
                if (n6 >= n2) {
                    bl = true;
                    bl2 = true;
                }
            }
            ++n6;
        } while (!bl);
        klog.info("Templates length: " + n3 + " / " + arrayList.size() + " weight: " + n4 + " / " + arrayList2.size() + " BothLengthAndWeight: " + n5 + " / " + arrayList3.size());
        if (bl2) {
            klog.warn("Could NOT make as many templates as asked for!");
        }
        object = new TemplateStats$TemplateHitStruc(scoredDataset, defaultMetricWeightStruc, f2, f3);
        TemplateStats$TemplateHitStruc.access$202((TemplateStats$TemplateHitStruc)object, arrayList.toArray(new TemplateStats$TemplateHitStruc$Hit[arrayList.size()]));
        TemplateStats$TemplateHitStruc.access$302((TemplateStats$TemplateHitStruc)object, arrayList2.toArray(new TemplateStats$TemplateHitStruc$Hit[arrayList2.size()]));
        TemplateStats$TemplateHitStruc.access$402((TemplateStats$TemplateHitStruc)object, arrayList3.toArray(new TemplateStats$TemplateHitStruc$Hit[arrayList3.size()]));
        TemplateStats$TemplateHitStruc.access$502((TemplateStats$TemplateHitStruc)object, arrayList4.toArray(new TemplateStats$TemplateHitStruc$Hit[arrayList4.size()]));
        return object;
    }
}

