/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome;

import java.util.StringTokenizer;
import java.util.Vector;

public class Version {
    public static final Version ALL = new Version(new int[0]);
    public static final Version NOT_IMPLEMENTED = new Version("todo");
    private static final String EMPTY_QUALIFIER = "";
    private int[] versionComponents;
    private String qualifier;

    public Version() {
        this(new int[0]);
    }

    public Version(String string) {
        this.fromString(string);
    }

    public Version(int n) {
        this(new int[]{n});
    }

    public Version(int n, int n2) {
        this(new int[]{n, n2});
    }

    public Version(int n, int n2, int n3) {
        this(new int[]{n, n2, n3});
    }

    public Version(int[] nArray) {
        this(nArray, EMPTY_QUALIFIER);
    }

    public Version(int[] nArray, String string) {
        this.versionComponents = nArray;
        this.qualifier = string;
    }

    public final int getVersionComponent(int n) {
        if (n >= this.versionComponents.length) {
            return 0;
        }
        return this.versionComponents[n];
    }

    public final String getQualifier() {
        return this.qualifier;
    }

    public final boolean precedes(Version version) {
        for (int i2 = 0; i2 < this.versionComponents.length; ++i2) {
            if (i2 == version.versionComponents.length) {
                return false;
            }
            if (this.versionComponents[i2] <= version.versionComponents[i2]) continue;
            return false;
        }
        if (this.versionComponents.length < version.versionComponents.length) {
            return true;
        }
        if (this.versionComponents.length > version.versionComponents.length) {
            return false;
        }
        if (Version.hasQualifier(this) && Version.hasQualifier(version)) {
            return this.qualifier.compareTo(version.qualifier) == -1;
        }
        if (!Version.hasQualifier(this) && Version.hasQualifier(version)) {
            return true;
        }
        if (Version.hasQualifier(this) && !Version.hasQualifier(version)) {
            return false;
        }
        return false;
    }

    public final boolean succeeds(Version version) {
        return !this.precedes(version) && !this.equals(version);
    }

    public final int compareTo(Object object) {
        Version version = (Version)object;
        if (this.equals(version)) {
            return 0;
        }
        if (this.precedes(version)) {
            return -1;
        }
        return 1;
    }

    public final boolean equals(Object object) {
        int n;
        if (this == object) {
            return true;
        }
        if (null == object || object.getClass() != this.getClass()) {
            return false;
        }
        Version version = (Version)object;
        for (n = 0; n < this.versionComponents.length; ++n) {
            if (this.versionComponents[n] == version.getVersionComponent(n)) continue;
            return false;
        }
        if (this.versionComponents.length > version.versionComponents.length) {
            n = this.versionComponents.length - version.versionComponents.length;
            for (int i2 = 0; i2 < n; ++i2) {
                if (this.versionComponents[this.versionComponents.length - n + i2] == 0) continue;
                return false;
            }
        } else if (this.versionComponents.length < version.versionComponents.length) {
            n = version.versionComponents.length - this.versionComponents.length;
            for (int i3 = 0; i3 < n; ++i3) {
                if (version.versionComponents[version.versionComponents.length - n + i3] == 0) continue;
                return false;
            }
        }
        if (Version.hasQualifier(this) && Version.hasQualifier(version)) {
            return this.qualifier.equals(version.qualifier);
        }
        return !Version.hasQualifier(this) && !Version.hasQualifier(version);
    }

    public final String toString() {
        if (this.versionComponents.length == 0) {
            return "ALL";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.versionComponents.length; ++i2) {
            stringBuffer.append(String.valueOf(this.versionComponents[i2]));
            stringBuffer.append(".");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        stringBuffer.append(this.qualifier);
        return stringBuffer.toString();
    }

    public final void fromString(String string) {
        this.qualifier = EMPTY_QUALIFIER;
        if (string.equals("ALL")) {
            this.versionComponents = new int[0];
            this.qualifier = EMPTY_QUALIFIER;
            return;
        }
        int n = string.length();
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        int[] nArray = new int[vector.size()];
        int n2 = 0;
        try {
            for (n2 = 0; n2 < vector.size(); ++n2) {
                nArray[n2] = Integer.parseInt((String)vector.elementAt(n2));
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (n2 == vector.size() - 1) {
                String string2 = (String)vector.elementAt(n2);
                StringBuffer stringBuffer = new StringBuffer();
                int n3 = 0;
                for (n3 = 0; n3 < string2.length() && Character.isDigit(string2.charAt(n3)); ++n3) {
                    stringBuffer.append(string2.charAt(n3));
                }
                if (stringBuffer.length() > 0) {
                    try {
                        nArray[n2] = Integer.parseInt(stringBuffer.toString());
                    }
                    catch (NumberFormatException numberFormatException2) {
                        throw new RuntimeException("parse exception: " + numberFormatException.getMessage());
                    }
                    this.qualifier = string2.substring(n3);
                }
                this.qualifier = string2;
            }
            throw new RuntimeException("parse exception: " + numberFormatException.getMessage());
        }
        this.versionComponents = nArray;
    }

    public final Object clone() {
        Version version = null;
        try {
            version = (Version)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
        version.versionComponents = this.versionComponents;
        version.qualifier = this.qualifier;
        return version;
    }

    private static boolean hasQualifier(Version version) {
        return !version.qualifier.equals(EMPTY_QUALIFIER);
    }
}

