/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome;

import com.braju.format.Format;
import com.braju.format.Parameters;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.math.AddressedVector;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Range;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.Template$Class;
import edu.mit.broad.genome.objects.Template$Item;
import gnu.trove.TFloatHashSet;
import gnu.trove.TFloatIterator;
import gnu.trove.THashMap;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntIntIterator;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import gnu.trove.TObjectFloatHashMap;
import gnu.trove.TObjectFloatIterator;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntIterator;
import java.awt.datatransfer.DataFlavor;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;

public class Printf {
    private static final Logger klog = XLogger.getLogger(Printf.class);
    private static final int DEFAULT_PRECISION = 4;
    private static final String DEFAULT_PRECISION_STR = "%.4f";
    private static final char DEFAULT_DELIM = ',';

    private Printf() {
    }

    public static final void outl(TObjectFloatHashMap tObjectFloatHashMap) {
        klog.info(Printf.outs(tObjectFloatHashMap));
    }

    public static final String outs(TObjectFloatHashMap tObjectFloatHashMap) {
        TObjectFloatIterator tObjectFloatIterator = tObjectFloatHashMap.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        int n = tObjectFloatHashMap.size();
        while (n-- > 0) {
            tObjectFloatIterator.advance();
            stringBuffer.append(tObjectFloatIterator.key()).append('\t').append(tObjectFloatIterator.value()).append('\n');
        }
        return stringBuffer.toString();
    }

    public static final void outl(TObjectIntHashMap tObjectIntHashMap) {
        klog.info(Printf.outs(tObjectIntHashMap));
    }

    public static final String outs(TIntObjectHashMap tIntObjectHashMap) {
        if (tIntObjectHashMap == null) {
            return "null TIntObjectHashMap";
        }
        if (tIntObjectHashMap.isEmpty()) {
            return "empty TIntObjectHashMap";
        }
        TIntObjectIterator tIntObjectIterator = tIntObjectHashMap.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        int n = tIntObjectHashMap.size();
        while (n-- > 0) {
            tIntObjectIterator.advance();
            stringBuffer.append(tIntObjectIterator.key()).append('\t').append(tIntObjectIterator.value()).append('\n');
        }
        return stringBuffer.toString();
    }

    public static final void outl(THashMap tHashMap) {
        klog.info(Printf.outs(tHashMap));
    }

    public static final String outs(THashMap tHashMap) {
        if (tHashMap == null) {
            return "null TIntObjectHashMap";
        }
        if (tHashMap.isEmpty()) {
            return "empty TIntObjectHashMap";
        }
        Iterator iterator = tHashMap.keySet().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        int n = tHashMap.size();
        while (n-- > 0) {
            iterator.next();
            Object e2 = iterator.next();
            stringBuffer.append(e2).append('\t').append(tHashMap.get(e2)).append('\n');
        }
        return stringBuffer.toString();
    }

    public static final void outl(TFloatHashSet tFloatHashSet) {
        klog.info(Printf.outs(tFloatHashSet));
    }

    public static final String outs(TFloatHashSet tFloatHashSet) {
        if (tFloatHashSet == null) {
            return "null TFloatHashSet";
        }
        if (tFloatHashSet.isEmpty()) {
            return "empty TFloatHashSet";
        }
        TFloatIterator tFloatIterator = tFloatHashSet.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("size: ").append(tFloatHashSet.size()).append('\n');
        int n = 0;
        int n2 = tFloatHashSet.size();
        while (n2-- > 0) {
            float f2 = tFloatIterator.next();
            stringBuffer.append(f2).append(',');
            if (++n <= 10) continue;
            stringBuffer.append("\nand so on ...");
        }
        return stringBuffer.toString();
    }

    public static final void outl(Dataset dataset) {
        klog.debug(Printf.outs(dataset));
    }

    public static final void out(Dataset dataset) {
        System.out.println(Printf.outs(dataset).toString());
    }

    public static final String info(Dataset dataset) {
        StringBuffer stringBuffer = new StringBuffer("Name: ").append(dataset.getName()).append('\n');
        stringBuffer.append("Num Rows: ").append(dataset.getNumRow()).append('\n');
        stringBuffer.append("Num Cols: ").append(dataset.getNumCol()).append('\n');
        String string = dataset.getComment();
        if (string != null && string.length() > 0) {
            stringBuffer.append("\nComments\n");
            stringBuffer.append(dataset.getComment());
        }
        return stringBuffer.toString();
    }

    public static final StringBuffer outs(Dataset dataset) {
        if (dataset == null) {
            return new StringBuffer("Null Dataset");
        }
        StringBuffer stringBuffer = new StringBuffer("Name: " + dataset.getName() + " Id: " + dataset.getId()).append('\n');
        stringBuffer.append("Num rows = ").append(dataset.getNumRow()).append('\n');
        stringBuffer.append("Num cols = ").append(dataset.getNumCol()).append('\n');
        int n = 25;
        if (n > dataset.getNumRow()) {
            n = dataset.getNumRow();
        }
        for (int i2 = 0; i2 < n; ++i2) {
            stringBuffer.append(dataset.getRowName(i2)).append('\t').append(dataset.getRow(i2)).append('\n');
        }
        stringBuffer.append("and so on ...\n");
        return stringBuffer;
    }

    public static final void outl(Dataset[] datasetArray) {
        klog.debug(Printf.outs(datasetArray).toString());
    }

    public static final void out(Dataset[] datasetArray) {
        System.out.println(Printf.outs(datasetArray).toString());
    }

    public static final StringBuffer outs(Dataset[] datasetArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (datasetArray == null) {
            return new StringBuffer("null datasets");
        }
        stringBuffer.append("Number of datasets = ").append(datasetArray.length).append('\n');
        for (int i2 = 0; i2 < datasetArray.length; ++i2) {
            stringBuffer.append(Printf.outs(datasetArray[i2])).append('\n');
        }
        return stringBuffer;
    }

    public static final void outl(FeatureAnnot featureAnnot) {
        klog.debug(Printf.outs(featureAnnot));
    }

    public static final void out(FeatureAnnot featureAnnot) {
        System.out.println(Printf.outs(featureAnnot).toString());
    }

    public static final StringBuffer outs(FeatureAnnot featureAnnot) {
        if (featureAnnot == null) {
            return new StringBuffer("Null Ann");
        }
        StringBuffer stringBuffer = new StringBuffer("Name: " + featureAnnot.getName() + " Id: " + featureAnnot.getId()).append('\n');
        stringBuffer.append("Num rows = ").append(featureAnnot.getNumFeatures()).append('\n');
        stringBuffer.append('\n');
        stringBuffer.append("and so on ...\n");
        return stringBuffer;
    }

    public static final void outl(FeatureAnnot[] featureAnnotArray) {
        klog.debug(Printf.outs(featureAnnotArray).toString());
    }

    public static final void out(FeatureAnnot[] featureAnnotArray) {
        System.out.println(Printf.outs(featureAnnotArray).toString());
    }

    public static final StringBuffer outs(FeatureAnnot[] featureAnnotArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (featureAnnotArray == null) {
            return new StringBuffer("null datasets annotations");
        }
        stringBuffer.append("Number of datasets = ").append(featureAnnotArray.length).append('\n');
        for (int i2 = 0; i2 < featureAnnotArray.length; ++i2) {
            stringBuffer.append(Printf.outs(featureAnnotArray[i2])).append('\n');
        }
        return stringBuffer;
    }

    public static final void outl(Range[] rangeArray) {
        klog.info(Printf.outs(rangeArray));
    }

    public static final void out(Range[] rangeArray) {
        System.out.println(Printf.outs(rangeArray));
    }

    public static final StringBuffer outs(Range[] rangeArray) {
        if (rangeArray == null) {
            return new StringBuffer("Null ranges array");
        }
        StringBuffer stringBuffer = new StringBuffer("Ranges: " + rangeArray.length).append('\n');
        for (int i2 = 0; i2 < rangeArray.length; ++i2) {
            stringBuffer.append(rangeArray[i2].getName()).append('\n');
        }
        return stringBuffer;
    }

    public static final void out(JTable jTable) {
        System.out.println(((DefaultTableModel)jTable.getModel()).getDataVector());
    }

    public static final void out(Vector vector) {
        if (vector == null) {
            System.out.println("Null vector");
        } else {
            System.out.println(vector.toString());
        }
    }

    public static final void outl(Vector vector) {
        if (vector == null) {
            klog.info("Null vector");
        } else {
            klog.info(vector.toString());
        }
    }

    public static final String format(Vector vector) {
        return Printf.format(vector, 4, ',');
    }

    public static final String format(Vector vector, int n) {
        return Printf.format(vector, n, ',');
    }

    public static final String format(Vector vector, char c2) {
        return Printf.format(vector, 4, c2);
    }

    public static final String format(Vector vector, int n, char c2) {
        if (vector == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            stringBuffer.append(Printf.format(vector.getElement(i2), n));
            if (i2 == vector.getSize() - 1) continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static final void out(Vector[] vectorArray) {
        System.out.println(Printf.outs(vectorArray));
    }

    public static final void outl(Vector[] vectorArray) {
        klog.info(Printf.outs(vectorArray));
    }

    public static final StringBuffer outs(Vector[] vectorArray) {
        if (null == vectorArray) {
            return new StringBuffer("null array");
        }
        StringBuffer stringBuffer = new StringBuffer("Number of vectors = " + vectorArray.length).append('\n');
        for (int i2 = 0; i2 < vectorArray.length; ++i2) {
            stringBuffer.append(vectorArray[i2].toString()).append('\n');
        }
        return stringBuffer;
    }

    public static final void out(AddressedVector addressedVector) {
        System.out.println(Printf.outs(addressedVector));
    }

    public static final void outl(AddressedVector addressedVector) {
        klog.info(Printf.outs(addressedVector));
    }

    public static final String outs(AddressedVector addressedVector) {
        if (addressedVector == null) {
            return "null AddressedVector";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("size: ").append(addressedVector.getSize()).append('\n');
        int n = 100;
        if (n > addressedVector.getSize()) {
            n = addressedVector.getSize();
        }
        for (int i2 = 0; i2 < n; ++i2) {
            stringBuffer.append(addressedVector.getAddress(i2)).append(',').append(addressedVector.getScore(i2)).append('\t');
        }
        return stringBuffer.toString();
    }

    public static final void out(float[] fArray) {
        System.out.println(Printf.outs(fArray));
    }

    public static final void outl(float[] fArray) {
        klog.info(Printf.outs(fArray));
    }

    public static final String outs(float[] fArray) {
        if (fArray == null) {
            return "Null array";
        }
        StringBuffer stringBuffer = new StringBuffer("array length: " + fArray.length).append('\n');
        int n = 20;
        if (n > fArray.length) {
            n = fArray.length;
        }
        for (int i2 = 0; i2 < n; ++i2) {
            stringBuffer.append(fArray[i2]).append(' ');
        }
        stringBuffer.append("\nand so on ...\n");
        return stringBuffer.toString();
    }

    public static final void out(double[] dArray) {
        System.out.println(Printf.outs(dArray));
    }

    public static final void outl(double[] dArray) {
        klog.info(Printf.outs(dArray));
    }

    public static final String outs(double[] dArray) {
        if (dArray == null) {
            return "Null array";
        }
        StringBuffer stringBuffer = new StringBuffer("array length: " + dArray.length).append('\n');
        int n = 20;
        if (n > dArray.length) {
            n = dArray.length;
        }
        for (int i2 = 0; i2 < n; ++i2) {
            stringBuffer.append(dArray[i2]).append(' ');
        }
        stringBuffer.append("\nand so on ...\n");
        return stringBuffer.toString();
    }

    public static final void out(int[] nArray) {
        System.out.println(Printf.outs(nArray));
    }

    public static final void outl(int[] nArray) {
        klog.info(Printf.outs(nArray));
    }

    public static final String outs(int[] nArray) {
        if (nArray == null) {
            return "Null array";
        }
        StringBuffer stringBuffer = new StringBuffer("array length: " + nArray.length).append('\n');
        int n = 200;
        if (nArray.length < n) {
            n = nArray.length;
        }
        for (int i2 = 0; i2 < n; ++i2) {
            stringBuffer.append(nArray[i2]).append(' ');
        }
        stringBuffer.append("\nand so on ...\n");
        return stringBuffer.toString();
    }

    public static final String format(int[] nArray) {
        return Printf.format(nArray, ',');
    }

    public static final String format(int[] nArray, char c2) {
        if (nArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            stringBuffer.append(nArray[i2]);
            if (i2 == nArray.length - 1) continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static final String format(float[] fArray, int n, char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            stringBuffer.append(Printf.format(fArray[i2], n));
            if (i2 == fArray.length - 1) continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static final String format(float[] fArray, int n) {
        return Printf.format(fArray, n, ',');
    }

    public static final String format(float[] fArray) {
        return Printf.format(fArray, 4, ',');
    }

    public static final String format(float f2, int n) {
        String string = Format.sprintf(new StringBuffer("%.").append(n).append('f').toString(), new Parameters(f2));
        if (string.endsWith(".")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static final String format(double d2, int n) {
        String string = Format.sprintf(new StringBuffer("%.").append(n).append('f').toString(), new Parameters(d2));
        if (string.endsWith(".")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static final String format(float f2) {
        return Format.sprintf(DEFAULT_PRECISION_STR, new Parameters(f2));
    }

    public static final void out(Object[] objectArray) {
        System.out.println(Printf.outs(objectArray));
    }

    public static final void outl(Object[] objectArray) {
        if (null == objectArray) {
            klog.debug("null array");
            return;
        }
        if (objectArray.length == 0) {
            klog.debug("empty array");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("# of elements = ").append(objectArray.length).append('\n');
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            stringBuffer.append(objectArray[i2]).append(' ');
            if (i2 <= 10) continue;
            stringBuffer.append("\nand so on ...");
            break;
        }
        klog.debug(stringBuffer.toString());
    }

    public static final String outs(Object[] objectArray) {
        if (null == objectArray) {
            return "null array";
        }
        if (objectArray.length == 0) {
            return "empty array";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("# of elements = ").append(objectArray.length).append('\n');
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            stringBuffer.append(objectArray[i2]).append(' ');
        }
        return stringBuffer.toString();
    }

    public static final void out(ListModel listModel) {
        System.out.println(Printf.outs(listModel));
    }

    public static final void outl(ListModel listModel) {
        klog.debug(Printf.outs(listModel));
    }

    public static final String outs(ListModel listModel) {
        if (null == listModel) {
            return "null array";
        }
        if (listModel.getSize() == 0) {
            return "empty model";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("# of elements = ").append(listModel.getSize()).append('\n');
        for (int i2 = 0; i2 < listModel.getSize(); ++i2) {
            stringBuffer.append(listModel.getElementAt(i2)).append(" class: ").append(listModel.getElementAt(i2).getClass()).append('\n');
        }
        return stringBuffer.toString();
    }

    public static final void outl(DataFlavor[] dataFlavorArray) {
        klog.debug(Printf.outs(dataFlavorArray).toString());
    }

    public static final void out(DataFlavor[] dataFlavorArray) {
        System.out.println(Printf.outs(dataFlavorArray).toString());
    }

    public static final StringBuffer outs(DataFlavor[] dataFlavorArray) {
        if (dataFlavorArray == null) {
            return new StringBuffer("null flavor array");
        }
        StringBuffer stringBuffer = new StringBuffer("Flavors are\n");
        int n = dataFlavorArray.length;
        for (int i2 = 0; i2 < n && i2 < 5; ++i2) {
            if (dataFlavorArray[i2] == null) {
                stringBuffer.append("null flavor at: ").append(i2).append("\n");
                continue;
            }
            stringBuffer.append("[").append(i2).append("] ").append(dataFlavorArray[i2]).append('\n');
        }
        return stringBuffer;
    }

    public static final void outl(PersistentObject persistentObject) {
        klog.debug(Printf.outs(persistentObject).toString());
    }

    public static final void out(PersistentObject persistentObject) {
        System.out.println(Printf.outs(persistentObject).toString());
    }

    public static final StringBuffer outs(PersistentObject persistentObject) {
        if (persistentObject == null) {
            return new StringBuffer("Null Pob.Class");
        }
        StringBuffer stringBuffer = new StringBuffer("-------------------------------\n");
        stringBuffer.append("Id=").append(persistentObject.getId()).append("\n");
        stringBuffer.append("Name=").append(persistentObject.getName()).append("\n");
        stringBuffer.append("--------------------------------");
        return stringBuffer;
    }

    public static final void outl(RankedList rankedList) {
        klog.debug(Printf.outs(rankedList).toString());
    }

    public static final void out(RankedList rankedList) {
        System.out.println(Printf.outs(rankedList).toString());
    }

    public static final StringBuffer outs(RankedList rankedList) {
        if (rankedList == null) {
            return new StringBuffer("Null RankedList");
        }
        StringBuffer stringBuffer = new StringBuffer("-------------------------------\n");
        stringBuffer.append("Name=").append(rankedList.getName()).append("\n");
        stringBuffer.append("Size=").append(rankedList.getSize()).append("\n");
        for (int i2 = 0; i2 < rankedList.getSize(); ++i2) {
            stringBuffer.append(rankedList.getRankName(i2)).append('\t').append(rankedList.getScore(i2)).append('\n');
            if (i2 <= 10) continue;
            stringBuffer.append('\n').append(" and so on ...").append('\n');
            break;
        }
        stringBuffer.append("--------------------------------");
        return stringBuffer;
    }

    public static final void outl(LabelledVector labelledVector) {
        klog.debug(Printf.outs(labelledVector).toString());
    }

    public static final void out(LabelledVector labelledVector) {
        System.out.println(Printf.outs(labelledVector).toString());
    }

    public static final StringBuffer outs(LabelledVector labelledVector) {
        if (labelledVector == null) {
            return new StringBuffer("Null LabelledVector");
        }
        StringBuffer stringBuffer = new StringBuffer("-------------------------------\n");
        stringBuffer.append("Label=").append(labelledVector.getName()).append("\n");
        stringBuffer.append("Size=").append(labelledVector.getSize()).append("\n");
        for (int i2 = 0; i2 < labelledVector.getSize(); ++i2) {
            stringBuffer.append(labelledVector.getLabel(i2)).append('\t').append(labelledVector.getScore(i2)).append('\n');
            if (i2 <= 10) continue;
            stringBuffer.append('\n').append(" and so on ...").append('\n');
            break;
        }
        stringBuffer.append("--------------------------------");
        return stringBuffer;
    }

    public static final void outl(GeneSet geneSet) {
        klog.debug(Printf.outs(geneSet).toString());
    }

    public static final void out(GeneSet geneSet) {
        System.out.println(Printf.outs(geneSet).toString());
    }

    public static final StringBuffer outs(GeneSet geneSet) {
        StringBuffer stringBuffer = new StringBuffer();
        if (geneSet == null) {
            return new StringBuffer("Null GeneSet.Class");
        }
        stringBuffer.append("Name=").append(geneSet.getName()).append("\t# members: ").append(geneSet.getNumMembers()).append("\n");
        int n = 100;
        if (geneSet.getNumMembers() < n) {
            n = geneSet.getNumMembers();
        }
        for (int i2 = 0; i2 < n; ++i2) {
            stringBuffer.append(geneSet.getMember(i2)).append(' ');
        }
        stringBuffer.append('\n');
        return stringBuffer;
    }

    public static final void outl(GeneSet[] geneSetArray) {
        klog.debug(Printf.outs(geneSetArray).toString());
    }

    public static final void out(GeneSet[] geneSetArray) {
        System.out.println(Printf.outs(geneSetArray).toString());
    }

    public static final StringBuffer outs(GeneSet[] geneSetArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            stringBuffer.append(Printf.outs(geneSetArray[i2]));
        }
        return stringBuffer;
    }

    public static final void outl(Template template) {
        klog.debug(Printf.outs(template).toString());
    }

    public static final void out(Template template) {
        System.out.println(Printf.outs(template).toString());
    }

    public static final StringBuffer outs(Template template) {
        StringBuffer stringBuffer = new StringBuffer();
        if (template == null) {
            return new StringBuffer("null template");
        }
        stringBuffer.append("Template id: ").append(template.getId()).append(" name: ").append(template.getName()).append('\n');
        stringBuffer.append("Number of classes: ").append(template.getNumClasses()).append('\n');
        stringBuffer.append("Classes:\n");
        for (int i2 = 0; i2 < template.getNumClasses(); ++i2) {
            stringBuffer.append(template.getClass(i2).getMembershipInfo()).append('\n').append('\n');
        }
        stringBuffer.append('\n');
        stringBuffer.append("Template is continuous: ").append(template.isContinuous()).append('\n');
        stringBuffer.append("Template is aux: ").append(template.isAux()).append('\n');
        stringBuffer.append("Class of Interest (COI) is: ").append(template.getClassOfInterestName()).append(" Index: ").append(template.getClassOfInterestIndex());
        stringBuffer.append('\n');
        stringBuffer.append("Total # of items: ").append(template.getNumItems()).append('\n').append('\n');
        stringBuffer.append("Output as string follows:\n");
        stringBuffer.append(template.getAsString(false)).append('\n');
        return stringBuffer;
    }

    public static final void outlv(Template template) {
        klog.debug(Printf.outsv(template).toString());
    }

    public static final void outv(Template template) {
        System.out.println(Printf.outsv(template).toString());
    }

    public static final StringBuffer outsv(Template template) {
        StringBuffer stringBuffer = new StringBuffer();
        if (template == null) {
            return new StringBuffer("null template");
        }
        stringBuffer.append("Template id=").append(template.getId()).append(" name=").append(template.getName()).append('\n');
        stringBuffer.append("Number of classes=").append(template.getNumClasses()).append('\n');
        stringBuffer.append("Number of items=").append(template.getNumItems()).append('\n');
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(template.getNumItems());
        stringBuffer2.append(" ");
        stringBuffer2.append(template.getNumClasses());
        stringBuffer2.append(" ");
        stringBuffer2.append("1");
        stringBuffer2.append("\n");
        stringBuffer2.append("# ");
        for (int i2 = 0; i2 < template.getNumClasses(); ++i2) {
            stringBuffer2.append(template.getClassName(i2));
            if (i2 == template.getNumClasses() - 1) continue;
            stringBuffer2.append(" ");
        }
        stringBuffer2.append("\n");
        int[] nArray = template.getProfilePositionsOrdered();
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            int n = nArray[i3];
            stringBuffer2.append(template.getItemByProfilePos(n).getId()).append('[').append(n);
            stringBuffer2.append(']');
            if (i3 == template.getNumItems() - 1) continue;
            stringBuffer2.append(" ");
        }
        stringBuffer2.append("\n");
        stringBuffer.append(stringBuffer2).append('\n');
        return stringBuffer;
    }

    public static final void outl(Template[] templateArray) {
        klog.debug(Printf.outs(templateArray).toString());
    }

    public static final void out(Template[] templateArray) {
        System.out.println(Printf.outs(templateArray).toString());
    }

    public static final StringBuffer outs(Template[] templateArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (templateArray == null) {
            return new StringBuffer("null templates");
        }
        stringBuffer.append("Number of templates = ").append(templateArray.length).append('\n');
        for (int i2 = 0; i2 < templateArray.length; ++i2) {
            stringBuffer.append(Printf.outsv(templateArray[i2])).append('\n');
        }
        return stringBuffer;
    }

    public static final void outl(Template$Class template$Class) {
        klog.debug(Printf.outs(template$Class).toString());
    }

    public static final void out(Template$Class template$Class) {
        System.out.println(Printf.outs(template$Class).toString());
    }

    public static final StringBuffer outs(Template$Class template$Class) {
        StringBuffer stringBuffer = new StringBuffer();
        if (template$Class == null) {
            return new StringBuffer("null Template.Class");
        }
        stringBuffer.append("[Template.Class] name=").append(template$Class.getName()).append(" numitems=").append(template$Class.getSize()).append('\n');
        Template$Item[] template$ItemArray = template$Class.getItemsOrderedByProfilePos();
        for (int i2 = 0; i2 < template$ItemArray.length; ++i2) {
            stringBuffer.append(template$ItemArray[i2].getId()).append(" (").append(template$ItemArray[i2].getProfilePosition()).append(")");
        }
        stringBuffer.append('\n');
        return stringBuffer;
    }

    public static final void outl(Template$Item template$Item) {
        klog.debug(Printf.outs(template$Item).toString());
    }

    public static final void out(Template$Item template$Item) {
        System.out.println(Printf.outs(template$Item).toString());
    }

    public static final StringBuffer outs(Template$Item template$Item) {
        StringBuffer stringBuffer = new StringBuffer();
        if (template$Item == null) {
            return new StringBuffer("null Template.Item");
        }
        stringBuffer.append("Item id: ").append(template$Item.getId()).append(" pos: ").append(template$Item.getProfilePosition()).append('\n');
        return stringBuffer;
    }

    public static final void out(Matrix matrix) {
        System.out.println(Printf.outs(matrix));
    }

    public static final void outl(Matrix matrix) {
        klog.debug(Printf.outs(matrix));
    }

    public static final String outs(Matrix matrix) {
        if (matrix == null) {
            return "Null matrix";
        }
        StringBuffer stringBuffer = new StringBuffer("Matrix: numrows=" + matrix.getNumRow() + " numcols=" + matrix.getNumCol() + " immutable: " + matrix.isImmutable() + "\n");
        int n = 10;
        if (matrix.getNumRow() < n) {
            n = matrix.getNumRow();
        }
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < matrix.getNumCol(); ++i3) {
                stringBuffer.append(matrix.getElement(i2, i3)).append(' ');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public static final void outl(Set set) {
        klog.debug(Printf.outs(set).toString());
    }

    public static final void out(Set set) {
        System.out.println(Printf.outs(set).toString());
    }

    public static final StringBuffer outs(Set set) {
        if (set == null) {
            return new StringBuffer("null Set");
        }
        return Printf.outs(set.iterator());
    }

    public static final StringBuffer outs(Set set, String string) {
        if (set == null) {
            return new StringBuffer("NULL");
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = set.iterator();
        int n = set.size();
        int n2 = 0;
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (e2 == null) {
                stringBuffer.append("NULL");
            } else {
                stringBuffer.append(e2);
            }
            if (n2 != n - 1) {
                stringBuffer.append(string);
            }
            ++n2;
        }
        return stringBuffer;
    }

    public static final void outl(List list) {
        klog.debug(Printf.outs(list).toString());
    }

    public static final void out(List list) {
        System.out.println(Printf.outs(list).toString());
    }

    public static final StringBuffer outs(List list) {
        if (list == null) {
            return new StringBuffer("null List");
        }
        return Printf.outs(list.iterator());
    }

    public static final void outl(Iterator iterator) {
        klog.debug(Printf.outs(iterator).toString());
    }

    public static final void out(Iterator iterator) {
        System.out.println(Printf.outs(iterator).toString());
    }

    public static final StringBuffer outs(Iterator iterator) {
        StringBuffer stringBuffer = new StringBuffer();
        if (iterator == null) {
            return new StringBuffer("null Iterator");
        }
        int n = 0;
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (e2 == null) {
                stringBuffer.append("null");
            } else {
                stringBuffer.append(e2);
            }
            stringBuffer.append('\t');
            if (n % 20 == 0) {
                stringBuffer.append('\n');
            }
            if (n >= 100) {
                stringBuffer.append("\nand so on ...");
                break;
            }
            ++n;
        }
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        stringBuffer.append('\n');
        stringBuffer.append("Number of elements: ").append(n);
        stringBuffer.append('\n');
        return stringBuffer;
    }

    public final String toStringTabDelimited(GeneSet geneSet) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = geneSet.getMembers().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next()).append('\t');
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    public static final String outs(String[] stringArray, String string) {
        if (stringArray == null) {
            return "NULL_ARRAY";
        }
        if (stringArray.length == 0) {
            return "EMPTY_ARRAY";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuffer.append(stringArray[i2]);
            if (i2 == stringArray.length - 1) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static final String outs(TObjectIntHashMap tObjectIntHashMap) {
        StringBuffer stringBuffer = new StringBuffer();
        TObjectIntIterator tObjectIntIterator = tObjectIntHashMap.iterator();
        int n = tObjectIntHashMap.size();
        while (n-- > 0) {
            tObjectIntIterator.advance();
            stringBuffer.append(tObjectIntIterator.key()).append('\t').append(tObjectIntIterator.value()).append('\n');
        }
        return stringBuffer.toString();
    }

    public static final String outs(TIntIntHashMap tIntIntHashMap) {
        StringBuffer stringBuffer = new StringBuffer();
        TIntIntIterator tIntIntIterator = tIntIntHashMap.iterator();
        int n = tIntIntHashMap.size();
        while (n-- > 0) {
            tIntIntIterator.advance();
            stringBuffer.append(tIntIntIterator.key()).append('\t').append(tIntIntIterator.value()).append('\n');
        }
        return stringBuffer.toString();
    }

    private static final /* synthetic */ Logger access$000() {
        return klog;
    }
}

