/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome;

import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.charts.XChart;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.Template$Class;
import edu.mit.broad.genome.parsers.DataFormat;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.utils.Strings;
import edu.mit.broad.vdb.meg.Gene;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class NamingConventions {
    private static int kObjectCounter = 1;
    private static int kImageCounter = 1;
    private static final int MAX_FILE_LEN_ALLOWED = 100;
    private static final char[] BAD_PROBE_NAME_CHARS = new char[]{'?', ',', '\t', '\n', '\u001c'};
    private static final String DMEG_ = "DMEG_";

    public static final boolean isHTA(String string) {
        if ((string = string.toUpperCase()).startsWith("E") || string.startsWith("C")) {
            return false;
        }
        if (string.startsWith("5")) {
            return true;
        }
        throw new IllegalArgumentException("Unlnown cel file name: >" + string + "<");
    }

    public static final String getBgedSeriesName(File file) {
        return NamingConventions.getBgedSeriesName(file.getName());
    }

    public static final String getBgedSeriesName(String string) {
        String string2 = NamingConventions.removeExtension(string);
        String string3 = ParseUtils.string2strings(string2, "_", false)[0].toUpperCase();
        if (string3.startsWith("GSE") || string3.startsWith("BSE") || string3.startsWith("E-MEXP")) {
            return string3;
        }
        throw new IllegalArgumentException("Not a valid series id: " + string + " >" + string3);
    }

    public static final String parseCyto(String string) {
        if (NamingConventions.isNull(string)) {
            return null;
        }
        if (string.indexOf(112) == -1 && string.indexOf(113) == -1) {
            return null;
        }
        if (string.indexOf("pter") != -1 || string.indexOf("ptel") != -1) {
            return null;
        }
        if (string.indexOf("qter") != -1 || string.indexOf("qtel") != -1) {
            return null;
        }
        if (string.indexOf("cen") != -1) {
            return null;
        }
        if ((string = string.toLowerCase()).startsWith("x")) {
            string = "X" + string.substring(1, string.length());
        }
        if (string.startsWith("y")) {
            string = "Y" + string.substring(1, string.length());
        }
        if (!(string = ParseUtils.string2strings(string, "-.; |", false)[0]).startsWith("chr")) {
            return "chr" + string;
        }
        return string;
    }

    public static final boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static final String getPlateName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".-");
        return stringTokenizer.nextToken();
    }

    public static final String splitLongHashName(String string, String string2) {
        if (string == null || string.indexOf("#") == -1 || string.length() < 80) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '#') {
                stringBuffer.append(string2);
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static final String getPathTruncated(File file) {
        File file2 = file.getParentFile();
        if (file2 == null) {
            return file.getPath();
        }
        return "..." + File.separatorChar + file2.getName() + File.separator + file.getName();
    }

    public static final boolean isURL(String string) {
        return string.toLowerCase().startsWith("http") || string.toLowerCase().startsWith("www") || string.toLowerCase().startsWith("ftp");
    }

    public static final String titleize(String string) {
        if (NamingConventions.isNull(string)) {
            return "NULL";
        }
        if (string.startsWith("\"")) {
            string = string.substring(1, string.length());
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static final String symbolize(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).equals("---") || string.equalsIgnoreCase("NULL") || string.length() == 0) {
            return null;
        }
        if ((string = string.toUpperCase()).length() > 20) {
            return string.substring(0, 20).trim();
        }
        return string;
    }

    public static final String createNiceEnglishDate_for_dirs() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM");
        String string = simpleDateFormat.format((Object)date);
        simpleDateFormat = new SimpleDateFormat("dd");
        string = (string + simpleDateFormat.format((Object)date)).toLowerCase();
        return string;
    }

    public static final String nullize(String string) {
        if (NamingConventions.isNull(string)) {
            return null;
        }
        return string;
    }

    public static final boolean isNull(Gene gene) {
        return gene == null || NamingConventions.isNull(gene.getSymbol());
    }

    public static final boolean isNull(String string) {
        if (string == null) {
            return true;
        }
        if ((string = string.trim()).length() == 0) {
            return true;
        }
        if (string.equalsIgnoreCase("na")) {
            return true;
        }
        return string.equalsIgnoreCase("NULL");
    }

    public static final String parseUniqueFromMetaSetName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_u");
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return "MS" + string2;
    }

    public static final boolean isGoId(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("GO:");
    }

    public static final void enforceMegIdFormat(String string) {
        if (!string.startsWith("MEG") && !string.startsWith("DMEG")) {
            throw new IllegalArgumentException("Bad format for megid: " + string);
        }
        for (int i2 = 0; i2 < BAD_PROBE_NAME_CHARS.length; ++i2) {
            if (string.indexOf(BAD_PROBE_NAME_CHARS[i2]) == -1) continue;
            throw new IllegalArgumentException("Bad char in megid: " + string);
        }
    }

    public static final void enforceMegIdFormat(String[] stringArray) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            NamingConventions.enforceMegIdFormat(stringArray[i2]);
        }
    }

    public static final boolean isValidProbeName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter probeName cannot be null");
        }
        for (int i2 = 0; i2 < BAD_PROBE_NAME_CHARS.length; ++i2) {
            if (string.indexOf(BAD_PROBE_NAME_CHARS[i2]) == -1) continue;
            return false;
        }
        return true;
    }

    public static final boolean isDummyMeg(String string) {
        return string.startsWith(DMEG_);
    }

    public static final Set getSetFromDummyMegId(String string) {
        string = string.substring(DMEG_.length());
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\u001c");
        HashSet<String> hashSet = new HashSet<String>();
        while (stringTokenizer.hasMoreElements()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        return hashSet;
    }

    public static final void enforceUnigeneIdFormat(String string) {
        boolean bl = NamingConventions.isUnigeneIdFormat(string);
        if (!bl) {
            throw new IllegalArgumentException("Bad format for unigeneid: " + string);
        }
    }

    public static final boolean isUnigeneIdFormat(String string) {
        return string.startsWith("Hs.") || string.startsWith("Ms.");
    }

    public static final String removeExtension(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Param fileName cannot be null");
        }
        if (string.indexOf(".") == -1) {
            return string;
        }
        if (string.indexOf(35) != -1) {
            return string;
        }
        if (string.endsWith(".")) {
            return string.substring(0, string.length() - 1);
        }
        int n = string.lastIndexOf(46);
        if (-1 == n) {
            return string;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length());
        if (string3.length() <= 4) {
            return string2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "_");
        stringTokenizer.nextToken();
        StringBuffer stringBuffer = new StringBuffer("_");
        while (stringTokenizer.hasMoreElements()) {
            stringBuffer.append(stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreElements()) continue;
            stringBuffer.append("_");
        }
        if (stringBuffer.length() != 1) {
            return string2 + stringBuffer;
        }
        return string2;
    }

    public static final String removeExtension(PersistentObject persistentObject) {
        if (persistentObject == null) {
            throw new IllegalArgumentException("Parameter pob cannot be null");
        }
        return NamingConventions.removeExtension(persistentObject.getName());
    }

    public static final String generateName(XChart xChart) {
        return NamingConventions.createSafeFileName(xChart.getName()) + "_" + kImageCounter++;
    }

    public static final String generateNameForImage(String string) {
        return NamingConventions.createSafeFileName(string) + "_" + kImageCounter++;
    }

    public static final File createSafeFile(File file, String string) {
        return new File(file, NamingConventions.createSafeFileName(string));
    }

    public static final String createSafeFileName(String string) {
        string = string.trim();
        String string2 = string.replace('@', '_');
        string2 = string2.replace('#', '_');
        string2 = string2.replace(' ', '_');
        string2 = string2.replace('%', '_');
        string2 = string2.replace('$', '_');
        string2 = string2.replace(':', '_');
        string2 = string2.replace('*', '_');
        string2 = string2.replace('\\', '_');
        string2 = string2.replace('/', '_');
        if ((string2 = string2.replace('\u001c', '_')).length() >= 100) {
            String string3 = NamingConventions.getExtension(string2);
            string2 = string2.substring(0, 100) + "." + string3;
        }
        return string2;
    }

    public static final boolean isBadCharacter(String string, boolean bl, boolean bl2, boolean bl3) {
        if (string == null) {
            throw new IllegalArgumentException("Param name cannot be null");
        }
        string = string.trim();
        if (!bl && string.indexOf(" ") != -1) {
            return true;
        }
        if (string.indexOf(64) != -1) {
            return true;
        }
        if (string.indexOf(35) != -1) {
            return true;
        }
        if (!bl3 && string.indexOf(45) != -1) {
            return true;
        }
        if (string.indexOf(37) != -1) {
            return true;
        }
        if (string.indexOf(36) != -1) {
            return true;
        }
        if (string.indexOf(58) != -1) {
            return true;
        }
        if (string.indexOf(42) != -1) {
            return true;
        }
        if (string.indexOf(92) != -1) {
            return true;
        }
        return !bl2 && string.indexOf(47) != -1;
    }

    public static final Object[] parseReportTimestampFromName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            throw new IllegalArgumentException("Invalid rpt name format: " + string + " got tokens #: " + stringTokenizer.countTokens());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringTokenizer.nextToken()).append('.');
        stringBuffer.append(stringTokenizer.nextToken());
        return new Object[]{stringBuffer.toString(), new Long(Long.parseLong(stringTokenizer.nextToken()))};
    }

    public static final String generateName(PersistentObject persistentObject, String string, boolean bl) {
        if (persistentObject == null) {
            return NamingConventions._generateName(null, string, null);
        }
        String string2 = DataFormat.getExtension(persistentObject);
        return NamingConventions._generateName(persistentObject.getName(), string, string2, bl);
    }

    public static final String generateName(Dataset dataset, Template template, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(NamingConventions.removeExtension(dataset.getName())).append(".");
            stringBuffer.append(NamingConventions.removeExtension(template.getName()));
        } else {
            stringBuffer.append(dataset.getName()).append('.');
            stringBuffer.append(template.getName());
        }
        return stringBuffer.toString();
    }

    public static final String generateName(Template template, GeneSet geneSet, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(NamingConventions.removeExtension(template.getName())).append(".");
            stringBuffer.append(NamingConventions.removeExtension(geneSet.getName()));
        } else {
            stringBuffer.append(template.getName()).append('.');
            stringBuffer.append(geneSet.getName());
        }
        return stringBuffer.toString();
    }

    public static final String generateName(Dataset dataset, GeneSet geneSet, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(NamingConventions.removeExtension(dataset.getName())).append(".");
            stringBuffer.append(NamingConventions.removeExtension(geneSet.getName()));
        } else {
            stringBuffer.append(dataset.getName()).append('.');
            stringBuffer.append(geneSet.getName());
        }
        return stringBuffer.toString();
    }

    public static final String generateName(Dataset dataset, Template template, GeneSet geneSet) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(NamingConventions.removeExtension(dataset.getName())).append('.');
        stringBuffer.append(NamingConventions.removeExtension(template.getName())).append('.');
        stringBuffer.append(NamingConventions.removeExtension(geneSet.getName()));
        return stringBuffer.toString();
    }

    public static final String generateName(RankedList rankedList, Template template, GeneSet geneSet) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(NamingConventions.removeExtension(rankedList.getName())).append('.');
        if (template != null) {
            stringBuffer.append(NamingConventions.removeExtension(template.getName())).append('.');
        }
        stringBuffer.append(NamingConventions.removeExtension(geneSet.getName()));
        return stringBuffer.toString();
    }

    public static final String generateName(Dataset dataset, Template template, boolean bl, DataFormat dataFormat) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(NamingConventions.removeExtension(dataset.getName())).append(".");
            stringBuffer.append(NamingConventions.removeExtension(template.getName()));
        } else {
            stringBuffer.append(dataset.getName()).append('.');
            stringBuffer.append(template.getName());
        }
        stringBuffer.append('.').append(dataFormat.getExtension());
        return stringBuffer.toString();
    }

    public static final String generateName(Dataset dataset, Template$Class template$Class, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(NamingConventions.removeExtension(dataset.getName())).append(".");
            stringBuffer.append(NamingConventions.removeExtension(template$Class.getName()));
        } else {
            stringBuffer.append(dataset.getName()).append('.');
            stringBuffer.append(template$Class.getName());
        }
        return stringBuffer.toString();
    }

    public static final String generateName(PersistentObject persistentObject, String string) {
        return NamingConventions.generateName(persistentObject, string, false);
    }

    public static final String generateName(PersistentObject persistentObject) {
        return NamingConventions.generateName(persistentObject, null, false);
    }

    public static final String generateName(PersistentObject persistentObject, boolean bl) {
        return NamingConventions.generateName(persistentObject, null, bl);
    }

    public static final String generateLocName(int n, Dataset dataset) {
        return new StringBuffer(NamingConventions.removeExtension(dataset.getName())).append('.').append("tst").append(n).toString();
    }

    public static final String generateNonLocName(int n, Dataset dataset) {
        return new StringBuffer(NamingConventions.removeExtension(dataset.getName())).append('.').append("trn").append(n).toString();
    }

    public static final String generateLocName(int n, Template template) {
        return new StringBuffer(NamingConventions.removeExtension(template.getName())).append("#tst").append(n).toString();
    }

    public static final String generateNonLocName(int n, Template template) {
        return new StringBuffer(NamingConventions.removeExtension(template.getName())).append("#trn").append(n).toString();
    }

    public static final String generateLocName(int[] nArray, Template template) {
        String string = Printf.format(nArray, '_');
        StringBuffer stringBuffer = new StringBuffer(NamingConventions.removeExtension(template.getName())).append("#tst").append(string);
        return stringBuffer.toString();
    }

    public static final String generateNonLocName(int[] nArray, Template template) {
        String string = Printf.format(nArray, '_');
        StringBuffer stringBuffer = new StringBuffer(NamingConventions.removeExtension(template.getName())).append("#trn").append(string);
        return stringBuffer.toString();
    }

    public static final String generateLocName(int n, Dataset dataset, Template template) {
        StringBuffer stringBuffer = new StringBuffer(NamingConventions.generateName(dataset, template, true));
        return stringBuffer.append('.').append("tst").append(n).toString();
    }

    public static final String generateNonLocName(int n, Dataset dataset, Template template) {
        StringBuffer stringBuffer = new StringBuffer(NamingConventions.generateName(dataset, template, true));
        return stringBuffer.append('.').append("trn").append(n).toString();
    }

    public static final String generateName(String string) {
        return NamingConventions.generateName(string, false);
    }

    public static final String generateName(String string, boolean bl) {
        StringBuffer stringBuffer = bl ? new StringBuffer(NamingConventions.generateUniqueNameTag()) : new StringBuffer(NamingConventions.generateCounterNameTag());
        stringBuffer.append('.').append(string);
        return stringBuffer.toString();
    }

    public static final String generateName(boolean bl) {
        if (bl) {
            return NamingConventions.generateUniqueNameTag();
        }
        return NamingConventions.generateCounterNameTag();
    }

    public static final String generateName(Class clazz, boolean bl) {
        String string = DataFormat.getName(clazz);
        if (string == null) {
            string = "unknown." + clazz;
        }
        String string2 = DataFormat.getExtension(clazz);
        return NamingConventions._generateName(string, null, string2, bl);
    }

    public static final String generateName(Class clazz) {
        return NamingConventions.generateName(clazz, false);
    }

    public static final String generateName(Class clazz, String string, boolean bl) {
        String string2 = DataFormat.getName(clazz);
        if (string2 == null) {
            string2 = "unknown." + clazz;
        }
        String string3 = DataFormat.getExtension(clazz);
        return NamingConventions._generateName(string2, string, string3, bl);
    }

    public static final String generateName(Class clazz, String string) {
        return NamingConventions.generateName(clazz, string, false);
    }

    private static String _generateName(String string, String string2, String string3) {
        return NamingConventions._generateName(string, string2, string3, false);
    }

    private static String _generateName(String string, String string2, String string3, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(NamingConventions.removeExtension(string));
            stringBuffer.append('.');
        }
        if (string2 != null) {
            Strings.replace(string2, " ", "");
            Strings.replace(string2, "\t", "");
            stringBuffer.append(string2);
            stringBuffer.append('.');
        }
        if (bl) {
            stringBuffer.append(NamingConventions.generateUniqueNameTag());
        } else {
            stringBuffer.append(NamingConventions.generateCounterNameTag());
        }
        if (string3 != null) {
            stringBuffer.append('.');
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private static synchronized String generateUniqueNameTag() {
        return new StringBuffer().append(System.currentTimeMillis()).toString();
    }

    public static final synchronized String generateCounterNameTag() {
        return new StringBuffer().append(kObjectCounter++).toString();
    }

    public static final String getExtension(String string) {
        int n = string.lastIndexOf(".");
        String string2 = n == -1 ? "" : string.substring(n + 1);
        if (string.indexOf(".meta.") != -1) {
            return "meta." + string2;
        }
        return string2;
    }

    public static final String getExtension(File file) {
        return NamingConventions.getExtension(file.getName());
    }

    public static final String getExtensionLiberal(String string) {
        String string2;
        int n = string.lastIndexOf(".");
        if (n == -1) {
            string2 = "";
        } else {
            int n2;
            if (n > 0 && (n2 = string.lastIndexOf(".", n - 1)) != -1) {
                String string3 = string.substring(n2 + 1, n);
                if (string3.equalsIgnoreCase("gct")) {
                    return "gct";
                }
                if (string3.equalsIgnoreCase("res")) {
                    return "res";
                }
                if (string3.equalsIgnoreCase("pcl")) {
                    return "pcl";
                }
                if (string3.equalsIgnoreCase("gmx")) {
                    return "gmx";
                }
                if (string3.equalsIgnoreCase("gmt")) {
                    return "gmt";
                }
                if (string3.equalsIgnoreCase("rnk")) {
                    return "rnk";
                }
                if (string3.equalsIgnoreCase("cls")) {
                    return "cls";
                }
            }
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    public static final String getExtensionLiberal(File file) {
        return NamingConventions.getExtensionLiberal(file.getName());
    }
}

